/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.trace.samplers;

import org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.io.opentelemetry.api.internal.OtelEncodingUtils;
import org.rascalmpl.io.opentelemetry.api.trace.SpanKind;
import org.rascalmpl.io.opentelemetry.context.Context;
import org.rascalmpl.io.opentelemetry.sdk.trace.data.LinkData;
import org.rascalmpl.io.opentelemetry.sdk.trace.samplers.Sampler;
import org.rascalmpl.io.opentelemetry.sdk.trace.samplers.SamplingResult;
import org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.Math;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.text.DecimalFormat;
import org.rascalmpl.java.text.DecimalFormatSymbols;
import org.rascalmpl.java.util.List;
import org.rascalmpl.javax.annotation.Nullable;
import org.rascalmpl.javax.annotation.concurrent.Immutable;

@Immutable
final class TraceIdRatioBasedSampler
extends Object
implements Sampler {
    private static final SamplingResult POSITIVE_SAMPLING_RESULT = SamplingResult.recordAndSample();
    private static final SamplingResult NEGATIVE_SAMPLING_RESULT = SamplingResult.drop();
    private final long idUpperBound;
    private final String description;

    static TraceIdRatioBasedSampler create(double ratio) {
        if (ratio < 0.0 || ratio > 1.0) {
            throw new IllegalArgumentException((String)"org.rascalmpl.ratio must be in range [0.0, 1.0]");
        }
        long idUpperBound = ratio == 0.0 ? java.lang.Long.MIN_VALUE : (ratio == 1.0 ? java.lang.Long.MAX_VALUE : (long)(ratio * 9.223372036854776E18));
        return new TraceIdRatioBasedSampler(ratio, idUpperBound);
    }

    TraceIdRatioBasedSampler(double ratio, long idUpperBound) {
        this.idUpperBound = idUpperBound;
        this.description = new StringBuilder().append((String)"org.rascalmpl.TraceIdRatioBased{").append(TraceIdRatioBasedSampler.decimalFormat(ratio)).append((String)"org.rascalmpl.}").toString();
    }

    @Override
    public SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        return Math.abs((long)TraceIdRatioBasedSampler.getTraceIdRandomPart(traceId)) < this.idUpperBound ? POSITIVE_SAMPLING_RESULT : NEGATIVE_SAMPLING_RESULT;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof TraceIdRatioBasedSampler)) {
            return false;
        }
        TraceIdRatioBasedSampler that = (TraceIdRatioBasedSampler)obj;
        return this.idUpperBound == that.idUpperBound;
    }

    public int hashCode() {
        return Long.hashCode((long)this.idUpperBound);
    }

    public String toString() {
        return this.getDescription();
    }

    long getIdUpperBound() {
        return this.idUpperBound;
    }

    private static long getTraceIdRandomPart(String traceId) {
        return OtelEncodingUtils.longFromBase16String((CharSequence)traceId, 16);
    }

    private static String decimalFormat(double value) {
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance();
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat((String)"org.rascalmpl.0.000000", decimalFormatSymbols);
        return decimalFormat.format(value);
    }
}

