/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.net.bytebuddy.description.enumeration;

import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.reflect.Type;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.List;
import org.rascalmpl.net.bytebuddy.build.CachedReturnPlugin;
import org.rascalmpl.net.bytebuddy.description.NamedElement;
import org.rascalmpl.net.bytebuddy.description.type.TypeDescription;
import org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface EnumerationDescription
extends NamedElement {
    public String getValue();

    public TypeDescription getEnumerationType();

    public <T extends Enum<T>> T load(Class<T> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Latent
    extends AbstractBase {
        private final TypeDescription enumerationType;
        private final String value;

        public Latent(TypeDescription enumerationType, String value) {
            this.enumerationType = enumerationType;
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public TypeDescription getEnumerationType() {
            return this.enumerationType;
        }

        @Override
        public <T extends Enum<T>> T load(Class<T> type) {
            if (!this.enumerationType.represents((Type)type)) {
                throw new IllegalArgumentException(new StringBuilder().append(type).append((String)"org.rascalmpl. does not represent ").append((Object)this.enumerationType).toString());
            }
            return (T)Enum.valueOf(type, (String)this.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForLoadedEnumeration
    extends AbstractBase {
        private final Enum<?> value;

        public ForLoadedEnumeration(Enum<?> value) {
            this.value = value;
        }

        public static List<EnumerationDescription> asList(Enum<?>[] enumerations) {
            ArrayList result = new ArrayList(enumerations.length);
            for (Enum<?> enumeration : enumerations) {
                result.add((Object)new ForLoadedEnumeration(enumeration));
            }
            return result;
        }

        @Override
        public String getValue() {
            return this.value.name();
        }

        @Override
        public TypeDescription getEnumerationType() {
            return TypeDescription.ForLoadedType.of(this.value.getDeclaringClass());
        }

        @Override
        public <T extends Enum<T>> T load(Class<T> type) {
            return (T)(this.value.getDeclaringClass() == type ? this.value : Enum.valueOf(type, (String)this.value.name()));
        }
    }

    public static abstract class AbstractBase
    extends Object
    implements EnumerationDescription {
        private transient /* synthetic */ int hashCode;

        public String getActualName() {
            return this.getValue();
        }

        @CachedReturnPlugin.Enhance(value="org.rascalmpl.hashCode")
        public int hashCode() {
            int n;
            int n2;
            int n3 = this.hashCode;
            if (n3 != 0) {
                n2 = 0;
            } else {
                AbstractBase abstractBase = this;
                n2 = n = abstractBase.getValue().hashCode() + 31 * abstractBase.getEnumerationType().hashCode();
            }
            if (n == 0) {
                n = this.hashCode;
            } else {
                this.hashCode = n;
            }
            return n;
        }

        public boolean equals(@MaybeNull Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EnumerationDescription)) {
                return false;
            }
            EnumerationDescription enumerationDescription = (EnumerationDescription)other;
            return this.getEnumerationType().equals(enumerationDescription.getEnumerationType()) && this.getValue().equals((Object)enumerationDescription.getValue());
        }

        public String toString() {
            return this.getValue();
        }
    }
}

