/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.net.bytebuddy.description.method;

import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.ClassNotFoundException;
import org.rascalmpl.java.lang.SecurityException;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.reflect.Constructor;
import org.rascalmpl.java.lang.reflect.Method;
import org.rascalmpl.java.security.AccessController;
import org.rascalmpl.java.security.PrivilegedAction;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.List;
import org.rascalmpl.net.bytebuddy.build.AccessControllerPlugin;
import org.rascalmpl.net.bytebuddy.description.ByteCodeElement;
import org.rascalmpl.net.bytebuddy.description.method.MethodDescription;
import org.rascalmpl.net.bytebuddy.description.method.ParameterDescription;
import org.rascalmpl.net.bytebuddy.description.type.TypeDefinition;
import org.rascalmpl.net.bytebuddy.description.type.TypeDescription;
import org.rascalmpl.net.bytebuddy.description.type.TypeList;
import org.rascalmpl.net.bytebuddy.matcher.ElementMatcher;
import org.rascalmpl.net.bytebuddy.matcher.FilterableList;
import org.rascalmpl.net.bytebuddy.utility.dispatcher.JavaDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ParameterList<T extends ParameterDescription>
extends FilterableList<T, ParameterList<T>> {
    public TypeList.Generic asTypeList();

    public ByteCodeElement.Token.TokenList<ParameterDescription.Token> asTokenList(ElementMatcher<? super TypeDescription> var1);

    public ParameterList<ParameterDescription.InDefinedShape> asDefined();

    public boolean hasExplicitMetaData();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Empty<S extends ParameterDescription>
    extends FilterableList.Empty<S, ParameterList<S>>
    implements ParameterList<S> {
        @Override
        public boolean hasExplicitMetaData() {
            return true;
        }

        @Override
        public TypeList.Generic asTypeList() {
            return new TypeList.Generic.Empty();
        }

        @Override
        public ByteCodeElement.Token.TokenList<ParameterDescription.Token> asTokenList(ElementMatcher<? super TypeDescription> matcher) {
            return new ByteCodeElement.Token.TokenList((ByteCodeElement.Token[])new ParameterDescription.Token[0]);
        }

        @Override
        public ParameterList<ParameterDescription.InDefinedShape> asDefined() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeSubstituting
    extends AbstractBase<ParameterDescription.InGenericShape> {
        private final MethodDescription.InGenericShape declaringMethod;
        private final List<? extends ParameterDescription> parameterDescriptions;
        private final TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor;

        public TypeSubstituting(MethodDescription.InGenericShape declaringMethod, List<? extends ParameterDescription> parameterDescriptions, TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor) {
            this.declaringMethod = declaringMethod;
            this.parameterDescriptions = parameterDescriptions;
            this.visitor = visitor;
        }

        public ParameterDescription.InGenericShape get(int index) {
            return new ParameterDescription.TypeSubstituting(this.declaringMethod, (ParameterDescription)this.parameterDescriptions.get(index), this.visitor);
        }

        public int size() {
            return this.parameterDescriptions.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForTokens
    extends AbstractBase<ParameterDescription.InDefinedShape> {
        private final MethodDescription.InDefinedShape declaringMethod;
        private final List<? extends ParameterDescription.Token> tokens;

        public ForTokens(MethodDescription.InDefinedShape declaringMethod, List<? extends ParameterDescription.Token> tokens) {
            this.declaringMethod = declaringMethod;
            this.tokens = tokens;
        }

        public ParameterDescription.InDefinedShape get(int index) {
            int offset = this.declaringMethod.isStatic() ? 0 : 1;
            for (ParameterDescription.Token token : this.tokens.subList(0, index)) {
                offset += token.getType().getStackSize().getSize();
            }
            return new ParameterDescription.Latent(this.declaringMethod, (ParameterDescription.Token)this.tokens.get(index), index, offset);
        }

        public int size() {
            return this.tokens.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Explicit<S extends ParameterDescription>
    extends AbstractBase<S> {
        private final List<? extends S> parameterDescriptions;

        public Explicit(S ... parameterDescription) {
            this(Arrays.asList(parameterDescription));
        }

        public Explicit(List<? extends S> parameterDescriptions) {
            this.parameterDescriptions = parameterDescriptions;
        }

        public S get(int index) {
            return (S)((Object)((ParameterDescription)this.parameterDescriptions.get(index)));
        }

        public int size() {
            return this.parameterDescriptions.size();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ForTypes
        extends AbstractBase<ParameterDescription.InDefinedShape> {
            private final MethodDescription.InDefinedShape methodDescription;
            private final List<? extends TypeDefinition> typeDefinitions;

            public ForTypes(MethodDescription.InDefinedShape methodDescription, TypeDefinition ... typeDefinition) {
                this(methodDescription, (List<? extends TypeDefinition>)Arrays.asList((org.rascalmpl.java.lang.Object[])typeDefinition));
            }

            public ForTypes(MethodDescription.InDefinedShape methodDescription, List<? extends TypeDefinition> typeDefinitions) {
                this.methodDescription = methodDescription;
                this.typeDefinitions = typeDefinitions;
            }

            public ParameterDescription.InDefinedShape get(int index) {
                int offset = this.methodDescription.isStatic() ? 0 : 1;
                for (int previous = 0; previous < index; ++previous) {
                    offset += ((TypeDefinition)this.typeDefinitions.get(previous)).getStackSize().getSize();
                }
                return new ParameterDescription.Latent(this.methodDescription, ((TypeDefinition)this.typeDefinitions.get(index)).asGenericType(), index, offset);
            }

            public int size() {
                return this.typeDefinitions.size();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ForLoadedExecutable<T extends org.rascalmpl.java.lang.Object>
    extends AbstractBase<ParameterDescription.InDefinedShape> {
        protected static final Executable EXECUTABLE;
        protected final T executable;
        protected final ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource;
        private static final boolean ACCESS_CONTROLLER;

        protected ForLoadedExecutable(T executable, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource) {
            this.executable = executable;
            this.parameterAnnotationSource = parameterAnnotationSource;
        }

        @AccessControllerPlugin.Enhance
        private static <T extends org.rascalmpl.java.lang.Object> T doPrivileged(PrivilegedAction<T> privilegedAction) {
            PrivilegedAction<T> action;
            if (ACCESS_CONTROLLER) {
                return (T)AccessController.doPrivileged(privilegedAction);
            }
            return (T)action.run();
        }

        public static ParameterList<ParameterDescription.InDefinedShape> of(Constructor<?> constructor) {
            return ForLoadedExecutable.of(constructor, (ParameterDescription.ForLoadedParameter.ParameterAnnotationSource)new ParameterDescription.ForLoadedParameter.ParameterAnnotationSource.ForLoadedConstructor(constructor));
        }

        public static ParameterList<ParameterDescription.InDefinedShape> of(Constructor<?> constructor, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource) {
            return EXECUTABLE.isInstance((org.rascalmpl.java.lang.Object)constructor) ? new OfConstructor(constructor, parameterAnnotationSource) : new OfLegacyVmConstructor(constructor, parameterAnnotationSource);
        }

        public static ParameterList<ParameterDescription.InDefinedShape> of(Method method) {
            return ForLoadedExecutable.of(method, (ParameterDescription.ForLoadedParameter.ParameterAnnotationSource)new ParameterDescription.ForLoadedParameter.ParameterAnnotationSource.ForLoadedMethod(method));
        }

        public static ParameterList<ParameterDescription.InDefinedShape> of(Method method, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource) {
            return EXECUTABLE.isInstance((org.rascalmpl.java.lang.Object)method) ? new OfMethod(method, parameterAnnotationSource) : new OfLegacyVmMethod(method, parameterAnnotationSource);
        }

        public int size() {
            return EXECUTABLE.getParameterCount((org.rascalmpl.java.lang.Object)this.executable);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static {
            try {
                Class.forName((String)"org.rascalmpl.java.security.AccessController", (boolean)false, null);
                ACCESS_CONTROLLER = Boolean.parseBoolean((String)System.getProperty((String)"org.rascalmpl.net.bytebuddy.securitymanager", (String)"org.rascalmpl.true"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                ACCESS_CONTROLLER = false;
            }
            catch (SecurityException securityException) {
                ACCESS_CONTROLLER = true;
            }
            EXECUTABLE = ForLoadedExecutable.doPrivileged(JavaDispatcher.of(Executable.class));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class OfLegacyVmMethod
        extends AbstractBase<ParameterDescription.InDefinedShape> {
            private final Method method;
            private final Class<?>[] parameterType;
            private final ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource;

            protected OfLegacyVmMethod(Method method, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource) {
                this.method = method;
                this.parameterType = method.getParameterTypes();
                this.parameterAnnotationSource = parameterAnnotationSource;
            }

            public ParameterDescription.InDefinedShape get(int index) {
                return new ParameterDescription.ForLoadedParameter.OfLegacyVmMethod(this.method, index, this.parameterType, this.parameterAnnotationSource);
            }

            public int size() {
                return this.parameterType.length;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class OfLegacyVmConstructor
        extends AbstractBase<ParameterDescription.InDefinedShape> {
            private final Constructor<?> constructor;
            private final Class<?>[] parameterType;
            private final ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource;

            protected OfLegacyVmConstructor(Constructor<?> constructor, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource) {
                this.constructor = constructor;
                this.parameterType = constructor.getParameterTypes();
                this.parameterAnnotationSource = parameterAnnotationSource;
            }

            public ParameterDescription.InDefinedShape get(int index) {
                return new ParameterDescription.ForLoadedParameter.OfLegacyVmConstructor(this.constructor, index, this.parameterType, this.parameterAnnotationSource);
            }

            public int size() {
                return this.parameterType.length;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class OfMethod
        extends ForLoadedExecutable<Method> {
            protected OfMethod(Method method, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource) {
                super(method, parameterAnnotationSource);
            }

            public ParameterDescription.InDefinedShape get(int index) {
                return new ParameterDescription.ForLoadedParameter.OfMethod((Method)this.executable, index, this.parameterAnnotationSource);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class OfConstructor
        extends ForLoadedExecutable<Constructor<?>> {
            protected OfConstructor(Constructor<?> constructor, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource) {
                super(constructor, parameterAnnotationSource);
            }

            public ParameterDescription.InDefinedShape get(int index) {
                return new ParameterDescription.ForLoadedParameter.OfConstructor((Constructor)this.executable, index, this.parameterAnnotationSource);
            }
        }

        @JavaDispatcher.Proxied(value="org.rascalmpl.java.lang.reflect.Executable")
        protected static interface Executable {
            @JavaDispatcher.Instance
            @JavaDispatcher.Proxied(value="org.rascalmpl.isInstance")
            public boolean isInstance(org.rascalmpl.java.lang.Object var1);

            @JavaDispatcher.Proxied(value="org.rascalmpl.getParameterCount")
            public int getParameterCount(org.rascalmpl.java.lang.Object var1);

            @JavaDispatcher.Proxied(value="org.rascalmpl.getParameters")
            public org.rascalmpl.java.lang.Object[] getParameters(org.rascalmpl.java.lang.Object var1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractBase<S extends ParameterDescription>
    extends FilterableList.AbstractBase<S, ParameterList<S>>
    implements ParameterList<S> {
        @Override
        public boolean hasExplicitMetaData() {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ParameterDescription parameterDescription = (ParameterDescription)iterator.next();
                if (parameterDescription.isNamed() && parameterDescription.hasModifiers()) continue;
                return false;
            }
            return true;
        }

        @Override
        public ByteCodeElement.Token.TokenList<ParameterDescription.Token> asTokenList(ElementMatcher<? super TypeDescription> matcher) {
            ArrayList tokens = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ParameterDescription parameterDescription = (ParameterDescription)iterator.next();
                tokens.add((org.rascalmpl.java.lang.Object)parameterDescription.asToken(matcher));
            }
            return new ByteCodeElement.Token.TokenList<ParameterDescription.Token>((List<ParameterDescription.Token>)tokens);
        }

        @Override
        public TypeList.Generic asTypeList() {
            ArrayList types = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ParameterDescription parameterDescription = (ParameterDescription)iterator.next();
                types.add((org.rascalmpl.java.lang.Object)parameterDescription.getType());
            }
            return new TypeList.Generic.Explicit((List<? extends TypeDefinition>)types);
        }

        @Override
        public ParameterList<ParameterDescription.InDefinedShape> asDefined() {
            ArrayList declaredForms = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ParameterDescription parameterDescription = (ParameterDescription)iterator.next();
                declaredForms.add((org.rascalmpl.java.lang.Object)parameterDescription.asDefined());
            }
            return new Explicit<ParameterDescription.InDefinedShape>((List<ParameterDescription.InDefinedShape>)declaredForms);
        }

        @Override
        protected ParameterList<S> wrap(List<S> values) {
            return new Explicit<S>(values);
        }
    }
}

