/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.net.bytebuddy.dynamic.loading;

import org.rascalmpl.java.io.File;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.ClassLoader;
import org.rascalmpl.java.lang.ClassNotFoundException;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.Exception;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.java.lang.RuntimeException;
import org.rascalmpl.java.lang.SecurityException;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.lang.instrument.ClassDefinition;
import org.rascalmpl.java.lang.instrument.ClassFileTransformer;
import org.rascalmpl.java.lang.instrument.Instrumentation;
import org.rascalmpl.java.lang.instrument.UnmodifiableClassException;
import org.rascalmpl.java.security.AccessController;
import org.rascalmpl.java.security.PrivilegedAction;
import org.rascalmpl.java.security.ProtectionDomain;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.HashMap;
import org.rascalmpl.java.util.LinkedHashMap;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.concurrent.ConcurrentHashMap;
import org.rascalmpl.net.bytebuddy.agent.builder.AgentBuilder;
import org.rascalmpl.net.bytebuddy.build.AccessControllerPlugin;
import org.rascalmpl.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.rascalmpl.net.bytebuddy.description.type.TypeDescription;
import org.rascalmpl.net.bytebuddy.dynamic.ClassFileLocator;
import org.rascalmpl.net.bytebuddy.dynamic.loading.ClassInjector;
import org.rascalmpl.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.rascalmpl.net.bytebuddy.utility.JavaModule;
import org.rascalmpl.net.bytebuddy.utility.dispatcher.JavaDispatcher;
import org.rascalmpl.net.bytebuddy.utility.nullability.AlwaysNull;
import org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class ClassReloadingStrategy
extends org.rascalmpl.java.lang.Object
implements ClassLoadingStrategy<ClassLoader> {
    protected static final Dispatcher DISPATCHER;
    private final Instrumentation instrumentation;
    private final Strategy strategy;
    private final BootstrapInjection bootstrapInjection;
    private final Map<String, Class<?>> preregisteredTypes;
    private static final boolean ACCESS_CONTROLLER;

    public ClassReloadingStrategy(Instrumentation instrumentation, Strategy strategy) {
        this(instrumentation, strategy, BootstrapInjection.Disabled.INSTANCE, Collections.emptyMap());
    }

    protected ClassReloadingStrategy(Instrumentation instrumentation, Strategy strategy, BootstrapInjection bootstrapInjection, Map<String, Class<?>> preregisteredTypes) {
        this.instrumentation = instrumentation;
        this.strategy = strategy.validate(instrumentation);
        this.bootstrapInjection = bootstrapInjection;
        this.preregisteredTypes = preregisteredTypes;
    }

    @AccessControllerPlugin.Enhance
    private static <T extends org.rascalmpl.java.lang.Object> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        PrivilegedAction<T> action;
        if (ACCESS_CONTROLLER) {
            return (T)AccessController.doPrivileged(privilegedAction);
        }
        return (T)action.run();
    }

    public static ClassReloadingStrategy of(Instrumentation instrumentation) {
        if (DISPATCHER.isRetransformClassesSupported(instrumentation)) {
            return new ClassReloadingStrategy(instrumentation, Strategy.RETRANSFORMATION);
        }
        if (instrumentation.isRedefineClassesSupported()) {
            return new ClassReloadingStrategy(instrumentation, Strategy.REDEFINITION);
        }
        throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.Instrumentation does not support reloading of classes: ").append((org.rascalmpl.java.lang.Object)instrumentation).toString());
    }

    private static Instrumentation resolveByteBuddyAgentInstrumentation() {
        try {
            Class installer = ClassLoader.getSystemClassLoader().loadClass((String)"org.rascalmpl.net.bytebuddy.agent.Installer");
            JavaModule source = JavaModule.ofType(AgentBuilder.class);
            JavaModule target = JavaModule.ofType(installer);
            if (source != null && !source.canRead(target)) {
                Class module = Class.forName((String)"org.rascalmpl.java.lang.Module");
                module.getMethod((String)"org.rascalmpl.addReads", new Class[]{module}).invoke(source.unwrap(), new org.rascalmpl.java.lang.Object[]{target.unwrap()});
            }
            return (Instrumentation)installer.getMethod((String)"org.rascalmpl.getInstrumentation", new Class[0]).invoke(null, new org.rascalmpl.java.lang.Object[0]);
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new IllegalStateException((String)"org.rascalmpl.The Byte Buddy agent is not installed or not accessible", (Throwable)((Object)exception));
        }
    }

    public static ClassReloadingStrategy fromInstalledAgent() {
        return ClassReloadingStrategy.of(ClassReloadingStrategy.resolveByteBuddyAgentInstrumentation());
    }

    public static ClassReloadingStrategy fromInstalledAgent(Strategy strategy) {
        return new ClassReloadingStrategy(ClassReloadingStrategy.resolveByteBuddyAgentInstrumentation(), strategy);
    }

    @Override
    public Map<TypeDescription, Class<?>> load(@MaybeNull ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
        HashMap availableTypes = new HashMap(this.preregisteredTypes);
        for (Class type : this.instrumentation.getInitiatedClasses(classLoader)) {
            availableTypes.put((org.rascalmpl.java.lang.Object)TypeDescription.ForLoadedType.getName(type), (org.rascalmpl.java.lang.Object)type);
        }
        ConcurrentHashMap classDefinitions = new ConcurrentHashMap();
        HashMap loadedClasses = new HashMap();
        LinkedHashMap unloadedClasses = new LinkedHashMap();
        for (Map.Entry entry : types.entrySet()) {
            Class type = (Class)availableTypes.get((org.rascalmpl.java.lang.Object)((TypeDescription)entry.getKey()).getName());
            if (type != null) {
                classDefinitions.put((org.rascalmpl.java.lang.Object)type, (org.rascalmpl.java.lang.Object)new ClassDefinition(type, (byte[])entry.getValue()));
                loadedClasses.put(entry.getKey(), (org.rascalmpl.java.lang.Object)type);
                continue;
            }
            unloadedClasses.put(entry.getKey(), entry.getValue());
        }
        try {
            this.strategy.apply(this.instrumentation, (Map<Class<?>, ClassDefinition>)classDefinitions);
            if (!unloadedClasses.isEmpty()) {
                loadedClasses.putAll((classLoader == null ? this.bootstrapInjection.make(this.instrumentation) : new ClassInjector.UsingReflection(classLoader)).inject((Map<? extends TypeDescription, byte[]>)unloadedClasses));
            }
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalArgumentException((String)"org.rascalmpl.Could not locate classes for redefinition", (Throwable)((Object)exception));
        }
        catch (UnmodifiableClassException exception) {
            throw new IllegalStateException((String)"org.rascalmpl.Cannot redefine specified class", (Throwable)((Object)exception));
        }
        return loadedClasses;
    }

    public ClassReloadingStrategy reset(Class<?> ... type) throws IOException {
        return type.length == 0 ? this : this.reset(ClassFileLocator.ForClassLoader.of(type[0].getClassLoader()), type);
    }

    public ClassReloadingStrategy reset(ClassFileLocator classFileLocator, Class<?> ... type) throws IOException {
        if (type.length > 0) {
            try {
                this.strategy.reset(this.instrumentation, classFileLocator, Arrays.asList(type));
            }
            catch (ClassNotFoundException exception) {
                throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.Cannot locate types ").append(Arrays.toString(type)).toString(), (Throwable)((Object)exception));
            }
            catch (UnmodifiableClassException exception) {
                throw new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Cannot reset types ").append(Arrays.toString(type)).toString(), (Throwable)((Object)exception));
            }
        }
        return this;
    }

    public ClassReloadingStrategy enableBootstrapInjection(File folder) {
        return new ClassReloadingStrategy(this.instrumentation, this.strategy, new BootstrapInjection.Enabled(folder), this.preregisteredTypes);
    }

    public ClassReloadingStrategy preregistered(Class<?> ... type) {
        HashMap preregisteredTypes = new HashMap(this.preregisteredTypes);
        for (Class<?> aType : type) {
            preregisteredTypes.put((org.rascalmpl.java.lang.Object)TypeDescription.ForLoadedType.getName(aType), aType);
        }
        return new ClassReloadingStrategy(this.instrumentation, this.strategy, this.bootstrapInjection, (Map<String, Class<?>>)preregisteredTypes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            Class.forName((String)"org.rascalmpl.java.security.AccessController", (boolean)false, null);
            ACCESS_CONTROLLER = Boolean.parseBoolean((String)System.getProperty((String)"org.rascalmpl.net.bytebuddy.securitymanager", (String)"org.rascalmpl.true"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            ACCESS_CONTROLLER = false;
        }
        catch (SecurityException securityException) {
            ACCESS_CONTROLLER = true;
        }
        DISPATCHER = ClassReloadingStrategy.doPrivileged(JavaDispatcher.of(Dispatcher.class));
    }

    public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!this.strategy.equals((org.rascalmpl.java.lang.Object)((ClassReloadingStrategy)object).strategy)) {
            return false;
        }
        if (!this.instrumentation.equals((org.rascalmpl.java.lang.Object)((ClassReloadingStrategy)object).instrumentation)) {
            return false;
        }
        if (!this.bootstrapInjection.equals(((ClassReloadingStrategy)object).bootstrapInjection)) {
            return false;
        }
        return this.preregisteredTypes.equals(((ClassReloadingStrategy)object).preregisteredTypes);
    }

    public int hashCode() {
        return (((this.getClass().hashCode() * 31 + this.instrumentation.hashCode()) * 31 + this.strategy.hashCode()) * 31 + this.bootstrapInjection.hashCode()) * 31 + this.preregisteredTypes.hashCode();
    }

    protected static interface BootstrapInjection {
        public ClassInjector make(Instrumentation var1);

        @HashCodeAndEqualsPlugin.Enhance
        public static class Enabled
        extends org.rascalmpl.java.lang.Object
        implements BootstrapInjection {
            private final File folder;

            protected Enabled(File folder) {
                this.folder = folder;
            }

            public ClassInjector make(Instrumentation instrumentation) {
                return ClassInjector.UsingInstrumentation.of(this.folder, ClassInjector.UsingInstrumentation.Target.BOOTSTRAP, instrumentation);
            }

            public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.folder.equals((org.rascalmpl.java.lang.Object)((Enabled)object).folder);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.folder.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Disabled
        extends Enum<Disabled>
        implements BootstrapInjection {
            public static final /* enum */ Disabled INSTANCE = new Disabled((String)"org.rascalmpl.INSTANCE", 0);
            private static final /* synthetic */ Disabled[] $VALUES;

            public static Disabled[] values() {
                return (Disabled[])$VALUES.clone();
            }

            public static Disabled valueOf(String name) {
                return (Disabled)Enum.valueOf(Disabled.class, (String)name);
            }

            private Disabled() {
                super((String)string, n);
            }

            @Override
            public ClassInjector make(Instrumentation instrumentation) {
                throw new IllegalStateException((String)"org.rascalmpl.Bootstrap injection is not enabled");
            }

            static {
                $VALUES = new Disabled[]{INSTANCE};
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Strategy
    extends Enum<Strategy> {
        public static final /* enum */ Strategy REDEFINITION = new Strategy(true){

            @Override
            protected void apply(Instrumentation instrumentation, Map<Class<?>, ClassDefinition> classDefinitions) throws UnmodifiableClassException, ClassNotFoundException {
                instrumentation.redefineClasses((ClassDefinition[])classDefinitions.values().toArray((org.rascalmpl.java.lang.Object[])new ClassDefinition[0]));
            }

            @Override
            protected Strategy validate(Instrumentation instrumentation) {
                if (!instrumentation.isRedefineClassesSupported()) {
                    throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.Does not support redefinition: ").append((org.rascalmpl.java.lang.Object)instrumentation).toString());
                }
                return this;
            }

            @Override
            public void reset(Instrumentation instrumentation, ClassFileLocator classFileLocator, List<Class<?>> types) throws IOException, UnmodifiableClassException, ClassNotFoundException {
                HashMap classDefinitions = new HashMap(types.size());
                for (Class type : types) {
                    classDefinitions.put((org.rascalmpl.java.lang.Object)type, (org.rascalmpl.java.lang.Object)new ClassDefinition(type, classFileLocator.locate(TypeDescription.ForLoadedType.getName(type)).resolve()));
                }
                this.apply(instrumentation, (Map<Class<?>, ClassDefinition>)classDefinitions);
            }
        };
        public static final /* enum */ Strategy RETRANSFORMATION = new Strategy(false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void apply(Instrumentation instrumentation, Map<Class<?>, ClassDefinition> classDefinitions) throws UnmodifiableClassException {
                ClassRedefinitionTransformer classRedefinitionTransformer = new ClassRedefinitionTransformer(classDefinitions);
                2 var4_4 = this;
                synchronized (var4_4) {
                    DISPATCHER.addTransformer(instrumentation, classRedefinitionTransformer, true);
                    try {
                        DISPATCHER.retransformClasses(instrumentation, (Class[])classDefinitions.keySet().toArray((org.rascalmpl.java.lang.Object[])new Class[0]));
                        Object var6_5 = null;
                    }
                    catch (java.lang.Throwable throwable) {
                        Object var6_6 = null;
                        instrumentation.removeTransformer((ClassFileTransformer)classRedefinitionTransformer);
                        throw throwable;
                    }
                    instrumentation.removeTransformer((ClassFileTransformer)classRedefinitionTransformer);
                }
                classRedefinitionTransformer.assertTransformation();
            }

            @Override
            protected Strategy validate(Instrumentation instrumentation) {
                if (!DISPATCHER.isRetransformClassesSupported(instrumentation)) {
                    throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.Does not support retransformation: ").append((org.rascalmpl.java.lang.Object)instrumentation).toString());
                }
                return this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reset(Instrumentation instrumentation, ClassFileLocator classFileLocator, List<Class<?>> types) throws UnmodifiableClassException, ClassNotFoundException {
                for (Class type : types) {
                    if (DISPATCHER.isModifiableClass(instrumentation, type)) continue;
                    throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.Cannot modify type: ").append((org.rascalmpl.java.lang.Object)type).toString());
                }
                DISPATCHER.addTransformer(instrumentation, ClassResettingTransformer.INSTANCE, true);
                try {
                    DISPATCHER.retransformClasses(instrumentation, (Class[])types.toArray((org.rascalmpl.java.lang.Object[])new Class[0]));
                    Object var7_6 = null;
                }
                catch (java.lang.Throwable throwable) {
                    Object var7_7 = null;
                    instrumentation.removeTransformer((ClassFileTransformer)ClassResettingTransformer.INSTANCE);
                    throw throwable;
                }
                instrumentation.removeTransformer((ClassFileTransformer)ClassResettingTransformer.INSTANCE);
            }
        };
        @AlwaysNull
        private static final byte[] NO_REDEFINITION;
        private static final boolean REDEFINE_CLASSES = true;
        private final boolean redefinition;
        private static final /* synthetic */ Strategy[] $VALUES;

        public static Strategy[] values() {
            return (Strategy[])$VALUES.clone();
        }

        public static Strategy valueOf(String name) {
            return (Strategy)Enum.valueOf(Strategy.class, (String)name);
        }

        private Strategy(boolean redefinition) {
            super((String)string, n);
            this.redefinition = redefinition;
        }

        protected abstract void apply(Instrumentation var1, Map<Class<?>, ClassDefinition> var2) throws UnmodifiableClassException, ClassNotFoundException;

        protected abstract Strategy validate(Instrumentation var1);

        public boolean isRedefinition() {
            return this.redefinition;
        }

        public abstract void reset(Instrumentation var1, ClassFileLocator var2, List<Class<?>> var3) throws IOException, UnmodifiableClassException, ClassNotFoundException;

        static {
            $VALUES = new Strategy[]{REDEFINITION, RETRANSFORMATION};
            NO_REDEFINITION = null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static final class ClassResettingTransformer
        extends Enum<ClassResettingTransformer>
        implements ClassFileTransformer {
            public static final /* enum */ ClassResettingTransformer INSTANCE = new ClassResettingTransformer((String)"org.rascalmpl.INSTANCE", 0);
            private static final /* synthetic */ ClassResettingTransformer[] $VALUES;

            public static ClassResettingTransformer[] values() {
                return (ClassResettingTransformer[])$VALUES.clone();
            }

            public static ClassResettingTransformer valueOf(String name) {
                return (ClassResettingTransformer)Enum.valueOf(ClassResettingTransformer.class, (String)name);
            }

            private ClassResettingTransformer() {
                super((String)string, n);
            }

            @MaybeNull
            public byte[] transform(@MaybeNull ClassLoader classLoader, @MaybeNull String internalTypeName, @MaybeNull Class<?> classBeingRedefined, @MaybeNull ProtectionDomain protectionDomain, byte[] classfileBuffer) {
                return NO_REDEFINITION;
            }

            static {
                $VALUES = new ClassResettingTransformer[]{INSTANCE};
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class ClassRedefinitionTransformer
        extends org.rascalmpl.java.lang.Object
        implements ClassFileTransformer {
            private final Map<Class<?>, ClassDefinition> redefinedClasses;

            protected ClassRedefinitionTransformer(Map<Class<?>, ClassDefinition> redefinedClasses) {
                this.redefinedClasses = redefinedClasses;
            }

            @MaybeNull
            public byte[] transform(@MaybeNull ClassLoader classLoader, @MaybeNull String internalTypeName, @MaybeNull Class<?> classBeingRedefined, @MaybeNull ProtectionDomain protectionDomain, byte[] classfileBuffer) {
                if (internalTypeName == null) {
                    return NO_REDEFINITION;
                }
                ClassDefinition redefinedClass = (ClassDefinition)this.redefinedClasses.remove(classBeingRedefined);
                return redefinedClass == null ? NO_REDEFINITION : redefinedClass.getDefinitionClassFile();
            }

            public void assertTransformation() {
                if (!this.redefinedClasses.isEmpty()) {
                    throw new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Could not transform: ").append((org.rascalmpl.java.lang.Object)this.redefinedClasses.keySet()).toString());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JavaDispatcher.Proxied(value="org.rascalmpl.java.lang.instrument.Instrumentation")
    protected static interface Dispatcher {
        @JavaDispatcher.Proxied(value="org.rascalmpl.isModifiableClass")
        public boolean isModifiableClass(Instrumentation var1, Class<?> var2);

        @JavaDispatcher.Proxied(value="org.rascalmpl.isRetransformClassesSupported")
        public boolean isRetransformClassesSupported(Instrumentation var1);

        @JavaDispatcher.Proxied(value="org.rascalmpl.addTransformer")
        public void addTransformer(Instrumentation var1, ClassFileTransformer var2, boolean var3);

        @JavaDispatcher.Proxied(value="org.rascalmpl.retransformClasses")
        public void retransformClasses(Instrumentation var1, Class<?>[] var2) throws UnmodifiableClassException;
    }
}

