/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.net.bytebuddy.dynamic.loading;

import org.rascalmpl.edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.ClassLoader;
import org.rascalmpl.java.lang.ClassNotFoundException;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.lang.reflect.Method;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.HashMap;
import org.rascalmpl.java.util.LinkedHashMap;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.concurrent.atomic.AtomicBoolean;
import org.rascalmpl.net.bytebuddy.description.type.TypeDescription;
import org.rascalmpl.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InjectionClassLoader
extends ClassLoader {
    private final AtomicBoolean sealed;

    @SuppressFBWarnings(value={"org.rascalmpl.DP_DO_INSIDE_DO_PRIVILEGED"}, justification="org.rascalmpl.Must be invoked from targeting class loader type.")
    private static void doRegisterAsParallelCapable() {
        try {
            Method method = ClassLoader.class.getDeclaredMethod((String)"org.rascalmpl.registerAsParallelCapable", new Class[0]);
            method.setAccessible(true);
            method.invoke(null, new org.rascalmpl.java.lang.Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected InjectionClassLoader(@MaybeNull ClassLoader parent, boolean sealed) {
        super(parent);
        this.sealed = new AtomicBoolean(sealed);
    }

    public boolean isSealed() {
        return this.sealed.get();
    }

    public boolean seal() {
        return !this.sealed.getAndSet(true);
    }

    public Class<?> defineClass(String name, byte[] binaryRepresentation) throws ClassNotFoundException {
        return (Class)this.defineClasses((Map<String, byte[]>)Collections.singletonMap((org.rascalmpl.java.lang.Object)name, (org.rascalmpl.java.lang.Object)binaryRepresentation)).get((org.rascalmpl.java.lang.Object)name);
    }

    public Map<String, Class<?>> defineClasses(Map<String, byte[]> typeDefinitions) throws ClassNotFoundException {
        if (this.sealed.get()) {
            throw new IllegalStateException((String)"org.rascalmpl.Cannot inject classes into a sealed class loader");
        }
        return this.doDefineClasses(typeDefinitions);
    }

    protected abstract Map<String, Class<?>> doDefineClasses(Map<String, byte[]> var1) throws ClassNotFoundException;

    static {
        InjectionClassLoader.doRegisterAsParallelCapable();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Strategy
    extends Enum<Strategy>
    implements ClassLoadingStrategy<InjectionClassLoader> {
        public static final /* enum */ Strategy INSTANCE = new Strategy((String)"org.rascalmpl.INSTANCE", 0);
        private static final /* synthetic */ Strategy[] $VALUES;

        public static Strategy[] values() {
            return (Strategy[])$VALUES.clone();
        }

        public static Strategy valueOf(String name) {
            return (Strategy)Enum.valueOf(Strategy.class, (String)name);
        }

        private Strategy() {
            super((String)string, n);
        }

        @Override
        public Map<TypeDescription, Class<?>> load(@MaybeNull InjectionClassLoader classLoader, Map<TypeDescription, byte[]> types) {
            if (classLoader == null) {
                throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.Cannot add types to bootstrap class loader: ").append(types).toString());
            }
            LinkedHashMap typeDefinitions = new LinkedHashMap();
            HashMap typeDescriptions = new HashMap();
            for (Map.Entry entry : types.entrySet()) {
                typeDefinitions.put((org.rascalmpl.java.lang.Object)((TypeDescription)entry.getKey()).getName(), entry.getValue());
                typeDescriptions.put((org.rascalmpl.java.lang.Object)((TypeDescription)entry.getKey()).getName(), entry.getKey());
            }
            HashMap loadedTypes = new HashMap();
            try {
                for (Map.Entry entry : classLoader.defineClasses((Map<String, byte[]>)typeDefinitions).entrySet()) {
                    loadedTypes.put(typeDescriptions.get(entry.getKey()), entry.getValue());
                }
            }
            catch (ClassNotFoundException exception) {
                throw new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Cannot load classes: ").append(types).toString(), (Throwable)((Object)exception));
            }
            return loadedTypes;
        }

        static {
            $VALUES = new Strategy[]{INSTANCE};
        }
    }
}

