/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.net.bytebuddy.dynamic.scaffold.inline;

import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.rascalmpl.net.bytebuddy.description.method.MethodDescription;
import org.rascalmpl.net.bytebuddy.utility.RandomString;
import org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;

public interface MethodNameTransformer {
    public String transform(MethodDescription var1);

    @HashCodeAndEqualsPlugin.Enhance
    public static class Prefixing
    extends Object
    implements MethodNameTransformer {
        private static final String DEFAULT_PREFIX = "org.rascalmpl.original";
        private final String prefix;

        public Prefixing() {
            this((String)"org.rascalmpl.original");
        }

        public Prefixing(String prefix) {
            this.prefix = prefix;
        }

        public String transform(MethodDescription methodDescription) {
            return new StringBuilder().append(this.prefix).append(methodDescription.getInternalName()).toString();
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.prefix.equals((Object)((Prefixing)object).prefix);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.prefix.hashCode();
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class Suffixing
    extends Object
    implements MethodNameTransformer {
        private static final String DEFAULT_SUFFIX = "org.rascalmpl.original$";
        private final String suffix;

        public static MethodNameTransformer withRandomSuffix() {
            return new Suffixing(new StringBuilder().append((String)"org.rascalmpl.original$").append(RandomString.make()).toString());
        }

        public Suffixing(String suffix) {
            this.suffix = suffix;
        }

        public String transform(MethodDescription methodDescription) {
            return new StringBuilder().append(methodDescription.getInternalName()).append((String)"org.rascalmpl.$").append(this.suffix).toString();
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.suffix.equals((Object)((Suffixing)object).suffix);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.suffix.hashCode();
        }
    }
}

