/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.net.bytebuddy.implementation;

import org.rascalmpl.edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.Byte;
import org.rascalmpl.java.lang.Character;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.Double;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.Float;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.Math;
import org.rascalmpl.java.lang.Short;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.reflect.Type;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.List;
import org.rascalmpl.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.rascalmpl.net.bytebuddy.description.field.FieldDescription;
import org.rascalmpl.net.bytebuddy.description.method.MethodDescription;
import org.rascalmpl.net.bytebuddy.description.method.MethodList;
import org.rascalmpl.net.bytebuddy.description.type.TypeDefinition;
import org.rascalmpl.net.bytebuddy.description.type.TypeDescription;
import org.rascalmpl.net.bytebuddy.dynamic.scaffold.InstrumentedType;
import org.rascalmpl.net.bytebuddy.implementation.Implementation;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.Addition;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.Multiplication;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.StackSize;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.member.FieldAccess;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.member.MethodReturn;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.rascalmpl.net.bytebuddy.jar.asm.Label;
import org.rascalmpl.net.bytebuddy.jar.asm.MethodVisitor;
import org.rascalmpl.net.bytebuddy.matcher.ElementMatcher;
import org.rascalmpl.net.bytebuddy.matcher.ElementMatchers;
import org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class HashCodeMethod
extends org.rascalmpl.java.lang.Object
implements Implementation {
    private static final int DEFAULT_OFFSET = 17;
    private static final int DEFAULT_MULTIPLIER = 31;
    private static final MethodDescription.InDefinedShape HASH_CODE = (MethodDescription.InDefinedShape)((MethodList)TypeDescription.ForLoadedType.of(org.rascalmpl.java.lang.Object.class).getDeclaredMethods().filter(ElementMatchers.isHashCode())).getOnly();
    private static final MethodDescription.InDefinedShape GET_CLASS = (MethodDescription.InDefinedShape)((MethodList)TypeDescription.ForLoadedType.of(org.rascalmpl.java.lang.Object.class).getDeclaredMethods().filter(ElementMatchers.named((String)"org.rascalmpl.getClass").and(ElementMatchers.takesArguments(0)))).getOnly();
    private final OffsetProvider offsetProvider;
    private final int multiplier;
    private final ElementMatcher.Junction<? super FieldDescription.InDefinedShape> ignored;
    private final ElementMatcher.Junction<? super FieldDescription.InDefinedShape> nonNullable;

    protected HashCodeMethod(OffsetProvider offsetProvider) {
        this(offsetProvider, 31, ElementMatchers.none(), ElementMatchers.none());
    }

    private HashCodeMethod(OffsetProvider offsetProvider, int multiplier, ElementMatcher.Junction<? super FieldDescription.InDefinedShape> ignored, ElementMatcher.Junction<? super FieldDescription.InDefinedShape> nonNullable) {
        this.offsetProvider = offsetProvider;
        this.multiplier = multiplier;
        this.ignored = ignored;
        this.nonNullable = nonNullable;
    }

    public static HashCodeMethod usingSuperClassOffset() {
        return new HashCodeMethod(OffsetProvider.ForSuperMethodCall.INSTANCE);
    }

    public static HashCodeMethod usingTypeHashOffset(boolean dynamic) {
        return new HashCodeMethod((OffsetProvider)(dynamic ? OffsetProvider.ForDynamicTypeHash.INSTANCE : OffsetProvider.ForStaticTypeHash.INSTANCE));
    }

    public static HashCodeMethod usingDefaultOffset() {
        return HashCodeMethod.usingOffset(17);
    }

    public static HashCodeMethod usingOffset(int value) {
        return new HashCodeMethod(new OffsetProvider.ForFixedValue(value));
    }

    public HashCodeMethod withIgnoredFields(ElementMatcher<? super FieldDescription.InDefinedShape> ignored) {
        return new HashCodeMethod(this.offsetProvider, this.multiplier, this.ignored.or(ignored), this.nonNullable);
    }

    public HashCodeMethod withNonNullableFields(ElementMatcher<? super FieldDescription.InDefinedShape> nonNullable) {
        return new HashCodeMethod(this.offsetProvider, this.multiplier, this.ignored, this.nonNullable.or(nonNullable));
    }

    public Implementation withMultiplier(int multiplier) {
        if (multiplier == 0) {
            throw new IllegalArgumentException((String)"org.rascalmpl.Hash code multiplier must not be zero");
        }
        return new HashCodeMethod(this.offsetProvider, multiplier, this.ignored, this.nonNullable);
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return instrumentedType;
    }

    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        if (implementationTarget.getInstrumentedType().isInterface()) {
            throw new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Cannot implement meaningful hash code method for ").append((org.rascalmpl.java.lang.Object)implementationTarget.getInstrumentedType()).toString());
        }
        return new Appender(this.offsetProvider.resolve(implementationTarget.getInstrumentedType()), this.multiplier, implementationTarget.getInstrumentedType().getDeclaredFields().filter(ElementMatchers.not(ElementMatchers.isStatic().or(this.ignored))), this.nonNullable);
    }

    public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (this.multiplier != ((HashCodeMethod)object).multiplier) {
            return false;
        }
        if (!this.offsetProvider.equals(((HashCodeMethod)object).offsetProvider)) {
            return false;
        }
        if (!this.ignored.equals(((HashCodeMethod)object).ignored)) {
            return false;
        }
        return this.nonNullable.equals(((HashCodeMethod)object).nonNullable);
    }

    public int hashCode() {
        return (((this.getClass().hashCode() * 31 + this.offsetProvider.hashCode()) * 31 + this.multiplier) * 31 + this.ignored.hashCode()) * 31 + this.nonNullable.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    protected static class Appender
    extends org.rascalmpl.java.lang.Object
    implements ByteCodeAppender {
        private final StackManipulation initialValue;
        private final int multiplier;
        private final List<FieldDescription.InDefinedShape> fieldDescriptions;
        private final ElementMatcher<? super FieldDescription.InDefinedShape> nonNullable;

        protected Appender(StackManipulation initialValue, int multiplier, List<FieldDescription.InDefinedShape> fieldDescriptions, ElementMatcher<? super FieldDescription.InDefinedShape> nonNullable) {
            this.initialValue = initialValue;
            this.multiplier = multiplier;
            this.fieldDescriptions = fieldDescriptions;
            this.nonNullable = nonNullable;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            if (instrumentedMethod.isStatic()) {
                throw new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Hash code method must not be static: ").append((org.rascalmpl.java.lang.Object)instrumentedMethod).toString());
            }
            if (!instrumentedMethod.getReturnType().represents((Type)Integer.TYPE)) {
                throw new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Hash code method does not return primitive integer: ").append((org.rascalmpl.java.lang.Object)instrumentedMethod).toString());
            }
            ArrayList stackManipulations = new ArrayList(2 + this.fieldDescriptions.size() * 8);
            stackManipulations.add((org.rascalmpl.java.lang.Object)this.initialValue);
            int padding = 0;
            for (FieldDescription.InDefinedShape fieldDescription : this.fieldDescriptions) {
                stackManipulations.add((org.rascalmpl.java.lang.Object)IntegerConstant.forValue(this.multiplier));
                stackManipulations.add((org.rascalmpl.java.lang.Object)Multiplication.INTEGER);
                stackManipulations.add((org.rascalmpl.java.lang.Object)MethodVariableAccess.loadThis());
                stackManipulations.add((org.rascalmpl.java.lang.Object)FieldAccess.forField(fieldDescription).read());
                NullValueGuard.NoOp nullValueGuard = fieldDescription.getType().isPrimitive() || fieldDescription.getType().isArray() || this.nonNullable.matches(fieldDescription) ? NullValueGuard.NoOp.INSTANCE : new NullValueGuard.UsingJump(instrumentedMethod);
                stackManipulations.add((org.rascalmpl.java.lang.Object)nullValueGuard.before());
                stackManipulations.add((org.rascalmpl.java.lang.Object)ValueTransformer.of(fieldDescription.getType()));
                stackManipulations.add((org.rascalmpl.java.lang.Object)Addition.INTEGER);
                stackManipulations.add((org.rascalmpl.java.lang.Object)nullValueGuard.after());
                padding = Math.max((int)padding, (int)nullValueGuard.getRequiredVariablePadding());
            }
            stackManipulations.add((org.rascalmpl.java.lang.Object)MethodReturn.INTEGER);
            return new ByteCodeAppender.Size(new StackManipulation.Compound((List<? extends StackManipulation>)stackManipulations).apply(methodVisitor, implementationContext).getMaximalSize(), instrumentedMethod.getStackSize() + padding);
        }

        public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (this.multiplier != ((Appender)object).multiplier) {
                return false;
            }
            if (!this.initialValue.equals(((Appender)object).initialValue)) {
                return false;
            }
            if (!this.fieldDescriptions.equals(((Appender)object).fieldDescriptions)) {
                return false;
            }
            return this.nonNullable.equals(((Appender)object).nonNullable);
        }

        public int hashCode() {
            return (((this.getClass().hashCode() * 31 + this.initialValue.hashCode()) * 31 + this.multiplier) * 31 + this.fieldDescriptions.hashCode()) * 31 + this.nonNullable.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class ValueTransformer
    extends Enum<ValueTransformer>
    implements StackManipulation {
        public static final /* enum */ ValueTransformer LONG = new ValueTransformer(){

            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitInsn(92);
                methodVisitor.visitIntInsn(16, 32);
                methodVisitor.visitInsn(125);
                methodVisitor.visitInsn(131);
                methodVisitor.visitInsn(136);
                return new StackManipulation.Size(-1, 3);
            }
        };
        public static final /* enum */ ValueTransformer FLOAT = new ValueTransformer(){

            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, (String)"org/rascalmpl/java/lang/Float", (String)"org.rascalmpl.floatToIntBits", (String)"org.rascalmpl.(F)I", false);
                return StackManipulation.Size.ZERO;
            }
        };
        public static final /* enum */ ValueTransformer DOUBLE = new ValueTransformer(){

            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, (String)"org/rascalmpl/java/lang/Double", (String)"org.rascalmpl.doubleToLongBits", (String)"org.rascalmpl.(D)J", false);
                methodVisitor.visitInsn(92);
                methodVisitor.visitIntInsn(16, 32);
                methodVisitor.visitInsn(125);
                methodVisitor.visitInsn(131);
                methodVisitor.visitInsn(136);
                return new StackManipulation.Size(-1, 3);
            }
        };
        public static final /* enum */ ValueTransformer BOOLEAN_ARRAY = new ValueTransformer(){

            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, (String)"org/rascalmpl/java/util/Arrays", (String)"org.rascalmpl.hashCode", (String)"org.rascalmpl.([Z)I", false);
                return StackManipulation.Size.ZERO;
            }
        };
        public static final /* enum */ ValueTransformer BYTE_ARRAY = new ValueTransformer(){

            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, (String)"org/rascalmpl/java/util/Arrays", (String)"org.rascalmpl.hashCode", (String)"org.rascalmpl.([B)I", false);
                return StackManipulation.Size.ZERO;
            }
        };
        public static final /* enum */ ValueTransformer SHORT_ARRAY = new ValueTransformer(){

            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, (String)"org/rascalmpl/java/util/Arrays", (String)"org.rascalmpl.hashCode", (String)"org.rascalmpl.([S)I", false);
                return StackManipulation.Size.ZERO;
            }
        };
        public static final /* enum */ ValueTransformer CHARACTER_ARRAY = new ValueTransformer(){

            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, (String)"org/rascalmpl/java/util/Arrays", (String)"org.rascalmpl.hashCode", (String)"org.rascalmpl.([C)I", false);
                return StackManipulation.Size.ZERO;
            }
        };
        public static final /* enum */ ValueTransformer INTEGER_ARRAY = new ValueTransformer(){

            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, (String)"org/rascalmpl/java/util/Arrays", (String)"org.rascalmpl.hashCode", (String)"org.rascalmpl.([I)I", false);
                return StackManipulation.Size.ZERO;
            }
        };
        public static final /* enum */ ValueTransformer LONG_ARRAY = new ValueTransformer(){

            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, (String)"org/rascalmpl/java/util/Arrays", (String)"org.rascalmpl.hashCode", (String)"org.rascalmpl.([J)I", false);
                return StackManipulation.Size.ZERO;
            }
        };
        public static final /* enum */ ValueTransformer FLOAT_ARRAY = new ValueTransformer(){

            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, (String)"org/rascalmpl/java/util/Arrays", (String)"org.rascalmpl.hashCode", (String)"org.rascalmpl.([F)I", false);
                return StackManipulation.Size.ZERO;
            }
        };
        public static final /* enum */ ValueTransformer DOUBLE_ARRAY = new ValueTransformer(){

            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, (String)"org/rascalmpl/java/util/Arrays", (String)"org.rascalmpl.hashCode", (String)"org.rascalmpl.([D)I", false);
                return StackManipulation.Size.ZERO;
            }
        };
        public static final /* enum */ ValueTransformer REFERENCE_ARRAY = new ValueTransformer(){

            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, (String)"org/rascalmpl/java/util/Arrays", (String)"org.rascalmpl.hashCode", (String)"org/rascalmpl/([Ljava/lang/Object;)I", false);
                return StackManipulation.Size.ZERO;
            }
        };
        public static final /* enum */ ValueTransformer NESTED_ARRAY = new ValueTransformer(){

            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, (String)"org/rascalmpl/java/util/Arrays", (String)"org.rascalmpl.deepHashCode", (String)"org/rascalmpl/([Ljava/lang/Object;)I", false);
                return StackManipulation.Size.ZERO;
            }
        };
        private static final /* synthetic */ ValueTransformer[] $VALUES;

        public static ValueTransformer[] values() {
            return (ValueTransformer[])$VALUES.clone();
        }

        public static ValueTransformer valueOf(String name) {
            return (ValueTransformer)Enum.valueOf(ValueTransformer.class, (String)name);
        }

        private ValueTransformer() {
            super((String)string, n);
        }

        @SuppressFBWarnings(value={"org.rascalmpl.NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="org.rascalmpl.Assuming component type for array type.")
        public static StackManipulation of(TypeDefinition typeDefinition) {
            if (typeDefinition.represents((Type)Boolean.TYPE) || typeDefinition.represents((Type)Byte.TYPE) || typeDefinition.represents((Type)Short.TYPE) || typeDefinition.represents((Type)Character.TYPE) || typeDefinition.represents((Type)Integer.TYPE)) {
                return StackManipulation.Trivial.INSTANCE;
            }
            if (typeDefinition.represents((Type)Long.TYPE)) {
                return LONG;
            }
            if (typeDefinition.represents((Type)Float.TYPE)) {
                return FLOAT;
            }
            if (typeDefinition.represents((Type)Double.TYPE)) {
                return DOUBLE;
            }
            if (typeDefinition.represents((Type)boolean[].class)) {
                return BOOLEAN_ARRAY;
            }
            if (typeDefinition.represents((Type)byte[].class)) {
                return BYTE_ARRAY;
            }
            if (typeDefinition.represents((Type)short[].class)) {
                return SHORT_ARRAY;
            }
            if (typeDefinition.represents((Type)char[].class)) {
                return CHARACTER_ARRAY;
            }
            if (typeDefinition.represents((Type)int[].class)) {
                return INTEGER_ARRAY;
            }
            if (typeDefinition.represents((Type)long[].class)) {
                return LONG_ARRAY;
            }
            if (typeDefinition.represents((Type)float[].class)) {
                return FLOAT_ARRAY;
            }
            if (typeDefinition.represents((Type)double[].class)) {
                return DOUBLE_ARRAY;
            }
            if (typeDefinition.isArray()) {
                return typeDefinition.getComponentType().isArray() ? NESTED_ARRAY : REFERENCE_ARRAY;
            }
            return MethodInvocation.invoke(HASH_CODE).virtual(typeDefinition.asErasure());
        }

        @Override
        public boolean isValid() {
            return true;
        }

        static {
            $VALUES = new ValueTransformer[]{LONG, FLOAT, DOUBLE, BOOLEAN_ARRAY, BYTE_ARRAY, SHORT_ARRAY, CHARACTER_ARRAY, INTEGER_ARRAY, LONG_ARRAY, FLOAT_ARRAY, DOUBLE_ARRAY, REFERENCE_ARRAY, NESTED_ARRAY};
        }
    }

    protected static interface NullValueGuard {
        public StackManipulation before();

        public StackManipulation after();

        public int getRequiredVariablePadding();

        @HashCodeAndEqualsPlugin.Enhance
        public static class UsingJump
        extends org.rascalmpl.java.lang.Object
        implements NullValueGuard {
            private final MethodDescription instrumentedMethod;
            private final Label label;

            protected UsingJump(MethodDescription instrumentedMethod) {
                this.instrumentedMethod = instrumentedMethod;
                this.label = new Label();
            }

            public StackManipulation before() {
                return new BeforeInstruction();
            }

            public StackManipulation after() {
                return new AfterInstruction();
            }

            public int getRequiredVariablePadding() {
                return 1;
            }

            public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.instrumentedMethod.equals(((UsingJump)object).instrumentedMethod)) {
                    return false;
                }
                return this.label.equals(((UsingJump)object).label);
            }

            public int hashCode() {
                return (this.getClass().hashCode() * 31 + this.instrumentedMethod.hashCode()) * 31 + this.label.hashCode();
            }

            @HashCodeAndEqualsPlugin.Enhance(includeSyntheticFields=true)
            protected class AfterInstruction
            extends StackManipulation.AbstractBase {
                protected AfterInstruction() {
                }

                public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                    methodVisitor.visitLabel(UsingJump.this.label);
                    implementationContext.getFrameGeneration().same1(methodVisitor, TypeDescription.ForLoadedType.of(Integer.TYPE), (List<? extends TypeDefinition>)Arrays.asList((org.rascalmpl.java.lang.Object[])new TypeDescription[]{implementationContext.getInstrumentedType(), TypeDescription.ForLoadedType.of(org.rascalmpl.java.lang.Object.class)}));
                    return StackManipulation.Size.ZERO;
                }

                public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return UsingJump.this.equals(((AfterInstruction)object).UsingJump.this);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + UsingJump.this.hashCode();
                }
            }

            @HashCodeAndEqualsPlugin.Enhance(includeSyntheticFields=true)
            protected class BeforeInstruction
            extends StackManipulation.AbstractBase {
                protected BeforeInstruction() {
                }

                public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                    methodVisitor.visitVarInsn(58, UsingJump.this.instrumentedMethod.getStackSize());
                    methodVisitor.visitVarInsn(25, UsingJump.this.instrumentedMethod.getStackSize());
                    methodVisitor.visitJumpInsn(198, UsingJump.this.label);
                    methodVisitor.visitVarInsn(25, UsingJump.this.instrumentedMethod.getStackSize());
                    return StackManipulation.Size.ZERO;
                }

                public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return UsingJump.this.equals(((BeforeInstruction)object).UsingJump.this);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + UsingJump.this.hashCode();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class NoOp
        extends Enum<NoOp>
        implements NullValueGuard {
            public static final /* enum */ NoOp INSTANCE = new NoOp((String)"org.rascalmpl.INSTANCE", 0);
            private static final /* synthetic */ NoOp[] $VALUES;

            public static NoOp[] values() {
                return (NoOp[])$VALUES.clone();
            }

            public static NoOp valueOf(String name) {
                return (NoOp)Enum.valueOf(NoOp.class, (String)name);
            }

            private NoOp() {
                super((String)string, n);
            }

            @Override
            public StackManipulation before() {
                return StackManipulation.Trivial.INSTANCE;
            }

            @Override
            public StackManipulation after() {
                return StackManipulation.Trivial.INSTANCE;
            }

            @Override
            public int getRequiredVariablePadding() {
                return StackSize.ZERO.getSize();
            }

            static {
                $VALUES = new NoOp[]{INSTANCE};
            }
        }
    }

    protected static interface OffsetProvider {
        public StackManipulation resolve(TypeDescription var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class ForDynamicTypeHash
        extends Enum<ForDynamicTypeHash>
        implements OffsetProvider {
            public static final /* enum */ ForDynamicTypeHash INSTANCE = new ForDynamicTypeHash((String)"org.rascalmpl.INSTANCE", 0);
            private static final /* synthetic */ ForDynamicTypeHash[] $VALUES;

            public static ForDynamicTypeHash[] values() {
                return (ForDynamicTypeHash[])$VALUES.clone();
            }

            public static ForDynamicTypeHash valueOf(String name) {
                return (ForDynamicTypeHash)Enum.valueOf(ForDynamicTypeHash.class, (String)name);
            }

            private ForDynamicTypeHash() {
                super((String)string, n);
            }

            @Override
            public StackManipulation resolve(TypeDescription instrumentedType) {
                return new StackManipulation.Compound(MethodVariableAccess.loadThis(), MethodInvocation.invoke(GET_CLASS).virtual(instrumentedType), MethodInvocation.invoke(HASH_CODE).virtual(TypeDescription.ForLoadedType.of(Class.class)));
            }

            static {
                $VALUES = new ForDynamicTypeHash[]{INSTANCE};
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class ForStaticTypeHash
        extends Enum<ForStaticTypeHash>
        implements OffsetProvider {
            public static final /* enum */ ForStaticTypeHash INSTANCE = new ForStaticTypeHash((String)"org.rascalmpl.INSTANCE", 0);
            private static final /* synthetic */ ForStaticTypeHash[] $VALUES;

            public static ForStaticTypeHash[] values() {
                return (ForStaticTypeHash[])$VALUES.clone();
            }

            public static ForStaticTypeHash valueOf(String name) {
                return (ForStaticTypeHash)Enum.valueOf(ForStaticTypeHash.class, (String)name);
            }

            private ForStaticTypeHash() {
                super((String)string, n);
            }

            @Override
            public StackManipulation resolve(TypeDescription instrumentedType) {
                return new StackManipulation.Compound(ClassConstant.of(instrumentedType), MethodInvocation.invoke(HASH_CODE).virtual(TypeDescription.ForLoadedType.of(Class.class)));
            }

            static {
                $VALUES = new ForStaticTypeHash[]{INSTANCE};
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class ForSuperMethodCall
        extends Enum<ForSuperMethodCall>
        implements OffsetProvider {
            public static final /* enum */ ForSuperMethodCall INSTANCE = new ForSuperMethodCall((String)"org.rascalmpl.INSTANCE", 0);
            private static final /* synthetic */ ForSuperMethodCall[] $VALUES;

            public static ForSuperMethodCall[] values() {
                return (ForSuperMethodCall[])$VALUES.clone();
            }

            public static ForSuperMethodCall valueOf(String name) {
                return (ForSuperMethodCall)Enum.valueOf(ForSuperMethodCall.class, (String)name);
            }

            private ForSuperMethodCall() {
                super((String)string, n);
            }

            @Override
            public StackManipulation resolve(TypeDescription instrumentedType) {
                TypeDescription.Generic superClass = instrumentedType.getSuperClass();
                if (superClass == null) {
                    throw new IllegalStateException(new StringBuilder().append((org.rascalmpl.java.lang.Object)instrumentedType).append((String)"org.rascalmpl. does not declare a super class").toString());
                }
                return new StackManipulation.Compound(MethodVariableAccess.loadThis(), MethodInvocation.invoke(HASH_CODE).special(superClass.asErasure()));
            }

            static {
                $VALUES = new ForSuperMethodCall[]{INSTANCE};
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForFixedValue
        extends org.rascalmpl.java.lang.Object
        implements OffsetProvider {
            private final int value;

            protected ForFixedValue(int value) {
                this.value = value;
            }

            public StackManipulation resolve(TypeDescription instrumentedType) {
                return IntegerConstant.forValue(this.value);
            }

            public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.value == ((ForFixedValue)object).value;
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.value;
            }
        }
    }
}

