/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.net.bytebuddy.implementation.bind;

import org.rascalmpl.edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.rascalmpl.java.io.PrintStream;
import org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.Void;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.HashMap;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.LinkedHashMap;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.rascalmpl.net.bytebuddy.description.method.MethodDescription;
import org.rascalmpl.net.bytebuddy.description.type.TypeDescription;
import org.rascalmpl.net.bytebuddy.implementation.Implementation;
import org.rascalmpl.net.bytebuddy.implementation.bind.ArgumentTypeResolver;
import org.rascalmpl.net.bytebuddy.implementation.bind.DeclaringTypeResolver;
import org.rascalmpl.net.bytebuddy.implementation.bind.MethodNameEqualityResolver;
import org.rascalmpl.net.bytebuddy.implementation.bind.ParameterLengthResolver;
import org.rascalmpl.net.bytebuddy.implementation.bind.annotation.BindingPriority;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.Removal;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.assign.Assigner;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.member.MethodReturn;
import org.rascalmpl.net.bytebuddy.jar.asm.MethodVisitor;
import org.rascalmpl.net.bytebuddy.utility.CompoundList;
import org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;

public interface MethodDelegationBinder {
    public Record compile(MethodDescription var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Processor
    extends org.rascalmpl.java.lang.Object
    implements Record {
        private final List<? extends Record> records;
        private final AmbiguityResolver ambiguityResolver;
        private final BindingResolver bindingResolver;

        public Processor(List<? extends Record> records, AmbiguityResolver ambiguityResolver, BindingResolver bindingResolver) {
            this.records = records;
            this.ambiguityResolver = ambiguityResolver;
            this.bindingResolver = bindingResolver;
        }

        @Override
        public MethodBinding bind(Implementation.Target implementationTarget, MethodDescription source, TerminationHandler terminationHandler, MethodInvoker methodInvoker, Assigner assigner) {
            ArrayList targets = new ArrayList();
            for (Record record : this.records) {
                MethodBinding methodBinding = record.bind(implementationTarget, source, terminationHandler, methodInvoker, assigner);
                if (!methodBinding.isValid()) continue;
                targets.add((org.rascalmpl.java.lang.Object)methodBinding);
            }
            if (targets.isEmpty()) {
                throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.None of ").append(this.records).append((String)"org.rascalmpl. allows for delegation from ").append((org.rascalmpl.java.lang.Object)source).toString());
            }
            return this.bindingResolver.resolve(this.ambiguityResolver, source, (List<MethodBinding>)targets);
        }

        public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.records.equals(((Processor)object).records)) {
                return false;
            }
            if (!this.ambiguityResolver.equals(((Processor)object).ambiguityResolver)) {
                return false;
            }
            return this.bindingResolver.equals(((Processor)object).bindingResolver);
        }

        public int hashCode() {
            return ((this.getClass().hashCode() * 31 + this.records.hashCode()) * 31 + this.ambiguityResolver.hashCode()) * 31 + this.bindingResolver.hashCode();
        }
    }

    public static interface TerminationHandler {
        public StackManipulation resolve(Assigner var1, Assigner.Typing var2, MethodDescription var3, MethodDescription var4);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static abstract class Default
        extends Enum<Default>
        implements TerminationHandler {
            public static final /* enum */ Default RETURNING = new Default(){

                public StackManipulation resolve(Assigner assigner, Assigner.Typing typing, MethodDescription source, MethodDescription target) {
                    return new StackManipulation.Compound(assigner.assign(target.isConstructor() ? target.getDeclaringType().asGenericType() : target.getReturnType(), source.getReturnType(), typing), MethodReturn.of(source.getReturnType()));
                }
            };
            public static final /* enum */ Default DROPPING = new Default(){

                public StackManipulation resolve(Assigner assigner, Assigner.Typing typing, MethodDescription source, MethodDescription target) {
                    return Removal.of(target.isConstructor() ? target.getDeclaringType() : target.getReturnType());
                }
            };
            private static final /* synthetic */ Default[] $VALUES;

            public static Default[] values() {
                return (Default[])$VALUES.clone();
            }

            public static Default valueOf(String name) {
                return (Default)Enum.valueOf(Default.class, (String)name);
            }

            private Default() {
                super((String)string, n);
            }

            static {
                $VALUES = new Default[]{RETURNING, DROPPING};
            }
        }
    }

    @SuppressFBWarnings(value={"org.rascalmpl.IC_SUPERCLASS_USES_SUBCLASS_DURING_INITIALIZATION"}, justification="org.rascalmpl.Safe initialization is implied.")
    public static interface AmbiguityResolver {
        public static final AmbiguityResolver DEFAULT = new Compound(BindingPriority.Resolver.INSTANCE, DeclaringTypeResolver.INSTANCE, ArgumentTypeResolver.INSTANCE, MethodNameEqualityResolver.INSTANCE, ParameterLengthResolver.INSTANCE);

        public Resolution resolve(MethodDescription var1, MethodBinding var2, MethodBinding var3);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class Compound
        extends org.rascalmpl.java.lang.Object
        implements AmbiguityResolver {
            private final List<AmbiguityResolver> ambiguityResolvers = new ArrayList();

            public Compound(AmbiguityResolver ... ambiguityResolver) {
                this((List<? extends AmbiguityResolver>)Arrays.asList((org.rascalmpl.java.lang.Object[])ambiguityResolver));
            }

            public Compound(List<? extends AmbiguityResolver> ambiguityResolvers) {
                for (AmbiguityResolver ambiguityResolver : ambiguityResolvers) {
                    if (ambiguityResolver instanceof Compound) {
                        this.ambiguityResolvers.addAll(((Compound)ambiguityResolver).ambiguityResolvers);
                        continue;
                    }
                    if (ambiguityResolver instanceof NoOp) continue;
                    this.ambiguityResolvers.add((org.rascalmpl.java.lang.Object)ambiguityResolver);
                }
            }

            @Override
            public Resolution resolve(MethodDescription source, MethodBinding left, MethodBinding right) {
                Resolution resolution = Resolution.UNKNOWN;
                Iterator iterator = this.ambiguityResolvers.iterator();
                while (resolution.isUnresolved() && iterator.hasNext()) {
                    resolution = ((AmbiguityResolver)iterator.next()).resolve(source, left, right);
                }
                return resolution;
            }

            public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.ambiguityResolvers.equals(((Compound)object).ambiguityResolvers);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.ambiguityResolvers.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Directional
        extends Enum<Directional>
        implements AmbiguityResolver {
            public static final /* enum */ Directional LEFT = new Directional((String)"org.rascalmpl.LEFT", 0, true);
            public static final /* enum */ Directional RIGHT = new Directional((String)"org.rascalmpl.RIGHT", 1, false);
            private final boolean left;
            private static final /* synthetic */ Directional[] $VALUES;

            public static Directional[] values() {
                return (Directional[])$VALUES.clone();
            }

            public static Directional valueOf(String name) {
                return (Directional)Enum.valueOf(Directional.class, (String)name);
            }

            private Directional(boolean left) {
                super((String)string, n);
                this.left = left;
            }

            @Override
            public Resolution resolve(MethodDescription source, MethodBinding left, MethodBinding right) {
                return this.left ? Resolution.LEFT : Resolution.RIGHT;
            }

            static {
                $VALUES = new Directional[]{LEFT, RIGHT};
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class NoOp
        extends Enum<NoOp>
        implements AmbiguityResolver {
            public static final /* enum */ NoOp INSTANCE = new NoOp((String)"org.rascalmpl.INSTANCE", 0);
            private static final /* synthetic */ NoOp[] $VALUES;

            public static NoOp[] values() {
                return (NoOp[])$VALUES.clone();
            }

            public static NoOp valueOf(String name) {
                return (NoOp)Enum.valueOf(NoOp.class, (String)name);
            }

            private NoOp() {
                super((String)string, n);
            }

            @Override
            public Resolution resolve(MethodDescription source, MethodBinding left, MethodBinding right) {
                return Resolution.UNKNOWN;
            }

            static {
                $VALUES = new NoOp[]{INSTANCE};
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Resolution
        extends Enum<Resolution> {
            public static final /* enum */ Resolution UNKNOWN = new Resolution((String)"org.rascalmpl.UNKNOWN", 0, true);
            public static final /* enum */ Resolution LEFT = new Resolution((String)"org.rascalmpl.LEFT", 1, false);
            public static final /* enum */ Resolution RIGHT = new Resolution((String)"org.rascalmpl.RIGHT", 2, false);
            public static final /* enum */ Resolution AMBIGUOUS = new Resolution((String)"org.rascalmpl.AMBIGUOUS", 3, true);
            private final boolean unresolved;
            private static final /* synthetic */ Resolution[] $VALUES;

            public static Resolution[] values() {
                return (Resolution[])$VALUES.clone();
            }

            public static Resolution valueOf(String name) {
                return (Resolution)Enum.valueOf(Resolution.class, (String)name);
            }

            private Resolution(boolean unresolved) {
                super((String)string, n);
                this.unresolved = unresolved;
            }

            public boolean isUnresolved() {
                return this.unresolved;
            }

            public Resolution merge(Resolution other) {
                switch (this) {
                    case UNKNOWN: {
                        return other;
                    }
                    case AMBIGUOUS: {
                        return AMBIGUOUS;
                    }
                    case LEFT: 
                    case RIGHT: {
                        return other == UNKNOWN || other == this ? this : AMBIGUOUS;
                    }
                }
                throw new AssertionError();
            }

            static {
                $VALUES = new Resolution[]{UNKNOWN, LEFT, RIGHT, AMBIGUOUS};
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BindingResolver {
        public MethodBinding resolve(AmbiguityResolver var1, MethodDescription var2, List<MethodBinding> var3);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class StreamWriting
        extends org.rascalmpl.java.lang.Object
        implements BindingResolver {
            private final BindingResolver delegate;
            private final PrintStream printStream;

            public StreamWriting(BindingResolver delegate, PrintStream printStream) {
                this.delegate = delegate;
                this.printStream = printStream;
            }

            public static BindingResolver toSystemOut() {
                return StreamWriting.toSystemOut(Default.INSTANCE);
            }

            public static BindingResolver toSystemOut(BindingResolver bindingResolver) {
                return new StreamWriting(bindingResolver, System.out);
            }

            public static BindingResolver toSystemError() {
                return StreamWriting.toSystemError(Default.INSTANCE);
            }

            public static BindingResolver toSystemError(BindingResolver bindingResolver) {
                return new StreamWriting(bindingResolver, System.err);
            }

            @Override
            public MethodBinding resolve(AmbiguityResolver ambiguityResolver, MethodDescription source, List<MethodBinding> targets) {
                MethodBinding methodBinding = this.delegate.resolve(ambiguityResolver, source, targets);
                this.printStream.println(new StringBuilder().append((String)"org.rascalmpl.Binding ").append((org.rascalmpl.java.lang.Object)source).append((String)"org.rascalmpl. as delegation to ").append((org.rascalmpl.java.lang.Object)methodBinding.getTarget()).toString());
                return methodBinding;
            }

            public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.delegate.equals(((StreamWriting)object).delegate)) {
                    return false;
                }
                return this.printStream.equals((org.rascalmpl.java.lang.Object)((StreamWriting)object).printStream);
            }

            public int hashCode() {
                return (this.getClass().hashCode() * 31 + this.delegate.hashCode()) * 31 + this.printStream.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Unique
        extends Enum<Unique>
        implements BindingResolver {
            public static final /* enum */ Unique INSTANCE = new Unique((String)"org.rascalmpl.INSTANCE", 0);
            private static final int ONLY = 0;
            private static final /* synthetic */ Unique[] $VALUES;

            public static Unique[] values() {
                return (Unique[])$VALUES.clone();
            }

            public static Unique valueOf(String name) {
                return (Unique)Enum.valueOf(Unique.class, (String)name);
            }

            private Unique() {
                super((String)string, n);
            }

            @Override
            public MethodBinding resolve(AmbiguityResolver ambiguityResolver, MethodDescription source, List<MethodBinding> targets) {
                if (targets.size() == 1) {
                    return (MethodBinding)targets.get(0);
                }
                throw new IllegalStateException(new StringBuilder().append((org.rascalmpl.java.lang.Object)source).append((String)"org.rascalmpl. allowed for more than one binding: ").append(targets).toString());
            }

            static {
                $VALUES = new Unique[]{INSTANCE};
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Default
        extends Enum<Default>
        implements BindingResolver {
            public static final /* enum */ Default INSTANCE = new Default((String)"org.rascalmpl.INSTANCE", 0);
            private static final int ONLY = 0;
            private static final int LEFT = 0;
            private static final int RIGHT = 1;
            private static final /* synthetic */ Default[] $VALUES;

            public static Default[] values() {
                return (Default[])$VALUES.clone();
            }

            public static Default valueOf(String name) {
                return (Default)Enum.valueOf(Default.class, (String)name);
            }

            private Default() {
                super((String)string, n);
            }

            @Override
            public MethodBinding resolve(AmbiguityResolver ambiguityResolver, MethodDescription source, List<MethodBinding> targets) {
                return this.doResolve(ambiguityResolver, source, (List<MethodBinding>)new ArrayList(targets));
            }

            private MethodBinding doResolve(AmbiguityResolver ambiguityResolver, MethodDescription source, List<MethodBinding> targets) {
                switch (targets.size()) {
                    case 1: {
                        return (MethodBinding)targets.get(0);
                    }
                    case 2: {
                        MethodBinding left = (MethodBinding)targets.get(0);
                        MethodBinding right = (MethodBinding)targets.get(1);
                        switch (ambiguityResolver.resolve(source, left, right)) {
                            case LEFT: {
                                return left;
                            }
                            case RIGHT: {
                                return right;
                            }
                            case AMBIGUOUS: 
                            case UNKNOWN: {
                                throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.Cannot resolve ambiguous delegation of ").append((org.rascalmpl.java.lang.Object)source).append((String)"org.rascalmpl. to ").append((org.rascalmpl.java.lang.Object)left.getTarget()).append((String)"org.rascalmpl. or ").append((org.rascalmpl.java.lang.Object)right.getTarget()).toString());
                            }
                        }
                        throw new AssertionError();
                    }
                }
                MethodBinding left = (MethodBinding)targets.get(0);
                MethodBinding right = (MethodBinding)targets.get(1);
                switch (ambiguityResolver.resolve(source, left, right)) {
                    case LEFT: {
                        targets.remove(1);
                        return this.doResolve(ambiguityResolver, source, targets);
                    }
                    case RIGHT: {
                        targets.remove(0);
                        return this.doResolve(ambiguityResolver, source, targets);
                    }
                    case AMBIGUOUS: 
                    case UNKNOWN: {
                        targets.remove(1);
                        targets.remove(0);
                        MethodBinding subResult = this.doResolve(ambiguityResolver, source, targets);
                        switch (ambiguityResolver.resolve(source, left, subResult).merge(ambiguityResolver.resolve(source, right, subResult))) {
                            case RIGHT: {
                                return subResult;
                            }
                            case LEFT: 
                            case AMBIGUOUS: 
                            case UNKNOWN: {
                                throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.Cannot resolve ambiguous delegation of ").append((org.rascalmpl.java.lang.Object)source).append((String)"org.rascalmpl. to ").append((org.rascalmpl.java.lang.Object)left.getTarget()).append((String)"org.rascalmpl. or ").append((org.rascalmpl.java.lang.Object)right.getTarget()).toString());
                            }
                        }
                        throw new AssertionError();
                    }
                }
                throw new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Unexpected amount of targets: ").append(targets.size()).toString());
            }

            static {
                $VALUES = new Default[]{INSTANCE};
            }
        }
    }

    public static interface MethodBinding
    extends StackManipulation {
        @MaybeNull
        public Integer getTargetParameterIndex(org.rascalmpl.java.lang.Object var1);

        public MethodDescription getTarget();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Builder
        extends org.rascalmpl.java.lang.Object {
            private final MethodInvoker methodInvoker;
            private final MethodDescription candidate;
            private final List<StackManipulation> parameterStackManipulations;
            private final LinkedHashMap<org.rascalmpl.java.lang.Object, Integer> registeredTargetIndices;
            private int nextParameterIndex;

            public Builder(MethodInvoker methodInvoker, MethodDescription candidate) {
                this.methodInvoker = methodInvoker;
                this.candidate = candidate;
                this.parameterStackManipulations = new ArrayList(candidate.getParameters().size());
                this.registeredTargetIndices = new LinkedHashMap();
                this.nextParameterIndex = 0;
            }

            public boolean append(ParameterBinding<?> parameterBinding) {
                this.parameterStackManipulations.add(parameterBinding);
                return this.registeredTargetIndices.put(parameterBinding.getIdentificationToken(), (org.rascalmpl.java.lang.Object)Integer.valueOf((int)this.nextParameterIndex++)) == null;
            }

            public MethodBinding build(StackManipulation terminatingManipulation) {
                if (this.candidate.getParameters().size() != this.nextParameterIndex) {
                    throw new IllegalStateException((String)"org.rascalmpl.The number of parameters bound does not equal the target's number of parameters");
                }
                return new Build(this.candidate, (Map<?, Integer>)this.registeredTargetIndices, this.methodInvoker.invoke(this.candidate), this.parameterStackManipulations, terminatingManipulation);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            protected static class Build
            extends org.rascalmpl.java.lang.Object
            implements MethodBinding {
                private final MethodDescription target;
                private final Map<?, Integer> registeredTargetIndices;
                private final StackManipulation methodInvocation;
                private final List<StackManipulation> parameterStackManipulations;
                private final StackManipulation terminatingStackManipulation;

                protected Build(MethodDescription target, Map<?, Integer> registeredTargetIndices, StackManipulation methodInvocation, List<StackManipulation> parameterStackManipulations, StackManipulation terminatingStackManipulation) {
                    this.target = target;
                    this.registeredTargetIndices = new HashMap(registeredTargetIndices);
                    this.methodInvocation = methodInvocation;
                    this.parameterStackManipulations = new ArrayList(parameterStackManipulations);
                    this.terminatingStackManipulation = terminatingStackManipulation;
                }

                @Override
                public boolean isValid() {
                    boolean result = this.methodInvocation.isValid() && this.terminatingStackManipulation.isValid();
                    Iterator assignment = this.parameterStackManipulations.iterator();
                    while (result && assignment.hasNext()) {
                        result = ((StackManipulation)assignment.next()).isValid();
                    }
                    return result;
                }

                @Override
                @MaybeNull
                public Integer getTargetParameterIndex(org.rascalmpl.java.lang.Object parameterBindingToken) {
                    return (Integer)this.registeredTargetIndices.get(parameterBindingToken);
                }

                @Override
                public MethodDescription getTarget() {
                    return this.target;
                }

                @Override
                public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                    return new StackManipulation.Compound(CompoundList.of(this.parameterStackManipulations, Arrays.asList((org.rascalmpl.java.lang.Object[])new StackManipulation[]{this.methodInvocation, this.terminatingStackManipulation}))).apply(methodVisitor, implementationContext);
                }

                public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.target.equals(((Build)object).target)) {
                        return false;
                    }
                    if (!this.registeredTargetIndices.equals(((Build)object).registeredTargetIndices)) {
                        return false;
                    }
                    if (!this.methodInvocation.equals(((Build)object).methodInvocation)) {
                        return false;
                    }
                    if (!this.parameterStackManipulations.equals(((Build)object).parameterStackManipulations)) {
                        return false;
                    }
                    return this.terminatingStackManipulation.equals(((Build)object).terminatingStackManipulation);
                }

                public int hashCode() {
                    return ((((this.getClass().hashCode() * 31 + this.target.hashCode()) * 31 + this.registeredTargetIndices.hashCode()) * 31 + this.methodInvocation.hashCode()) * 31 + this.parameterStackManipulations.hashCode()) * 31 + this.terminatingStackManipulation.hashCode();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Illegal
        extends Enum<Illegal>
        implements MethodBinding {
            public static final /* enum */ Illegal INSTANCE = new Illegal((String)"org.rascalmpl.INSTANCE", 0);
            private static final /* synthetic */ Illegal[] $VALUES;

            public static Illegal[] values() {
                return (Illegal[])$VALUES.clone();
            }

            public static Illegal valueOf(String name) {
                return (Illegal)Enum.valueOf(Illegal.class, (String)name);
            }

            private Illegal() {
                super((String)string, n);
            }

            @Override
            public Integer getTargetParameterIndex(org.rascalmpl.java.lang.Object parameterBindingToken) {
                throw new IllegalStateException((String)"org.rascalmpl.Method is not bound");
            }

            @Override
            public MethodDescription getTarget() {
                throw new IllegalStateException((String)"org.rascalmpl.Method is not bound");
            }

            @Override
            public boolean isValid() {
                return false;
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                throw new IllegalStateException((String)"org.rascalmpl.Cannot delegate to an unbound method");
            }

            static {
                $VALUES = new Illegal[]{INSTANCE};
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ParameterBinding<T extends org.rascalmpl.java.lang.Object>
    extends StackManipulation {
        public T getIdentificationToken();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class Unique<T extends org.rascalmpl.java.lang.Object>
        extends org.rascalmpl.java.lang.Object
        implements ParameterBinding<T> {
            private final T identificationToken;
            private final StackManipulation delegate;

            public Unique(StackManipulation delegate, T identificationToken) {
                this.delegate = delegate;
                this.identificationToken = identificationToken;
            }

            public static <S extends org.rascalmpl.java.lang.Object> Unique<S> of(StackManipulation delegate, S identificationToken) {
                return new Unique<S>(delegate, identificationToken);
            }

            @Override
            public T getIdentificationToken() {
                return this.identificationToken;
            }

            @Override
            public boolean isValid() {
                return this.delegate.isValid();
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                return this.delegate.apply(methodVisitor, implementationContext);
            }

            public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.identificationToken.equals(((Unique)object).identificationToken)) {
                    return false;
                }
                return this.delegate.equals(((Unique)object).delegate);
            }

            public int hashCode() {
                return (this.getClass().hashCode() * 31 + this.identificationToken.hashCode()) * 31 + this.delegate.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class Anonymous
        extends org.rascalmpl.java.lang.Object
        implements ParameterBinding<org.rascalmpl.java.lang.Object> {
            @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.IGNORE)
            private final org.rascalmpl.java.lang.Object anonymousToken;
            private final StackManipulation delegate;

            public Anonymous(StackManipulation delegate) {
                this.delegate = delegate;
                this.anonymousToken = new org.rascalmpl.java.lang.Object();
            }

            @Override
            public org.rascalmpl.java.lang.Object getIdentificationToken() {
                return this.anonymousToken;
            }

            @Override
            public boolean isValid() {
                return this.delegate.isValid();
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                return this.delegate.apply(methodVisitor, implementationContext);
            }

            public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.delegate.equals(((Anonymous)object).delegate);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.delegate.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Illegal
        extends Enum<Illegal>
        implements ParameterBinding<Void> {
            public static final /* enum */ Illegal INSTANCE = new Illegal((String)"org.rascalmpl.INSTANCE", 0);
            private static final /* synthetic */ Illegal[] $VALUES;

            public static Illegal[] values() {
                return (Illegal[])$VALUES.clone();
            }

            public static Illegal valueOf(String name) {
                return (Illegal)Enum.valueOf(Illegal.class, (String)name);
            }

            private Illegal() {
                super((String)string, n);
            }

            @Override
            public Void getIdentificationToken() {
                throw new IllegalStateException((String)"org.rascalmpl.An illegal binding does not define an identification token");
            }

            @Override
            public boolean isValid() {
                return false;
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                throw new IllegalStateException((String)"org.rascalmpl.An illegal parameter binding must not be applied");
            }

            static {
                $VALUES = new Illegal[]{INSTANCE};
            }
        }
    }

    public static interface MethodInvoker {
        public StackManipulation invoke(MethodDescription var1);

        @HashCodeAndEqualsPlugin.Enhance
        public static class Virtual
        extends org.rascalmpl.java.lang.Object
        implements MethodInvoker {
            private final TypeDescription typeDescription;

            public Virtual(TypeDescription typeDescription) {
                this.typeDescription = typeDescription;
            }

            public StackManipulation invoke(MethodDescription methodDescription) {
                return MethodInvocation.invoke(methodDescription).virtual(this.typeDescription);
            }

            public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.typeDescription.equals(((Virtual)object).typeDescription);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.typeDescription.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Simple
        extends Enum<Simple>
        implements MethodInvoker {
            public static final /* enum */ Simple INSTANCE = new Simple((String)"org.rascalmpl.INSTANCE", 0);
            private static final /* synthetic */ Simple[] $VALUES;

            public static Simple[] values() {
                return (Simple[])$VALUES.clone();
            }

            public static Simple valueOf(String name) {
                return (Simple)Enum.valueOf(Simple.class, (String)name);
            }

            private Simple() {
                super((String)string, n);
            }

            @Override
            public StackManipulation invoke(MethodDescription methodDescription) {
                return MethodInvocation.invoke(methodDescription);
            }

            static {
                $VALUES = new Simple[]{INSTANCE};
            }
        }
    }

    public static interface Record {
        public MethodBinding bind(Implementation.Target var1, MethodDescription var2, TerminationHandler var3, MethodInvoker var4, Assigner var5);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Illegal
        extends Enum<Illegal>
        implements Record {
            public static final /* enum */ Illegal INSTANCE = new Illegal((String)"org.rascalmpl.INSTANCE", 0);
            private static final /* synthetic */ Illegal[] $VALUES;

            public static Illegal[] values() {
                return (Illegal[])$VALUES.clone();
            }

            public static Illegal valueOf(String name) {
                return (Illegal)Enum.valueOf(Illegal.class, (String)name);
            }

            private Illegal() {
                super((String)string, n);
            }

            @Override
            public MethodBinding bind(Implementation.Target implementationTarget, MethodDescription source, TerminationHandler terminationHandler, MethodInvoker methodInvoker, Assigner assigner) {
                return MethodBinding.Illegal.INSTANCE;
            }

            static {
                $VALUES = new Illegal[]{INSTANCE};
            }
        }
    }
}

