/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.net.bytebuddy.implementation.bytecode;

import org.rascalmpl.java.lang.Math;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.List;
import org.rascalmpl.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.rascalmpl.net.bytebuddy.description.method.MethodDescription;
import org.rascalmpl.net.bytebuddy.implementation.Implementation;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.rascalmpl.net.bytebuddy.jar.asm.MethodVisitor;
import org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;

public interface ByteCodeAppender {
    public Size apply(MethodVisitor var1, Implementation.Context var2, MethodDescription var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Simple
    extends Object
    implements ByteCodeAppender {
        private final StackManipulation stackManipulation;

        public Simple(StackManipulation ... stackManipulation) {
            this((List<? extends StackManipulation>)Arrays.asList((Object[])stackManipulation));
        }

        public Simple(List<? extends StackManipulation> stackManipulations) {
            this.stackManipulation = new StackManipulation.Compound(stackManipulations);
        }

        @Override
        public Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            return new Size(this.stackManipulation.apply(methodVisitor, implementationContext).getMaximalSize(), instrumentedMethod.getStackSize());
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.stackManipulation.equals(((Simple)object).stackManipulation);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.stackManipulation.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Compound
    extends Object
    implements ByteCodeAppender {
        private final List<ByteCodeAppender> byteCodeAppenders = new ArrayList();

        public Compound(ByteCodeAppender ... byteCodeAppender) {
            this((List<? extends ByteCodeAppender>)Arrays.asList((Object[])byteCodeAppender));
        }

        public Compound(List<? extends ByteCodeAppender> byteCodeAppenders) {
            for (ByteCodeAppender byteCodeAppender : byteCodeAppenders) {
                if (byteCodeAppender instanceof Compound) {
                    this.byteCodeAppenders.addAll(((Compound)byteCodeAppender).byteCodeAppenders);
                    continue;
                }
                this.byteCodeAppenders.add((Object)byteCodeAppender);
            }
        }

        @Override
        public Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            Size size = new Size(0, instrumentedMethod.getStackSize());
            for (ByteCodeAppender byteCodeAppender : this.byteCodeAppenders) {
                size = size.merge(byteCodeAppender.apply(methodVisitor, implementationContext, instrumentedMethod));
            }
            return size;
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.byteCodeAppenders.equals(((Compound)object).byteCodeAppenders);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.byteCodeAppenders.hashCode();
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class Size
    extends Object {
        public static final Size ZERO = new Size(0, 0);
        private final int operandStackSize;
        private final int localVariableSize;

        public Size(int operandStackSize, int localVariableSize) {
            this.operandStackSize = operandStackSize;
            this.localVariableSize = localVariableSize;
        }

        public int getOperandStackSize() {
            return this.operandStackSize;
        }

        public int getLocalVariableSize() {
            return this.localVariableSize;
        }

        public Size merge(Size other) {
            return new Size(Math.max((int)this.operandStackSize, (int)other.operandStackSize), Math.max((int)this.localVariableSize, (int)other.localVariableSize));
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (this.operandStackSize != ((Size)object).operandStackSize) {
                return false;
            }
            return this.localVariableSize == ((Size)object).localVariableSize;
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + this.operandStackSize) * 31 + this.localVariableSize;
        }
    }
}

