/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.net.bytebuddy.implementation.bytecode;

import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.java.lang.Math;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.List;
import org.rascalmpl.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.rascalmpl.net.bytebuddy.implementation.Implementation;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.StackSize;
import org.rascalmpl.net.bytebuddy.jar.asm.MethodVisitor;
import org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;

public interface StackManipulation {
    public boolean isValid();

    public Size apply(MethodVisitor var1, Implementation.Context var2);

    @HashCodeAndEqualsPlugin.Enhance
    public static class Simple
    extends AbstractBase {
        private final Dispatcher dispatcher;

        public Simple(Dispatcher dispatcher) {
            this.dispatcher = dispatcher;
        }

        public Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return this.dispatcher.apply(methodVisitor, implementationContext);
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.dispatcher.equals(((Simple)object).dispatcher);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.dispatcher.hashCode();
        }

        public static interface Dispatcher {
            public Size apply(MethodVisitor var1, Implementation.Context var2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Compound
    extends Object
    implements StackManipulation {
        private final List<StackManipulation> stackManipulations = new ArrayList();

        public Compound(StackManipulation ... stackManipulation) {
            this((List<? extends StackManipulation>)Arrays.asList((Object[])stackManipulation));
        }

        public Compound(List<? extends StackManipulation> stackManipulations) {
            for (StackManipulation stackManipulation : stackManipulations) {
                if (stackManipulation instanceof Compound) {
                    this.stackManipulations.addAll(((Compound)stackManipulation).stackManipulations);
                    continue;
                }
                if (stackManipulation instanceof Trivial) continue;
                this.stackManipulations.add((Object)stackManipulation);
            }
        }

        @Override
        public boolean isValid() {
            for (StackManipulation stackManipulation : this.stackManipulations) {
                if (stackManipulation.isValid()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            Size size = Size.ZERO;
            for (StackManipulation stackManipulation : this.stackManipulations) {
                size = size.aggregate(stackManipulation.apply(methodVisitor, implementationContext));
            }
            return size;
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.stackManipulations.equals(((Compound)object).stackManipulations);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.stackManipulations.hashCode();
        }
    }

    public static abstract class AbstractBase
    extends Object
    implements StackManipulation {
        public boolean isValid() {
            return true;
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class Size
    extends Object {
        public static final Size ZERO = new Size(0, 0);
        private final int sizeImpact;
        private final int maximalSize;

        public Size(int sizeImpact, int maximalSize) {
            this.sizeImpact = sizeImpact;
            this.maximalSize = maximalSize;
        }

        public int getSizeImpact() {
            return this.sizeImpact;
        }

        public int getMaximalSize() {
            return this.maximalSize;
        }

        public Size aggregate(Size other) {
            return this.aggregate(other.sizeImpact, other.maximalSize);
        }

        private Size aggregate(int sizeChange, int interimMaximalSize) {
            return new Size(this.sizeImpact + sizeChange, Math.max((int)this.maximalSize, (int)(this.sizeImpact + interimMaximalSize)));
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (this.sizeImpact != ((Size)object).sizeImpact) {
                return false;
            }
            return this.maximalSize == ((Size)object).maximalSize;
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + this.sizeImpact) * 31 + this.maximalSize;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Trivial
    extends Enum<Trivial>
    implements StackManipulation {
        public static final /* enum */ Trivial INSTANCE = new Trivial((String)"org.rascalmpl.INSTANCE", 0);
        private static final /* synthetic */ Trivial[] $VALUES;

        public static Trivial[] values() {
            return (Trivial[])$VALUES.clone();
        }

        public static Trivial valueOf(String name) {
            return (Trivial)Enum.valueOf(Trivial.class, (String)name);
        }

        private Trivial() {
            super((String)string, n);
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return StackSize.ZERO.toIncreasingSize();
        }

        static {
            $VALUES = new Trivial[]{INSTANCE};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Illegal
    extends Enum<Illegal>
    implements StackManipulation {
        public static final /* enum */ Illegal INSTANCE = new Illegal((String)"org.rascalmpl.INSTANCE", 0);
        private static final /* synthetic */ Illegal[] $VALUES;

        public static Illegal[] values() {
            return (Illegal[])$VALUES.clone();
        }

        public static Illegal valueOf(String name) {
            return (Illegal)Enum.valueOf(Illegal.class, (String)name);
        }

        private Illegal() {
            super((String)string, n);
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            throw new IllegalStateException((String)"org.rascalmpl.An illegal stack manipulation must not be applied");
        }

        static {
            $VALUES = new Illegal[]{INSTANCE};
        }
    }
}

