/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.net.bytebuddy.implementation.bytecode;

import org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.Double;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.Void;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.net.bytebuddy.description.type.TypeDefinition;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.StackManipulation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StackSize
extends Enum<StackSize> {
    public static final /* enum */ StackSize ZERO = new StackSize((String)"org.rascalmpl.ZERO", 0, 0);
    public static final /* enum */ StackSize SINGLE = new StackSize((String)"org.rascalmpl.SINGLE", 1, 1);
    public static final /* enum */ StackSize DOUBLE = new StackSize((String)"org.rascalmpl.DOUBLE", 2, 2);
    private final int size;
    private static final /* synthetic */ StackSize[] $VALUES;

    public static StackSize[] values() {
        return (StackSize[])$VALUES.clone();
    }

    public static StackSize valueOf(String name) {
        return (StackSize)Enum.valueOf(StackSize.class, (String)name);
    }

    private StackSize(int size) {
        super((String)string, n);
        this.size = size;
    }

    public static StackSize of(Class<?> type) {
        if (type == Void.TYPE) {
            return ZERO;
        }
        if (type == Double.TYPE || type == Long.TYPE) {
            return DOUBLE;
        }
        return SINGLE;
    }

    public static StackSize of(int size) {
        switch (size) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return SINGLE;
            }
            case 2: {
                return DOUBLE;
            }
        }
        throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.Unexpected stack size value: ").append(size).toString());
    }

    public static int of(TypeDefinition ... typeDefinition) {
        return StackSize.of((Collection<? extends TypeDefinition>)Arrays.asList((Object[])typeDefinition));
    }

    public static int of(Collection<? extends TypeDefinition> typeDefinitions) {
        int size = 0;
        for (TypeDefinition typeDefinition : typeDefinitions) {
            size += typeDefinition.getStackSize().getSize();
        }
        return size;
    }

    public int getSize() {
        return this.size;
    }

    public StackManipulation.Size toIncreasingSize() {
        return new StackManipulation.Size(this.getSize(), this.getSize());
    }

    public StackManipulation.Size toDecreasingSize() {
        return new StackManipulation.Size(-1 * this.getSize(), 0);
    }

    public StackSize maximum(StackSize stackSize) {
        switch (this) {
            case ZERO: {
                return stackSize;
            }
            case SINGLE: {
                switch (stackSize) {
                    case DOUBLE: {
                        return stackSize;
                    }
                    case SINGLE: 
                    case ZERO: {
                        return this;
                    }
                }
                throw new AssertionError();
            }
            case DOUBLE: {
                return this;
            }
        }
        throw new AssertionError();
    }

    static {
        $VALUES = new StackSize[]{ZERO, SINGLE, DOUBLE};
    }
}

