/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.net.bytebuddy.implementation.bytecode.assign.primitive;

import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.Byte;
import org.rascalmpl.java.lang.Character;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.Double;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.Float;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.Short;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.reflect.Type;
import org.rascalmpl.net.bytebuddy.description.type.TypeDefinition;
import org.rascalmpl.net.bytebuddy.description.type.TypeDescription;
import org.rascalmpl.net.bytebuddy.implementation.Implementation;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.StackSize;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.assign.Assigner;
import org.rascalmpl.net.bytebuddy.jar.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrimitiveBoxingDelegate
extends Enum<PrimitiveBoxingDelegate> {
    public static final /* enum */ PrimitiveBoxingDelegate BOOLEAN = new PrimitiveBoxingDelegate((String)"org.rascalmpl.BOOLEAN", 0, Boolean.class, StackSize.ZERO, (String)"org.rascalmpl.valueOf", (String)"org/rascalmpl/(Z)Ljava/lang/Boolean;");
    public static final /* enum */ PrimitiveBoxingDelegate BYTE = new PrimitiveBoxingDelegate((String)"org.rascalmpl.BYTE", 1, Byte.class, StackSize.ZERO, (String)"org.rascalmpl.valueOf", (String)"org/rascalmpl/(B)Ljava/lang/Byte;");
    public static final /* enum */ PrimitiveBoxingDelegate SHORT = new PrimitiveBoxingDelegate((String)"org.rascalmpl.SHORT", 2, Short.class, StackSize.ZERO, (String)"org.rascalmpl.valueOf", (String)"org/rascalmpl/(S)Ljava/lang/Short;");
    public static final /* enum */ PrimitiveBoxingDelegate CHARACTER = new PrimitiveBoxingDelegate((String)"org.rascalmpl.CHARACTER", 3, Character.class, StackSize.ZERO, (String)"org.rascalmpl.valueOf", (String)"org/rascalmpl/(C)Ljava/lang/Character;");
    public static final /* enum */ PrimitiveBoxingDelegate INTEGER = new PrimitiveBoxingDelegate((String)"org.rascalmpl.INTEGER", 4, Integer.class, StackSize.ZERO, (String)"org.rascalmpl.valueOf", (String)"org/rascalmpl/(I)Ljava/lang/Integer;");
    public static final /* enum */ PrimitiveBoxingDelegate LONG = new PrimitiveBoxingDelegate((String)"org.rascalmpl.LONG", 5, Long.class, StackSize.SINGLE, (String)"org.rascalmpl.valueOf", (String)"org/rascalmpl/(J)Ljava/lang/Long;");
    public static final /* enum */ PrimitiveBoxingDelegate FLOAT = new PrimitiveBoxingDelegate((String)"org.rascalmpl.FLOAT", 6, Float.class, StackSize.ZERO, (String)"org.rascalmpl.valueOf", (String)"org/rascalmpl/(F)Ljava/lang/Float;");
    public static final /* enum */ PrimitiveBoxingDelegate DOUBLE = new PrimitiveBoxingDelegate((String)"org.rascalmpl.DOUBLE", 7, Double.class, StackSize.SINGLE, (String)"org.rascalmpl.valueOf", (String)"org/rascalmpl/(D)Ljava/lang/Double;");
    private final TypeDescription wrapperType;
    private final StackManipulation.Size size;
    private final String boxingMethodName;
    private final String boxingMethodDescriptor;
    private static final /* synthetic */ PrimitiveBoxingDelegate[] $VALUES;

    public static PrimitiveBoxingDelegate[] values() {
        return (PrimitiveBoxingDelegate[])$VALUES.clone();
    }

    public static PrimitiveBoxingDelegate valueOf(String name) {
        return (PrimitiveBoxingDelegate)Enum.valueOf(PrimitiveBoxingDelegate.class, (String)name);
    }

    private PrimitiveBoxingDelegate(Class<?> wrapperType, StackSize sizeDifference, String boxingMethodName, String boxingMethodDescriptor) {
        super((String)string, n);
        this.wrapperType = TypeDescription.ForLoadedType.of(wrapperType);
        this.size = sizeDifference.toDecreasingSize();
        this.boxingMethodName = boxingMethodName;
        this.boxingMethodDescriptor = boxingMethodDescriptor;
    }

    public static PrimitiveBoxingDelegate forPrimitive(TypeDefinition typeDefinition) {
        if (typeDefinition.represents((Type)Boolean.TYPE)) {
            return BOOLEAN;
        }
        if (typeDefinition.represents((Type)Byte.TYPE)) {
            return BYTE;
        }
        if (typeDefinition.represents((Type)Short.TYPE)) {
            return SHORT;
        }
        if (typeDefinition.represents((Type)Character.TYPE)) {
            return CHARACTER;
        }
        if (typeDefinition.represents((Type)Integer.TYPE)) {
            return INTEGER;
        }
        if (typeDefinition.represents((Type)Long.TYPE)) {
            return LONG;
        }
        if (typeDefinition.represents((Type)Float.TYPE)) {
            return FLOAT;
        }
        if (typeDefinition.represents((Type)Double.TYPE)) {
            return DOUBLE;
        }
        throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.Not a non-void, primitive type: ").append((org.rascalmpl.java.lang.Object)typeDefinition).toString());
    }

    public StackManipulation assignBoxedTo(TypeDescription.Generic target, Assigner chainedAssigner, Assigner.Typing typing) {
        return new BoxingStackManipulation(chainedAssigner.assign(this.wrapperType.asGenericType(), target, typing));
    }

    static {
        $VALUES = new PrimitiveBoxingDelegate[]{BOOLEAN, BYTE, SHORT, CHARACTER, INTEGER, LONG, FLOAT, DOUBLE};
    }

    private class BoxingStackManipulation
    extends org.rascalmpl.java.lang.Object
    implements StackManipulation {
        private final StackManipulation stackManipulation;

        public BoxingStackManipulation(StackManipulation stackManipulation) {
            this.stackManipulation = stackManipulation;
        }

        public boolean isValid() {
            return this.stackManipulation.isValid();
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitMethodInsn(184, PrimitiveBoxingDelegate.this.wrapperType.getInternalName(), PrimitiveBoxingDelegate.this.boxingMethodName, PrimitiveBoxingDelegate.this.boxingMethodDescriptor, false);
            return PrimitiveBoxingDelegate.this.size.aggregate(this.stackManipulation.apply(methodVisitor, implementationContext));
        }
    }
}

