/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.net.bytebuddy.implementation.bytecode.assign.primitive;

import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.Byte;
import org.rascalmpl.java.lang.Character;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.Double;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.Float;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.Short;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.reflect.Type;
import org.rascalmpl.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.rascalmpl.net.bytebuddy.description.type.TypeDefinition;
import org.rascalmpl.net.bytebuddy.description.type.TypeDescription;
import org.rascalmpl.net.bytebuddy.implementation.Implementation;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.StackSize;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.assign.Assigner;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveWideningDelegate;
import org.rascalmpl.net.bytebuddy.jar.asm.MethodVisitor;
import org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrimitiveUnboxingDelegate
extends Enum<PrimitiveUnboxingDelegate>
implements StackManipulation {
    public static final /* enum */ PrimitiveUnboxingDelegate BOOLEAN = new PrimitiveUnboxingDelegate((String)"org.rascalmpl.BOOLEAN", 0, Boolean.class, Boolean.TYPE, StackSize.ZERO, (String)"org.rascalmpl.booleanValue", (String)"org.rascalmpl.()Z");
    public static final /* enum */ PrimitiveUnboxingDelegate BYTE = new PrimitiveUnboxingDelegate((String)"org.rascalmpl.BYTE", 1, Byte.class, Byte.TYPE, StackSize.ZERO, (String)"org.rascalmpl.byteValue", (String)"org.rascalmpl.()B");
    public static final /* enum */ PrimitiveUnboxingDelegate SHORT = new PrimitiveUnboxingDelegate((String)"org.rascalmpl.SHORT", 2, Short.class, Short.TYPE, StackSize.ZERO, (String)"org.rascalmpl.shortValue", (String)"org.rascalmpl.()S");
    public static final /* enum */ PrimitiveUnboxingDelegate CHARACTER = new PrimitiveUnboxingDelegate((String)"org.rascalmpl.CHARACTER", 3, Character.class, Character.TYPE, StackSize.ZERO, (String)"org.rascalmpl.charValue", (String)"org.rascalmpl.()C");
    public static final /* enum */ PrimitiveUnboxingDelegate INTEGER = new PrimitiveUnboxingDelegate((String)"org.rascalmpl.INTEGER", 4, Integer.class, Integer.TYPE, StackSize.ZERO, (String)"org.rascalmpl.intValue", (String)"org.rascalmpl.()I");
    public static final /* enum */ PrimitiveUnboxingDelegate LONG = new PrimitiveUnboxingDelegate((String)"org.rascalmpl.LONG", 5, Long.class, Long.TYPE, StackSize.SINGLE, (String)"org.rascalmpl.longValue", (String)"org.rascalmpl.()J");
    public static final /* enum */ PrimitiveUnboxingDelegate FLOAT = new PrimitiveUnboxingDelegate((String)"org.rascalmpl.FLOAT", 6, Float.class, Float.TYPE, StackSize.ZERO, (String)"org.rascalmpl.floatValue", (String)"org.rascalmpl.()F");
    public static final /* enum */ PrimitiveUnboxingDelegate DOUBLE = new PrimitiveUnboxingDelegate((String)"org.rascalmpl.DOUBLE", 7, Double.class, Double.TYPE, StackSize.SINGLE, (String)"org.rascalmpl.doubleValue", (String)"org.rascalmpl.()D");
    private final TypeDescription wrapperType;
    private final TypeDescription primitiveType;
    private final StackManipulation.Size size;
    private final String unboxingMethodName;
    private final String unboxingMethodDescriptor;
    private static final /* synthetic */ PrimitiveUnboxingDelegate[] $VALUES;

    public static PrimitiveUnboxingDelegate[] values() {
        return (PrimitiveUnboxingDelegate[])$VALUES.clone();
    }

    public static PrimitiveUnboxingDelegate valueOf(String name) {
        return (PrimitiveUnboxingDelegate)Enum.valueOf(PrimitiveUnboxingDelegate.class, (String)name);
    }

    private PrimitiveUnboxingDelegate(Class<?> wrapperType, Class<?> primitiveType, StackSize sizeDifference, String unboxingMethodName, String unboxingMethodDescriptor) {
        super((String)string, n);
        this.size = sizeDifference.toIncreasingSize();
        this.wrapperType = TypeDescription.ForLoadedType.of(wrapperType);
        this.primitiveType = TypeDescription.ForLoadedType.of(primitiveType);
        this.unboxingMethodName = unboxingMethodName;
        this.unboxingMethodDescriptor = unboxingMethodDescriptor;
    }

    public static PrimitiveUnboxingDelegate forPrimitive(TypeDefinition typeDefinition) {
        if (typeDefinition.represents((Type)Boolean.TYPE)) {
            return BOOLEAN;
        }
        if (typeDefinition.represents((Type)Byte.TYPE)) {
            return BYTE;
        }
        if (typeDefinition.represents((Type)Short.TYPE)) {
            return SHORT;
        }
        if (typeDefinition.represents((Type)Character.TYPE)) {
            return CHARACTER;
        }
        if (typeDefinition.represents((Type)Integer.TYPE)) {
            return INTEGER;
        }
        if (typeDefinition.represents((Type)Long.TYPE)) {
            return LONG;
        }
        if (typeDefinition.represents((Type)Float.TYPE)) {
            return FLOAT;
        }
        if (typeDefinition.represents((Type)Double.TYPE)) {
            return DOUBLE;
        }
        throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.Expected non-void primitive type instead of ").append((org.rascalmpl.java.lang.Object)typeDefinition).toString());
    }

    public static UnboxingResponsible forReferenceType(TypeDefinition typeDefinition) {
        if (typeDefinition.isPrimitive()) {
            throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.Expected reference type instead of ").append((org.rascalmpl.java.lang.Object)typeDefinition).toString());
        }
        if (typeDefinition.represents((Type)Boolean.class)) {
            return ExplicitlyTypedUnboxingResponsible.BOOLEAN;
        }
        if (typeDefinition.represents((Type)Byte.class)) {
            return ExplicitlyTypedUnboxingResponsible.BYTE;
        }
        if (typeDefinition.represents((Type)Short.class)) {
            return ExplicitlyTypedUnboxingResponsible.SHORT;
        }
        if (typeDefinition.represents((Type)Character.class)) {
            return ExplicitlyTypedUnboxingResponsible.CHARACTER;
        }
        if (typeDefinition.represents((Type)Integer.class)) {
            return ExplicitlyTypedUnboxingResponsible.INTEGER;
        }
        if (typeDefinition.represents((Type)Long.class)) {
            return ExplicitlyTypedUnboxingResponsible.LONG;
        }
        if (typeDefinition.represents((Type)Float.class)) {
            return ExplicitlyTypedUnboxingResponsible.FLOAT;
        }
        if (typeDefinition.represents((Type)Double.class)) {
            return ExplicitlyTypedUnboxingResponsible.DOUBLE;
        }
        return new ImplicitlyTypedUnboxingResponsible(typeDefinition.asGenericType());
    }

    protected TypeDescription.Generic getWrapperType() {
        return this.wrapperType.asGenericType();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitMethodInsn(182, this.wrapperType.asErasure().getInternalName(), this.unboxingMethodName, this.unboxingMethodDescriptor, false);
        return this.size;
    }

    static {
        $VALUES = new PrimitiveUnboxingDelegate[]{BOOLEAN, BYTE, SHORT, CHARACTER, INTEGER, LONG, FLOAT, DOUBLE};
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class ImplicitlyTypedUnboxingResponsible
    extends org.rascalmpl.java.lang.Object
    implements UnboxingResponsible {
        private final TypeDescription.Generic originalType;

        protected ImplicitlyTypedUnboxingResponsible(TypeDescription.Generic originalType) {
            this.originalType = originalType;
        }

        public StackManipulation assignUnboxedTo(TypeDescription.Generic target, Assigner assigner, Assigner.Typing typing) {
            PrimitiveUnboxingDelegate primitiveUnboxingDelegate = PrimitiveUnboxingDelegate.forPrimitive(target);
            return new StackManipulation.Compound(assigner.assign(this.originalType, primitiveUnboxingDelegate.getWrapperType(), typing), primitiveUnboxingDelegate);
        }

        public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.originalType.equals(((ImplicitlyTypedUnboxingResponsible)object).originalType);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.originalType.hashCode();
        }
    }

    public static interface UnboxingResponsible {
        public StackManipulation assignUnboxedTo(TypeDescription.Generic var1, Assigner var2, Assigner.Typing var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class ExplicitlyTypedUnboxingResponsible
    extends Enum<ExplicitlyTypedUnboxingResponsible>
    implements UnboxingResponsible {
        public static final /* enum */ ExplicitlyTypedUnboxingResponsible BOOLEAN = new ExplicitlyTypedUnboxingResponsible((String)"org.rascalmpl.BOOLEAN", 0, BOOLEAN);
        public static final /* enum */ ExplicitlyTypedUnboxingResponsible BYTE = new ExplicitlyTypedUnboxingResponsible((String)"org.rascalmpl.BYTE", 1, BYTE);
        public static final /* enum */ ExplicitlyTypedUnboxingResponsible SHORT = new ExplicitlyTypedUnboxingResponsible((String)"org.rascalmpl.SHORT", 2, SHORT);
        public static final /* enum */ ExplicitlyTypedUnboxingResponsible CHARACTER = new ExplicitlyTypedUnboxingResponsible((String)"org.rascalmpl.CHARACTER", 3, CHARACTER);
        public static final /* enum */ ExplicitlyTypedUnboxingResponsible INTEGER = new ExplicitlyTypedUnboxingResponsible((String)"org.rascalmpl.INTEGER", 4, INTEGER);
        public static final /* enum */ ExplicitlyTypedUnboxingResponsible LONG = new ExplicitlyTypedUnboxingResponsible((String)"org.rascalmpl.LONG", 5, LONG);
        public static final /* enum */ ExplicitlyTypedUnboxingResponsible FLOAT = new ExplicitlyTypedUnboxingResponsible((String)"org.rascalmpl.FLOAT", 6, FLOAT);
        public static final /* enum */ ExplicitlyTypedUnboxingResponsible DOUBLE = new ExplicitlyTypedUnboxingResponsible((String)"org.rascalmpl.DOUBLE", 7, DOUBLE);
        private final PrimitiveUnboxingDelegate primitiveUnboxingDelegate;
        private static final /* synthetic */ ExplicitlyTypedUnboxingResponsible[] $VALUES;

        public static ExplicitlyTypedUnboxingResponsible[] values() {
            return (ExplicitlyTypedUnboxingResponsible[])$VALUES.clone();
        }

        public static ExplicitlyTypedUnboxingResponsible valueOf(String name) {
            return (ExplicitlyTypedUnboxingResponsible)Enum.valueOf(ExplicitlyTypedUnboxingResponsible.class, (String)name);
        }

        private ExplicitlyTypedUnboxingResponsible(PrimitiveUnboxingDelegate primitiveUnboxingDelegate) {
            super((String)string, n);
            this.primitiveUnboxingDelegate = primitiveUnboxingDelegate;
        }

        @Override
        public StackManipulation assignUnboxedTo(TypeDescription.Generic targetType, Assigner assigner, Assigner.Typing typing) {
            return new StackManipulation.Compound(this.primitiveUnboxingDelegate, PrimitiveWideningDelegate.forPrimitive(this.primitiveUnboxingDelegate.primitiveType).widenTo(targetType));
        }

        static {
            $VALUES = new ExplicitlyTypedUnboxingResponsible[]{BOOLEAN, BYTE, SHORT, CHARACTER, INTEGER, LONG, FLOAT, DOUBLE};
        }
    }
}

