/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.net.bytebuddy.implementation.bytecode.assign.primitive;

import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.Void;
import org.rascalmpl.java.lang.reflect.Type;
import org.rascalmpl.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.rascalmpl.net.bytebuddy.description.type.TypeDescription;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.Removal;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.assign.Assigner;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.constant.DefaultValue;
import org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;

@HashCodeAndEqualsPlugin.Enhance
public class VoidAwareAssigner
extends Object
implements Assigner {
    private final Assigner chained;

    public VoidAwareAssigner(Assigner chained) {
        this.chained = chained;
    }

    public StackManipulation assign(TypeDescription.Generic source, TypeDescription.Generic target, Assigner.Typing typing) {
        if (source.represents((Type)Void.TYPE) && target.represents((Type)Void.TYPE)) {
            return StackManipulation.Trivial.INSTANCE;
        }
        if (source.represents((Type)Void.TYPE)) {
            return typing.isDynamic() ? DefaultValue.of(target) : StackManipulation.Illegal.INSTANCE;
        }
        if (target.represents((Type)Void.TYPE)) {
            return Removal.of(source);
        }
        return this.chained.assign(source, target, typing);
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.chained.equals(((VoidAwareAssigner)object).chained);
    }

    public int hashCode() {
        return this.getClass().hashCode() * 31 + this.chained.hashCode();
    }
}

