/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.net.bytebuddy.implementation.bytecode.collection;

import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.Byte;
import org.rascalmpl.java.lang.Character;
import org.rascalmpl.java.lang.Double;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.Float;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.Short;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.reflect.Type;
import org.rascalmpl.java.util.List;
import org.rascalmpl.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.rascalmpl.net.bytebuddy.description.type.TypeDefinition;
import org.rascalmpl.net.bytebuddy.description.type.TypeDescription;
import org.rascalmpl.net.bytebuddy.implementation.Implementation;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.StackSize;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.collection.CollectionFactory;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import org.rascalmpl.net.bytebuddy.jar.asm.MethodVisitor;
import org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class ArrayFactory
extends org.rascalmpl.java.lang.Object
implements CollectionFactory {
    private final TypeDescription.Generic componentType;
    private final ArrayCreator arrayCreator;
    @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.IGNORE)
    private final StackManipulation.Size sizeDecrease;

    protected ArrayFactory(TypeDescription.Generic componentType, ArrayCreator arrayCreator) {
        this.componentType = componentType;
        this.arrayCreator = arrayCreator;
        this.sizeDecrease = StackSize.DOUBLE.toDecreasingSize().aggregate(componentType.getStackSize().toDecreasingSize());
    }

    public static ArrayFactory forType(TypeDescription.Generic componentType) {
        return new ArrayFactory(componentType, ArrayFactory.makeArrayCreatorFor(componentType));
    }

    private static ArrayCreator makeArrayCreatorFor(TypeDefinition componentType) {
        if (!componentType.isPrimitive()) {
            return new ArrayCreator.ForReferenceType(componentType.asErasure());
        }
        if (componentType.represents((Type)Boolean.TYPE)) {
            return ArrayCreator.ForPrimitiveType.BOOLEAN;
        }
        if (componentType.represents((Type)Byte.TYPE)) {
            return ArrayCreator.ForPrimitiveType.BYTE;
        }
        if (componentType.represents((Type)Short.TYPE)) {
            return ArrayCreator.ForPrimitiveType.SHORT;
        }
        if (componentType.represents((Type)Character.TYPE)) {
            return ArrayCreator.ForPrimitiveType.CHARACTER;
        }
        if (componentType.represents((Type)Integer.TYPE)) {
            return ArrayCreator.ForPrimitiveType.INTEGER;
        }
        if (componentType.represents((Type)Long.TYPE)) {
            return ArrayCreator.ForPrimitiveType.LONG;
        }
        if (componentType.represents((Type)Float.TYPE)) {
            return ArrayCreator.ForPrimitiveType.FLOAT;
        }
        if (componentType.represents((Type)Double.TYPE)) {
            return ArrayCreator.ForPrimitiveType.DOUBLE;
        }
        throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.Cannot create array of type ").append((org.rascalmpl.java.lang.Object)componentType).toString());
    }

    @Override
    public StackManipulation withValues(List<? extends StackManipulation> stackManipulations) {
        return new ArrayStackManipulation(stackManipulations);
    }

    @Override
    public TypeDescription.Generic getComponentType() {
        return this.componentType;
    }

    public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!this.componentType.equals(((ArrayFactory)object).componentType)) {
            return false;
        }
        return this.arrayCreator.equals(((ArrayFactory)object).arrayCreator);
    }

    public int hashCode() {
        return (this.getClass().hashCode() * 31 + this.componentType.hashCode()) * 31 + this.arrayCreator.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance(includeSyntheticFields=true)
    protected class ArrayStackManipulation
    extends org.rascalmpl.java.lang.Object
    implements StackManipulation {
        private final List<? extends StackManipulation> stackManipulations;

        protected ArrayStackManipulation(List<? extends StackManipulation> stackManipulations) {
            this.stackManipulations = stackManipulations;
        }

        @Override
        public boolean isValid() {
            for (StackManipulation stackManipulation : this.stackManipulations) {
                if (stackManipulation.isValid()) continue;
                return false;
            }
            return ArrayFactory.this.arrayCreator.isValid();
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            StackManipulation.Size size = IntegerConstant.forValue(this.stackManipulations.size()).apply(methodVisitor, implementationContext);
            size = size.aggregate(ArrayFactory.this.arrayCreator.apply(methodVisitor, implementationContext));
            int index = 0;
            for (StackManipulation stackManipulation : this.stackManipulations) {
                methodVisitor.visitInsn(89);
                size = size.aggregate(StackSize.SINGLE.toIncreasingSize());
                size = size.aggregate(IntegerConstant.forValue(index++).apply(methodVisitor, implementationContext));
                size = size.aggregate(stackManipulation.apply(methodVisitor, implementationContext));
                methodVisitor.visitInsn(ArrayFactory.this.arrayCreator.getStorageOpcode());
                size = size.aggregate(ArrayFactory.this.sizeDecrease);
            }
            return size;
        }

        public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.stackManipulations.equals(((ArrayStackManipulation)object).stackManipulations)) {
                return false;
            }
            return ArrayFactory.this.equals(((ArrayStackManipulation)object).ArrayFactory.this);
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + this.stackManipulations.hashCode()) * 31 + ArrayFactory.this.hashCode();
        }
    }

    protected static interface ArrayCreator
    extends StackManipulation {
        public static final StackManipulation.Size ARRAY_CREATION_SIZE_CHANGE = StackSize.ZERO.toDecreasingSize();

        public int getStorageOpcode();

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForReferenceType
        extends StackManipulation.AbstractBase
        implements ArrayCreator {
            private final String internalTypeName;

            protected ForReferenceType(TypeDescription referenceType) {
                this.internalTypeName = referenceType.getInternalName();
            }

            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitTypeInsn(189, this.internalTypeName);
                return ARRAY_CREATION_SIZE_CHANGE;
            }

            public int getStorageOpcode() {
                return 83;
            }

            public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.internalTypeName.equals((org.rascalmpl.java.lang.Object)((ForReferenceType)object).internalTypeName);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.internalTypeName.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class ForPrimitiveType
        extends Enum<ForPrimitiveType>
        implements ArrayCreator {
            public static final /* enum */ ForPrimitiveType BOOLEAN = new ForPrimitiveType((String)"org.rascalmpl.BOOLEAN", 0, 4, 84);
            public static final /* enum */ ForPrimitiveType BYTE = new ForPrimitiveType((String)"org.rascalmpl.BYTE", 1, 8, 84);
            public static final /* enum */ ForPrimitiveType SHORT = new ForPrimitiveType((String)"org.rascalmpl.SHORT", 2, 9, 86);
            public static final /* enum */ ForPrimitiveType CHARACTER = new ForPrimitiveType((String)"org.rascalmpl.CHARACTER", 3, 5, 85);
            public static final /* enum */ ForPrimitiveType INTEGER = new ForPrimitiveType((String)"org.rascalmpl.INTEGER", 4, 10, 79);
            public static final /* enum */ ForPrimitiveType LONG = new ForPrimitiveType((String)"org.rascalmpl.LONG", 5, 11, 80);
            public static final /* enum */ ForPrimitiveType FLOAT = new ForPrimitiveType((String)"org.rascalmpl.FLOAT", 6, 6, 81);
            public static final /* enum */ ForPrimitiveType DOUBLE = new ForPrimitiveType((String)"org.rascalmpl.DOUBLE", 7, 7, 82);
            private final int creationOpcode;
            private final int storageOpcode;
            private static final /* synthetic */ ForPrimitiveType[] $VALUES;

            public static ForPrimitiveType[] values() {
                return (ForPrimitiveType[])$VALUES.clone();
            }

            public static ForPrimitiveType valueOf(String name) {
                return (ForPrimitiveType)Enum.valueOf(ForPrimitiveType.class, (String)name);
            }

            private ForPrimitiveType(int creationOpcode, int storageOpcode) {
                super((String)string, n);
                this.creationOpcode = creationOpcode;
                this.storageOpcode = storageOpcode;
            }

            @Override
            public boolean isValid() {
                return true;
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitIntInsn(188, this.creationOpcode);
                return ARRAY_CREATION_SIZE_CHANGE;
            }

            @Override
            public int getStorageOpcode() {
                return this.storageOpcode;
            }

            static {
                $VALUES = new ForPrimitiveType[]{BOOLEAN, BYTE, SHORT, CHARACTER, INTEGER, LONG, FLOAT, DOUBLE};
            }
        }
    }
}

