/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.net.bytebuddy.implementation.bytecode.constant;

import org.rascalmpl.java.lang.Double;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.rascalmpl.net.bytebuddy.implementation.Implementation;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.StackSize;
import org.rascalmpl.net.bytebuddy.jar.asm.MethodVisitor;
import org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DoubleConstant
extends Enum<DoubleConstant>
implements StackManipulation {
    public static final /* enum */ DoubleConstant ZERO = new DoubleConstant((String)"org.rascalmpl.ZERO", 0, 14);
    public static final /* enum */ DoubleConstant ONE = new DoubleConstant((String)"org.rascalmpl.ONE", 1, 15);
    private static final StackManipulation.Size SIZE;
    private final int opcode;
    private static final /* synthetic */ DoubleConstant[] $VALUES;

    public static DoubleConstant[] values() {
        return (DoubleConstant[])$VALUES.clone();
    }

    public static DoubleConstant valueOf(String name) {
        return (DoubleConstant)Enum.valueOf(DoubleConstant.class, (String)name);
    }

    private DoubleConstant(int opcode) {
        super((String)string, n);
        this.opcode = opcode;
    }

    public static StackManipulation forValue(double value) {
        if (value == 0.0) {
            return ZERO;
        }
        if (value == 1.0) {
            return ONE;
        }
        return new ConstantPool(value);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitInsn(this.opcode);
        return SIZE;
    }

    static {
        $VALUES = new DoubleConstant[]{ZERO, ONE};
        SIZE = StackSize.DOUBLE.toIncreasingSize();
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class ConstantPool
    extends StackManipulation.AbstractBase {
        private final double value;

        protected ConstantPool(double value) {
            this.value = value;
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitLdcInsn((Object)Double.valueOf((double)this.value));
            return SIZE;
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return Double.compare((double)this.value, (double)((ConstantPool)object).value) == 0;
        }

        public int hashCode() {
            long l = Double.doubleToLongBits((double)this.value);
            return this.getClass().hashCode() * 31 + (int)(l ^ l >>> 32);
        }
    }
}

