/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.net.bytebuddy.implementation.bytecode.constant;

import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.rascalmpl.net.bytebuddy.implementation.Implementation;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.StackSize;
import org.rascalmpl.net.bytebuddy.jar.asm.MethodVisitor;
import org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntegerConstant
extends Enum<IntegerConstant>
implements StackManipulation {
    public static final /* enum */ IntegerConstant MINUS_ONE = new IntegerConstant((String)"org.rascalmpl.MINUS_ONE", 0, 2);
    public static final /* enum */ IntegerConstant ZERO = new IntegerConstant((String)"org.rascalmpl.ZERO", 1, 3);
    public static final /* enum */ IntegerConstant ONE = new IntegerConstant((String)"org.rascalmpl.ONE", 2, 4);
    public static final /* enum */ IntegerConstant TWO = new IntegerConstant((String)"org.rascalmpl.TWO", 3, 5);
    public static final /* enum */ IntegerConstant THREE = new IntegerConstant((String)"org.rascalmpl.THREE", 4, 6);
    public static final /* enum */ IntegerConstant FOUR = new IntegerConstant((String)"org.rascalmpl.FOUR", 5, 7);
    public static final /* enum */ IntegerConstant FIVE = new IntegerConstant((String)"org.rascalmpl.FIVE", 6, 8);
    private static final StackManipulation.Size SIZE;
    private final int opcode;
    private static final /* synthetic */ IntegerConstant[] $VALUES;

    public static IntegerConstant[] values() {
        return (IntegerConstant[])$VALUES.clone();
    }

    public static IntegerConstant valueOf(String name) {
        return (IntegerConstant)Enum.valueOf(IntegerConstant.class, (String)name);
    }

    private IntegerConstant(int opcode) {
        super((String)string, n);
        this.opcode = opcode;
    }

    public static StackManipulation forValue(boolean value) {
        return value ? ONE : ZERO;
    }

    public static StackManipulation forValue(int value) {
        switch (value) {
            case -1: {
                return MINUS_ONE;
            }
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 4: {
                return FOUR;
            }
            case 5: {
                return FIVE;
            }
        }
        if (value >= -128 && value <= 127) {
            return new SingleBytePush((byte)value);
        }
        if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            return new TwoBytePush((short)value);
        }
        return new ConstantPool(value);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitInsn(this.opcode);
        return SIZE;
    }

    static {
        $VALUES = new IntegerConstant[]{MINUS_ONE, ZERO, ONE, TWO, THREE, FOUR, FIVE};
        SIZE = StackSize.SINGLE.toIncreasingSize();
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class ConstantPool
    extends StackManipulation.AbstractBase {
        private final int value;

        protected ConstantPool(int value) {
            this.value = value;
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitLdcInsn((Object)Integer.valueOf((int)this.value));
            return SIZE;
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.value == ((ConstantPool)object).value;
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.value;
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class TwoBytePush
    extends StackManipulation.AbstractBase {
        private final short value;

        protected TwoBytePush(short value) {
            this.value = value;
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitIntInsn(17, this.value);
            return SIZE;
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.value == ((TwoBytePush)object).value;
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.value;
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class SingleBytePush
    extends StackManipulation.AbstractBase {
        private final byte value;

        protected SingleBytePush(byte value) {
            this.value = value;
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitIntInsn(16, this.value);
            return SIZE;
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.value == ((SingleBytePush)object).value;
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.value;
        }
    }
}

