/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.net.bytebuddy.implementation.bytecode.constant;

import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.rascalmpl.net.bytebuddy.implementation.Implementation;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.StackSize;
import org.rascalmpl.net.bytebuddy.jar.asm.MethodVisitor;
import org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LongConstant
extends Enum<LongConstant>
implements StackManipulation {
    public static final /* enum */ LongConstant ZERO = new LongConstant((String)"org.rascalmpl.ZERO", 0, 9);
    public static final /* enum */ LongConstant ONE = new LongConstant((String)"org.rascalmpl.ONE", 1, 10);
    private static final StackManipulation.Size SIZE;
    private final int opcode;
    private static final /* synthetic */ LongConstant[] $VALUES;

    public static LongConstant[] values() {
        return (LongConstant[])$VALUES.clone();
    }

    public static LongConstant valueOf(String name) {
        return (LongConstant)Enum.valueOf(LongConstant.class, (String)name);
    }

    private LongConstant(int opcode) {
        super((String)string, n);
        this.opcode = opcode;
    }

    public static StackManipulation forValue(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value == 1L) {
            return ONE;
        }
        return new ConstantPool(value);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitInsn(this.opcode);
        return SIZE;
    }

    static {
        $VALUES = new LongConstant[]{ZERO, ONE};
        SIZE = StackSize.DOUBLE.toIncreasingSize();
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class ConstantPool
    extends StackManipulation.AbstractBase {
        private final long value;

        protected ConstantPool(long value) {
            this.value = value;
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitLdcInsn((Object)Long.valueOf((long)this.value));
            return SIZE;
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.value == ((ConstantPool)object).value;
        }

        public int hashCode() {
            long l = this.value;
            return this.getClass().hashCode() * 31 + (int)(l ^ l >>> 32);
        }
    }
}

