/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.net.bytebuddy.implementation.bytecode.constant;

import org.rascalmpl.edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.Exception;
import org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.java.lang.NoSuchMethodException;
import org.rascalmpl.java.lang.SecurityException;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.lang.reflect.Constructor;
import org.rascalmpl.java.lang.reflect.Method;
import org.rascalmpl.java.security.PrivilegedExceptionAction;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.List;
import org.rascalmpl.net.bytebuddy.description.method.MethodDescription;
import org.rascalmpl.net.bytebuddy.description.method.MethodList;
import org.rascalmpl.net.bytebuddy.description.type.TypeDescription;
import org.rascalmpl.net.bytebuddy.implementation.Implementation;
import org.rascalmpl.net.bytebuddy.implementation.auxiliary.PrivilegedMemberLookupAction;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.Duplication;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.TypeCreation;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.constant.TextConstant;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.member.FieldAccess;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.rascalmpl.net.bytebuddy.jar.asm.MethodVisitor;
import org.rascalmpl.net.bytebuddy.matcher.ElementMatchers;
import org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MethodConstant
extends StackManipulation.AbstractBase {
    @MaybeNull
    protected static final MethodDescription.InDefinedShape DO_PRIVILEGED = MethodConstant.doPrivileged();
    protected final MethodDescription.InDefinedShape methodDescription;

    @MaybeNull
    @SuppressFBWarnings(value={"org.rascalmpl.REC_CATCH_EXCEPTION"}, justification="org.rascalmpl.Exception should not be rethrown but trigger a fallback.")
    private static MethodDescription.InDefinedShape doPrivileged() {
        MethodDescription.ForLoadedMethod doPrivileged;
        try {
            doPrivileged = new MethodDescription.ForLoadedMethod(Class.forName((String)"org.rascalmpl.java.security.AccessController").getMethod((String)"org.rascalmpl.doPrivileged", new Class[]{PrivilegedExceptionAction.class}));
            try {
                if (!Boolean.parseBoolean((String)System.getProperty((String)"org.rascalmpl.net.bytebuddy.securitymanager", (String)"org.rascalmpl.true"))) {
                    doPrivileged = null;
                }
            }
            catch (SecurityException securityException) {}
        }
        catch (Exception ignored) {
            doPrivileged = null;
        }
        return doPrivileged;
    }

    protected MethodConstant(MethodDescription.InDefinedShape methodDescription) {
        this.methodDescription = methodDescription;
    }

    public static CanCache of(MethodDescription.InDefinedShape methodDescription) {
        if (methodDescription.isTypeInitializer()) {
            return CanCacheIllegal.INSTANCE;
        }
        if (methodDescription.isConstructor()) {
            return new ForConstructor(methodDescription);
        }
        return new ForMethod(methodDescription);
    }

    public static CanCache ofPrivileged(MethodDescription.InDefinedShape methodDescription) {
        if (DO_PRIVILEGED == null) {
            return MethodConstant.of(methodDescription);
        }
        if (methodDescription.isTypeInitializer()) {
            return CanCacheIllegal.INSTANCE;
        }
        if (methodDescription.isConstructor()) {
            return new ForConstructor(methodDescription).withPrivilegedLookup();
        }
        return new ForMethod(methodDescription).withPrivilegedLookup();
    }

    protected static List<StackManipulation> typeConstantsFor(List<TypeDescription> parameterTypes) {
        ArrayList typeConstants = new ArrayList(parameterTypes.size());
        for (TypeDescription parameterType : parameterTypes) {
            typeConstants.add((org.rascalmpl.java.lang.Object)ClassConstant.of(parameterType));
        }
        return typeConstants;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        return new StackManipulation.Compound(ClassConstant.of(this.methodDescription.getDeclaringType()), this.methodName(), ArrayFactory.forType(TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(Class.class)).withValues(MethodConstant.typeConstantsFor(this.methodDescription.getParameters().asTypeList().asErasures())), MethodInvocation.invoke(this.accessorMethod())).apply(methodVisitor, implementationContext);
    }

    protected CanCache withPrivilegedLookup() {
        return new PrivilegedLookup(this.methodDescription, this.methodName());
    }

    protected abstract StackManipulation methodName();

    protected abstract MethodDescription.InDefinedShape accessorMethod();

    public int hashCode() {
        return this.methodDescription.hashCode();
    }

    public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MethodConstant methodConstant = (MethodConstant)other;
        return this.methodDescription.equals(methodConstant.methodDescription);
    }

    protected static class CachedConstructor
    extends org.rascalmpl.java.lang.Object
    implements StackManipulation {
        private static final TypeDescription CONSTRUCTOR_TYPE = TypeDescription.ForLoadedType.of(Constructor.class);
        private final StackManipulation constructorConstant;

        protected CachedConstructor(StackManipulation constructorConstant) {
            this.constructorConstant = constructorConstant;
        }

        public boolean isValid() {
            return this.constructorConstant.isValid();
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return FieldAccess.forField(implementationContext.cache(this.constructorConstant, CONSTRUCTOR_TYPE)).read().apply(methodVisitor, implementationContext);
        }

        public int hashCode() {
            return this.constructorConstant.hashCode();
        }

        public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            CachedConstructor cachedConstructor = (CachedConstructor)other;
            return this.constructorConstant.equals(cachedConstructor.constructorConstant);
        }
    }

    protected static class CachedMethod
    extends org.rascalmpl.java.lang.Object
    implements StackManipulation {
        private static final TypeDescription METHOD_TYPE = TypeDescription.ForLoadedType.of(Method.class);
        private final StackManipulation methodConstant;

        protected CachedMethod(StackManipulation methodConstant) {
            this.methodConstant = methodConstant;
        }

        public boolean isValid() {
            return this.methodConstant.isValid();
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return FieldAccess.forField(implementationContext.cache(this.methodConstant, METHOD_TYPE)).read().apply(methodVisitor, implementationContext);
        }

        public int hashCode() {
            return this.methodConstant.hashCode();
        }

        public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            CachedMethod cachedMethod = (CachedMethod)other;
            return this.methodConstant.equals(cachedMethod.methodConstant);
        }
    }

    protected static class PrivilegedLookup
    extends org.rascalmpl.java.lang.Object
    implements StackManipulation,
    CanCache {
        private final MethodDescription.InDefinedShape methodDescription;
        private final StackManipulation methodName;

        protected PrivilegedLookup(MethodDescription.InDefinedShape methodDescription, StackManipulation methodName) {
            this.methodDescription = methodDescription;
            this.methodName = methodName;
        }

        public boolean isValid() {
            return this.methodName.isValid();
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            if (DO_PRIVILEGED == null) {
                throw new IllegalStateException((String)"org.rascalmpl.Privileged method invocation is not supported on the current VM");
            }
            TypeDescription auxiliaryType = implementationContext.register(PrivilegedMemberLookupAction.of(this.methodDescription));
            return new StackManipulation.Compound(TypeCreation.of(auxiliaryType), Duplication.SINGLE, ClassConstant.of(this.methodDescription.getDeclaringType()), this.methodName, ArrayFactory.forType(TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(Class.class)).withValues(MethodConstant.typeConstantsFor(this.methodDescription.getParameters().asTypeList().asErasures())), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)auxiliaryType.getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly()), MethodInvocation.invoke(DO_PRIVILEGED), TypeCasting.to(TypeDescription.ForLoadedType.of(this.methodDescription.isConstructor() ? Constructor.class : Method.class))).apply(methodVisitor, implementationContext);
        }

        public StackManipulation cached() {
            return this.methodDescription.isConstructor() ? new CachedConstructor(this) : new CachedMethod(this);
        }

        public int hashCode() {
            return this.methodDescription.hashCode();
        }

        public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            PrivilegedLookup privilegedLookup = (PrivilegedLookup)other;
            return this.methodDescription.equals(privilegedLookup.methodDescription);
        }
    }

    protected static class ForConstructor
    extends MethodConstant
    implements CanCache {
        private static final MethodDescription.InDefinedShape GET_CONSTRUCTOR;
        private static final MethodDescription.InDefinedShape GET_DECLARED_CONSTRUCTOR;

        protected ForConstructor(MethodDescription.InDefinedShape methodDescription) {
            super(methodDescription);
        }

        protected StackManipulation methodName() {
            return StackManipulation.Trivial.INSTANCE;
        }

        protected MethodDescription.InDefinedShape accessorMethod() {
            return this.methodDescription.isPublic() ? GET_CONSTRUCTOR : GET_DECLARED_CONSTRUCTOR;
        }

        public StackManipulation cached() {
            return new CachedConstructor(this);
        }

        static {
            try {
                GET_CONSTRUCTOR = new MethodDescription.ForLoadedMethod(Class.class.getMethod((String)"org.rascalmpl.getConstructor", new Class[]{Class[].class}));
                GET_DECLARED_CONSTRUCTOR = new MethodDescription.ForLoadedMethod(Class.class.getMethod((String)"org.rascalmpl.getDeclaredConstructor", new Class[]{Class[].class}));
            }
            catch (NoSuchMethodException exception) {
                throw new IllegalStateException((String)"org.rascalmpl.Could not locate Class::getDeclaredConstructor", (Throwable)((Object)exception));
            }
        }
    }

    protected static class ForMethod
    extends MethodConstant
    implements CanCache {
        private static final MethodDescription.InDefinedShape GET_METHOD;
        private static final MethodDescription.InDefinedShape GET_DECLARED_METHOD;

        protected ForMethod(MethodDescription.InDefinedShape methodDescription) {
            super(methodDescription);
        }

        protected StackManipulation methodName() {
            return new TextConstant(this.methodDescription.getInternalName());
        }

        protected MethodDescription.InDefinedShape accessorMethod() {
            return this.methodDescription.isPublic() ? GET_METHOD : GET_DECLARED_METHOD;
        }

        public StackManipulation cached() {
            return new CachedMethod(this);
        }

        static {
            try {
                GET_METHOD = new MethodDescription.ForLoadedMethod(Class.class.getMethod((String)"org.rascalmpl.getMethod", new Class[]{String.class, Class[].class}));
                GET_DECLARED_METHOD = new MethodDescription.ForLoadedMethod(Class.class.getMethod((String)"org.rascalmpl.getDeclaredMethod", new Class[]{String.class, Class[].class}));
            }
            catch (NoSuchMethodException exception) {
                throw new IllegalStateException((String)"org.rascalmpl.Could not locate method lookup", (Throwable)((Object)exception));
            }
        }
    }

    public static interface CanCache
    extends StackManipulation {
        public StackManipulation cached();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class CanCacheIllegal
    extends Enum<CanCacheIllegal>
    implements CanCache {
        public static final /* enum */ CanCacheIllegal INSTANCE = new CanCacheIllegal((String)"org.rascalmpl.INSTANCE", 0);
        private static final /* synthetic */ CanCacheIllegal[] $VALUES;

        public static CanCacheIllegal[] values() {
            return (CanCacheIllegal[])$VALUES.clone();
        }

        public static CanCacheIllegal valueOf(String name) {
            return (CanCacheIllegal)Enum.valueOf(CanCacheIllegal.class, (String)name);
        }

        private CanCacheIllegal() {
            super((String)string, n);
        }

        @Override
        public StackManipulation cached() {
            return StackManipulation.Illegal.INSTANCE;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return StackManipulation.Illegal.INSTANCE.apply(methodVisitor, implementationContext);
        }

        static {
            $VALUES = new CanCacheIllegal[]{INSTANCE};
        }
    }
}

