/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.net.bytebuddy.implementation.bytecode.member;

import org.rascalmpl.java.lang.Double;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.Float;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.Void;
import org.rascalmpl.java.lang.reflect.Type;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.List;
import org.rascalmpl.net.bytebuddy.build.CachedReturnPlugin;
import org.rascalmpl.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.rascalmpl.net.bytebuddy.description.method.MethodDescription;
import org.rascalmpl.net.bytebuddy.description.method.ParameterDescription;
import org.rascalmpl.net.bytebuddy.description.type.TypeDefinition;
import org.rascalmpl.net.bytebuddy.description.type.TypeDescription;
import org.rascalmpl.net.bytebuddy.implementation.Implementation;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.StackSize;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import org.rascalmpl.net.bytebuddy.jar.asm.MethodVisitor;
import org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodVariableAccess
extends Enum<MethodVariableAccess> {
    public static final /* enum */ MethodVariableAccess INTEGER = new MethodVariableAccess((String)"org.rascalmpl.INTEGER", 0, 21, 54, StackSize.SINGLE);
    public static final /* enum */ MethodVariableAccess LONG = new MethodVariableAccess((String)"org.rascalmpl.LONG", 1, 22, 55, StackSize.DOUBLE);
    public static final /* enum */ MethodVariableAccess FLOAT = new MethodVariableAccess((String)"org.rascalmpl.FLOAT", 2, 23, 56, StackSize.SINGLE);
    public static final /* enum */ MethodVariableAccess DOUBLE = new MethodVariableAccess((String)"org.rascalmpl.DOUBLE", 3, 24, 57, StackSize.DOUBLE);
    public static final /* enum */ MethodVariableAccess REFERENCE = new MethodVariableAccess((String)"org.rascalmpl.REFERENCE", 4, 25, 58, StackSize.SINGLE);
    private final int loadOpcode;
    private final int storeOpcode;
    private final StackSize size;
    private static final /* synthetic */ MethodVariableAccess[] $VALUES;
    private static /* synthetic */ StackManipulation loadThis;

    public static MethodVariableAccess[] values() {
        return (MethodVariableAccess[])$VALUES.clone();
    }

    public static MethodVariableAccess valueOf(String name) {
        return (MethodVariableAccess)Enum.valueOf(MethodVariableAccess.class, (String)name);
    }

    private MethodVariableAccess(int loadOpcode, int storeOpcode, StackSize stackSize) {
        super((String)string, n);
        this.loadOpcode = loadOpcode;
        this.size = stackSize;
        this.storeOpcode = storeOpcode;
    }

    public static MethodVariableAccess of(TypeDefinition typeDefinition) {
        if (typeDefinition.isPrimitive()) {
            if (typeDefinition.represents((Type)Long.TYPE)) {
                return LONG;
            }
            if (typeDefinition.represents((Type)Double.TYPE)) {
                return DOUBLE;
            }
            if (typeDefinition.represents((Type)Float.TYPE)) {
                return FLOAT;
            }
            if (typeDefinition.represents((Type)Void.TYPE)) {
                throw new IllegalArgumentException((String)"org.rascalmpl.Variable type cannot be void");
            }
            return INTEGER;
        }
        return REFERENCE;
    }

    public static MethodLoading allArgumentsOf(MethodDescription methodDescription) {
        return new MethodLoading(methodDescription, MethodLoading.TypeCastingHandler.NoOp.INSTANCE);
    }

    @CachedReturnPlugin.Enhance(value="org.rascalmpl.loadThis")
    public static StackManipulation loadThis() {
        StackManipulation stackManipulation;
        StackManipulation stackManipulation2 = loadThis;
        StackManipulation stackManipulation3 = stackManipulation = stackManipulation2 != null ? null : REFERENCE.loadFrom(0);
        if (stackManipulation == null) {
            stackManipulation = loadThis;
        } else {
            loadThis = stackManipulation;
        }
        return stackManipulation;
    }

    public StackManipulation loadFrom(int offset) {
        return new OffsetLoading(offset);
    }

    public StackManipulation storeAt(int offset) {
        return new OffsetWriting(offset);
    }

    public StackManipulation increment(int offset, int value) {
        if (this != INTEGER) {
            throw new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Cannot increment type: ").append((org.rascalmpl.java.lang.Object)this).toString());
        }
        return new OffsetIncrementing(offset, value);
    }

    public static StackManipulation load(ParameterDescription parameterDescription) {
        return MethodVariableAccess.of(parameterDescription.getType()).loadFrom(parameterDescription.getOffset());
    }

    public static StackManipulation store(ParameterDescription parameterDescription) {
        return MethodVariableAccess.of(parameterDescription.getType()).storeAt(parameterDescription.getOffset());
    }

    public static StackManipulation increment(ParameterDescription parameterDescription, int value) {
        return MethodVariableAccess.of(parameterDescription.getType()).increment(parameterDescription.getOffset(), value);
    }

    static {
        $VALUES = new MethodVariableAccess[]{INTEGER, LONG, FLOAT, DOUBLE, REFERENCE};
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class OffsetIncrementing
    extends StackManipulation.AbstractBase {
        private final int offset;
        private final int value;

        protected OffsetIncrementing(int offset, int value) {
            this.offset = offset;
            this.value = value;
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitIincInsn(this.offset, this.value);
            return StackManipulation.Size.ZERO;
        }

        public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (this.offset != ((OffsetIncrementing)object).offset) {
                return false;
            }
            return this.value == ((OffsetIncrementing)object).value;
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + this.offset) * 31 + this.value;
        }
    }

    @HashCodeAndEqualsPlugin.Enhance(includeSyntheticFields=true)
    protected class OffsetWriting
    extends StackManipulation.AbstractBase {
        private final int offset;

        protected OffsetWriting(int offset) {
            this.offset = offset;
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitVarInsn(MethodVariableAccess.this.storeOpcode, this.offset);
            return MethodVariableAccess.this.size.toDecreasingSize();
        }

        public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (this.offset != ((OffsetWriting)object).offset) {
                return false;
            }
            return MethodVariableAccess.this.equals((org.rascalmpl.java.lang.Object)((OffsetWriting)object).MethodVariableAccess.this);
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + this.offset) * 31 + MethodVariableAccess.this.hashCode();
        }
    }

    @HashCodeAndEqualsPlugin.Enhance(includeSyntheticFields=true)
    protected class OffsetLoading
    extends StackManipulation.AbstractBase {
        private final int offset;

        protected OffsetLoading(int offset) {
            this.offset = offset;
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitVarInsn(MethodVariableAccess.this.loadOpcode, this.offset);
            return MethodVariableAccess.this.size.toIncreasingSize();
        }

        public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (this.offset != ((OffsetLoading)object).offset) {
                return false;
            }
            return MethodVariableAccess.this.equals((org.rascalmpl.java.lang.Object)((OffsetLoading)object).MethodVariableAccess.this);
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + this.offset) * 31 + MethodVariableAccess.this.hashCode();
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class MethodLoading
    extends StackManipulation.AbstractBase {
        private final MethodDescription methodDescription;
        private final TypeCastingHandler typeCastingHandler;

        protected MethodLoading(MethodDescription methodDescription, TypeCastingHandler typeCastingHandler) {
            this.methodDescription = methodDescription;
            this.typeCastingHandler = typeCastingHandler;
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            ArrayList stackManipulations = new ArrayList();
            Iterator iterator = this.methodDescription.getParameters().iterator();
            while (iterator.hasNext()) {
                ParameterDescription parameterDescription = (ParameterDescription)iterator.next();
                TypeDescription parameterType = parameterDescription.getType().asErasure();
                stackManipulations.add((org.rascalmpl.java.lang.Object)MethodVariableAccess.of(parameterType).loadFrom(parameterDescription.getOffset()));
                stackManipulations.add((org.rascalmpl.java.lang.Object)this.typeCastingHandler.ofIndex(parameterType, parameterDescription.getIndex()));
            }
            return new StackManipulation.Compound((List<? extends StackManipulation>)stackManipulations).apply(methodVisitor, implementationContext);
        }

        public StackManipulation prependThisReference() {
            return this.methodDescription.isStatic() ? this : new StackManipulation.Compound(MethodVariableAccess.loadThis(), this);
        }

        public MethodLoading asBridgeOf(MethodDescription bridgeTarget) {
            return new MethodLoading(this.methodDescription, new TypeCastingHandler.ForBridgeTarget(bridgeTarget));
        }

        public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.methodDescription.equals(((MethodLoading)object).methodDescription)) {
                return false;
            }
            return this.typeCastingHandler.equals(((MethodLoading)object).typeCastingHandler);
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + this.methodDescription.hashCode()) * 31 + this.typeCastingHandler.hashCode();
        }

        protected static interface TypeCastingHandler {
            public StackManipulation ofIndex(TypeDescription var1, int var2);

            @HashCodeAndEqualsPlugin.Enhance
            public static class ForBridgeTarget
            extends org.rascalmpl.java.lang.Object
            implements TypeCastingHandler {
                private final MethodDescription bridgeTarget;

                public ForBridgeTarget(MethodDescription bridgeTarget) {
                    this.bridgeTarget = bridgeTarget;
                }

                public StackManipulation ofIndex(TypeDescription parameterType, int index) {
                    TypeDescription targetType = ((ParameterDescription)this.bridgeTarget.getParameters().get(index)).getType().asErasure();
                    return parameterType.equals(targetType) ? StackManipulation.Trivial.INSTANCE : TypeCasting.to(targetType);
                }

                public boolean equals(@MaybeNull org.rascalmpl.java.lang.Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.bridgeTarget.equals(((ForBridgeTarget)object).bridgeTarget);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.bridgeTarget.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static final class NoOp
            extends Enum<NoOp>
            implements TypeCastingHandler {
                public static final /* enum */ NoOp INSTANCE = new NoOp((String)"org.rascalmpl.INSTANCE", 0);
                private static final /* synthetic */ NoOp[] $VALUES;

                public static NoOp[] values() {
                    return (NoOp[])$VALUES.clone();
                }

                public static NoOp valueOf(String name) {
                    return (NoOp)Enum.valueOf(NoOp.class, (String)name);
                }

                private NoOp() {
                    super((String)string, n);
                }

                @Override
                public StackManipulation ofIndex(TypeDescription parameterType, int index) {
                    return StackManipulation.Trivial.INSTANCE;
                }

                static {
                    $VALUES = new NoOp[]{INSTANCE};
                }
            }
        }
    }
}

