/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.net.bytebuddy.matcher;

import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.net.bytebuddy.ClassFileVersion;
import org.rascalmpl.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.rascalmpl.net.bytebuddy.description.type.TypeDescription;
import org.rascalmpl.net.bytebuddy.matcher.ElementMatcher;
import org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class ClassFileVersionMatcher<T extends TypeDescription>
extends ElementMatcher.Junction.ForNonNullValues<T> {
    private final ClassFileVersion classFileVersion;
    private final boolean atMost;

    public ClassFileVersionMatcher(ClassFileVersion classFileVersion, boolean atMost) {
        this.classFileVersion = classFileVersion;
        this.atMost = atMost;
    }

    @Override
    protected boolean doMatch(T target) {
        ClassFileVersion classFileVersion = target.getClassFileVersion();
        return classFileVersion != null && (this.atMost ? classFileVersion.isAtMost(this.classFileVersion) : classFileVersion.isAtLeast(this.classFileVersion));
    }

    public String toString() {
        return new StringBuilder().append((String)"org.rascalmpl.hasClassFileVersion(at ").append((String)(this.atMost ? "org.rascalmpl.most" : "org.rascalmpl.least")).append((String)"org.rascalmpl. ").append((Object)this.classFileVersion).append((String)"org.rascalmpl.)").toString();
    }

    @Override
    public boolean equals(@MaybeNull Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (this.atMost != ((ClassFileVersionMatcher)object).atMost) {
            return false;
        }
        return this.classFileVersion.equals(((ClassFileVersionMatcher)object).classFileVersion);
    }

    @Override
    public int hashCode() {
        return (super.hashCode() * 31 + this.classFileVersion.hashCode()) * 31 + this.atMost;
    }
}

