/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.net.bytebuddy.matcher;

import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.rascalmpl.net.bytebuddy.matcher.ElementMatcher;
import org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class CollectionElementMatcher<T extends Object>
extends ElementMatcher.Junction.ForNonNullValues<Iterable<? extends T>> {
    private final int index;
    private final ElementMatcher<? super T> matcher;

    public CollectionElementMatcher(int index, ElementMatcher<? super T> matcher) {
        this.index = index;
        this.matcher = matcher;
    }

    @Override
    protected boolean doMatch(Iterable<? extends T> target) {
        Iterator iterator = target.iterator();
        for (int index = 0; index < this.index; ++index) {
            if (!iterator.hasNext()) {
                return false;
            }
            iterator.next();
        }
        return iterator.hasNext() && this.matcher.matches(iterator.next());
    }

    public String toString() {
        return new StringBuilder().append((String)"org.rascalmpl.with(").append(this.index).append((String)"org.rascalmpl. matches ").append(this.matcher).append((String)"org.rascalmpl.)").toString();
    }

    @Override
    public boolean equals(@MaybeNull Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (this.index != ((CollectionElementMatcher)object).index) {
            return false;
        }
        return this.matcher.equals(((CollectionElementMatcher)object).matcher);
    }

    @Override
    public int hashCode() {
        return (super.hashCode() * 31 + this.index) * 31 + this.matcher.hashCode();
    }
}

