/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.net.bytebuddy.matcher;

import org.rascalmpl.edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.rascalmpl.net.bytebuddy.matcher.ElementMatcher;
import org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class StringMatcher
extends ElementMatcher.Junction.ForNonNullValues<String> {
    private final String value;
    private final Mode mode;

    public StringMatcher(String value, Mode mode) {
        this.value = value;
        this.mode = mode;
    }

    @Override
    protected boolean doMatch(String target) {
        return this.mode.matches(this.value, target);
    }

    public String toString() {
        return new StringBuilder().append(this.mode.getDescription()).append('(').append(this.value).append(')').toString();
    }

    @Override
    public boolean equals(@MaybeNull Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!this.mode.equals((Object)((StringMatcher)object).mode)) {
            return false;
        }
        return this.value.equals((Object)((StringMatcher)object).value);
    }

    @Override
    public int hashCode() {
        return (super.hashCode() * 31 + this.value.hashCode()) * 31 + this.mode.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode EQUALS_FULLY = new Mode((String)"org.rascalmpl.equals"){

            protected boolean matches(String expected, String actual) {
                return actual.equals((Object)expected);
            }
        };
        public static final /* enum */ Mode EQUALS_FULLY_IGNORE_CASE = new Mode((String)"org.rascalmpl.equalsIgnoreCase"){

            protected boolean matches(String expected, String actual) {
                return actual.equalsIgnoreCase(expected);
            }
        };
        public static final /* enum */ Mode STARTS_WITH = new Mode((String)"org.rascalmpl.startsWith"){

            protected boolean matches(String expected, String actual) {
                return actual.startsWith(expected);
            }
        };
        public static final /* enum */ Mode STARTS_WITH_IGNORE_CASE = new Mode((String)"org.rascalmpl.startsWithIgnoreCase"){

            @SuppressFBWarnings(value={"org.rascalmpl.DM_CONVERT_CASE"}, justification="org.rascalmpl.Both strings are transformed by the default locale.")
            protected boolean matches(String expected, String actual) {
                return actual.toLowerCase().startsWith(expected.toLowerCase());
            }
        };
        public static final /* enum */ Mode ENDS_WITH = new Mode((String)"org.rascalmpl.endsWith"){

            protected boolean matches(String expected, String actual) {
                return actual.endsWith(expected);
            }
        };
        public static final /* enum */ Mode ENDS_WITH_IGNORE_CASE = new Mode((String)"org.rascalmpl.endsWithIgnoreCase"){

            @SuppressFBWarnings(value={"org.rascalmpl.DM_CONVERT_CASE"}, justification="org.rascalmpl.Both strings are transformed by the default locale.")
            protected boolean matches(String expected, String actual) {
                return actual.toLowerCase().endsWith(expected.toLowerCase());
            }
        };
        public static final /* enum */ Mode CONTAINS = new Mode((String)"org.rascalmpl.contains"){

            protected boolean matches(String expected, String actual) {
                return actual.contains((CharSequence)expected);
            }
        };
        public static final /* enum */ Mode CONTAINS_IGNORE_CASE = new Mode((String)"org.rascalmpl.containsIgnoreCase"){

            @SuppressFBWarnings(value={"org.rascalmpl.DM_CONVERT_CASE"}, justification="org.rascalmpl.Both strings are transformed by the default locale.")
            protected boolean matches(String expected, String actual) {
                return actual.toLowerCase().contains((CharSequence)expected.toLowerCase());
            }
        };
        public static final /* enum */ Mode MATCHES = new Mode((String)"org.rascalmpl.matches"){

            protected boolean matches(String expected, String actual) {
                return actual.matches(expected);
            }
        };
        private final String description;
        private static final /* synthetic */ Mode[] $VALUES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String name) {
            return (Mode)Enum.valueOf(Mode.class, (String)name);
        }

        private Mode(String description) {
            super((String)string, n);
            this.description = description;
        }

        protected String getDescription() {
            return this.description;
        }

        protected abstract boolean matches(String var1, String var2);

        static {
            $VALUES = new Mode[]{EQUALS_FULLY, EQUALS_FULLY_IGNORE_CASE, STARTS_WITH, STARTS_WITH_IGNORE_CASE, ENDS_WITH, ENDS_WITH_IGNORE_CASE, CONTAINS, CONTAINS_IGNORE_CASE, MATCHES};
        }
    }
}

