/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.net.bytebuddy.utility.privilege;

import org.rascalmpl.edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.Exception;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.reflect.Method;
import org.rascalmpl.java.security.PrivilegedAction;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class GetMethodAction
extends Object
implements PrivilegedAction<Method> {
    private final String type;
    private final String name;
    private final Class<?>[] parameter;

    public GetMethodAction(String type, String name, Class<?> ... parameter) {
        this.type = type;
        this.name = name;
        this.parameter = parameter;
    }

    @MaybeNull
    @SuppressFBWarnings(value={"org.rascalmpl.REC_CATCH_EXCEPTION"}, justification="org.rascalmpl.Exception should not be rethrown but trigger a fallback.")
    public Method run() {
        try {
            return Class.forName((String)this.type).getMethod(this.name, this.parameter);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!this.type.equals((Object)((GetMethodAction)object).type)) {
            return false;
        }
        if (!this.name.equals((Object)((GetMethodAction)object).name)) {
            return false;
        }
        return Arrays.equals(this.parameter, ((GetMethodAction)object).parameter);
    }

    public int hashCode() {
        return ((this.getClass().hashCode() * 31 + this.type.hashCode()) * 31 + this.name.hashCode()) * 31 + Arrays.hashCode(this.parameter);
    }
}

