/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.net.bytebuddy.utility.visitor;

import org.rascalmpl.edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.ClassNotFoundException;
import org.rascalmpl.java.lang.Double;
import org.rascalmpl.java.lang.Exception;
import org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.Math;
import org.rascalmpl.java.lang.SecurityException;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.security.AccessController;
import org.rascalmpl.java.security.PrivilegedAction;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.HashMap;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.ListIterator;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.net.bytebuddy.build.AccessControllerPlugin;
import org.rascalmpl.net.bytebuddy.description.method.MethodDescription;
import org.rascalmpl.net.bytebuddy.implementation.bytecode.StackSize;
import org.rascalmpl.net.bytebuddy.jar.asm.Handle;
import org.rascalmpl.net.bytebuddy.jar.asm.Label;
import org.rascalmpl.net.bytebuddy.jar.asm.MethodVisitor;
import org.rascalmpl.net.bytebuddy.jar.asm.Opcodes;
import org.rascalmpl.net.bytebuddy.jar.asm.Type;
import org.rascalmpl.net.bytebuddy.utility.CompoundList;
import org.rascalmpl.net.bytebuddy.utility.OpenedClassReader;
import org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;
import org.rascalmpl.net.bytebuddy.utility.privilege.GetSystemPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackAwareMethodVisitor
extends MethodVisitor {
    public static final String UNADJUSTED_PROPERTY = "org.rascalmpl.net.bytebuddy.unadjusted";
    public static final boolean UNADJUSTED;
    private static final int[] SIZE_CHANGE;
    private List<StackSize> current = new ArrayList();
    private final Map<Label, List<StackSize>> sizes = new HashMap();
    private int freeIndex;
    private static final boolean ACCESS_CONTROLLER;

    protected StackAwareMethodVisitor(MethodVisitor methodVisitor, MethodDescription instrumentedMethod) {
        super(OpenedClassReader.ASM_API, methodVisitor);
        this.freeIndex = instrumentedMethod.getStackSize();
    }

    public static MethodVisitor of(MethodVisitor methodVisitor, MethodDescription instrumentedMethod) {
        return UNADJUSTED ? methodVisitor : new StackAwareMethodVisitor(methodVisitor, instrumentedMethod);
    }

    @AccessControllerPlugin.Enhance
    private static <T extends org.rascalmpl.java.lang.Object> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        PrivilegedAction<T> action;
        if (ACCESS_CONTROLLER) {
            return (T)AccessController.doPrivileged(privilegedAction);
        }
        return (T)action.run();
    }

    private void adjustStack(int delta) {
        this.adjustStack(delta, 0);
    }

    private void adjustStack(int delta, int offset) {
        if (delta > 2) {
            throw new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Cannot push multiple values onto the operand stack: ").append(delta).toString());
        }
        if (delta > 0) {
            int position = this.current.size();
            while (offset > 0 && position > 0) {
                offset -= ((StackSize)this.current.get(--position)).getSize();
            }
            if (offset < 0) {
                throw new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Unexpected offset underflow: ").append(offset).toString());
            }
            this.current.add(position, (org.rascalmpl.java.lang.Object)StackSize.of(delta));
        } else {
            if (offset != 0) {
                throw new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Cannot specify non-zero offset ").append(offset).append((String)"org.rascalmpl. for non-incrementing value: ").append(delta).toString());
            }
            while (delta < 0) {
                if (this.current.isEmpty()) {
                    return;
                }
                delta += ((StackSize)this.current.remove(this.current.size() - 1)).getSize();
            }
            if (delta == 1) {
                this.current.add((org.rascalmpl.java.lang.Object)StackSize.SINGLE);
            } else if (delta != 0) {
                throw new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Unexpected remainder on the operand stack: ").append(delta).toString());
            }
        }
    }

    public void drainStack() {
        this.doDrain(this.current);
    }

    public int drainStack(int store, int load, StackSize size) {
        if (this.current.isEmpty()) {
            return 0;
        }
        int difference = ((StackSize)this.current.get(this.current.size() - 1)).getSize() - size.getSize();
        if (this.current.size() == 1 && difference == 0) {
            return 0;
        }
        super.visitVarInsn(store, this.freeIndex);
        if (difference == 1) {
            super.visitInsn(87);
        } else if (difference != 0) {
            throw new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Unexpected remainder on the operand stack: ").append(difference).toString());
        }
        this.doDrain((List<StackSize>)this.current.subList(0, this.current.size() - 1));
        super.visitVarInsn(load, this.freeIndex);
        return this.freeIndex + size.getSize();
    }

    private void doDrain(List<StackSize> stackSizes) {
        ListIterator iterator = stackSizes.listIterator(stackSizes.size());
        block4: while (iterator.hasPrevious()) {
            StackSize current = (StackSize)iterator.previous();
            switch (current) {
                case SINGLE: {
                    super.visitInsn(87);
                    continue block4;
                }
                case DOUBLE: {
                    super.visitInsn(88);
                    continue block4;
                }
            }
            throw new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Unexpected stack size: ").append((org.rascalmpl.java.lang.Object)current).toString());
        }
    }

    public void register(Label label, List<StackSize> stackSizes) {
        this.sizes.put((org.rascalmpl.java.lang.Object)label, stackSizes);
    }

    @Override
    public void visitInsn(int opcode) {
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: {
                this.current.clear();
                break;
            }
            case 90: 
            case 93: {
                this.adjustStack(SIZE_CHANGE[opcode], SIZE_CHANGE[opcode] + 1);
                break;
            }
            case 91: 
            case 94: {
                this.adjustStack(SIZE_CHANGE[opcode], SIZE_CHANGE[opcode] + 2);
                break;
            }
            case 136: 
            case 137: 
            case 142: 
            case 144: {
                this.adjustStack(-2);
                this.adjustStack(1);
                break;
            }
            case 133: 
            case 135: 
            case 140: 
            case 141: {
                this.adjustStack(-1);
                this.adjustStack(2);
                break;
            }
            case 47: 
            case 49: {
                this.adjustStack(-2);
                this.adjustStack(2);
                break;
            }
            default: {
                this.adjustStack(SIZE_CHANGE[opcode]);
            }
        }
        super.visitInsn(opcode);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.adjustStack(SIZE_CHANGE[opcode]);
        super.visitIntInsn(opcode, operand);
    }

    @Override
    @SuppressFBWarnings(value={"org.rascalmpl.SF_SWITCH_NO_DEFAULT"}, justification="org.rascalmpl.No action required on default option.")
    public void visitVarInsn(int opcode, int variable) {
        switch (opcode) {
            case 54: 
            case 56: 
            case 58: {
                this.freeIndex = Math.max((int)this.freeIndex, (int)(variable + 1));
                break;
            }
            case 55: 
            case 57: {
                this.freeIndex = Math.max((int)this.freeIndex, (int)(variable + 2));
                break;
            }
            case 169: {
                this.current.clear();
            }
        }
        this.adjustStack(SIZE_CHANGE[opcode]);
        super.visitVarInsn(opcode, variable);
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        this.adjustStack(SIZE_CHANGE[opcode]);
        super.visitTypeInsn(opcode, type);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        int baseline = Type.getType(descriptor).getSize();
        switch (opcode) {
            case 180: {
                this.adjustStack(-1);
                this.adjustStack(baseline);
                break;
            }
            case 178: {
                this.adjustStack(baseline);
                break;
            }
            case 181: {
                this.adjustStack(-baseline - 1);
                break;
            }
            case 179: {
                this.adjustStack(-baseline);
                break;
            }
            default: {
                throw new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Unexpected opcode: ").append(opcode).toString());
            }
        }
        super.visitFieldInsn(opcode, owner, name, descriptor);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        int baseline = Type.getArgumentsAndReturnSizes(descriptor);
        this.adjustStack(-(baseline >> 2) + (opcode == 184 ? 1 : 0));
        this.adjustStack(baseline & 3);
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrap, org.rascalmpl.java.lang.Object ... bootstrapArguments) {
        int baseline = Type.getArgumentsAndReturnSizes(descriptor);
        this.adjustStack(-(baseline >> 2) + 1);
        this.adjustStack(baseline & 3);
        super.visitInvokeDynamicInsn(name, descriptor, bootstrap, bootstrapArguments);
    }

    @Override
    public void visitLdcInsn(org.rascalmpl.java.lang.Object value) {
        this.adjustStack(value instanceof Long || value instanceof Double ? 2 : 1);
        super.visitLdcInsn(value);
    }

    @Override
    public void visitMultiANewArrayInsn(String descriptor, int dimension) {
        this.adjustStack(1 - dimension);
        super.visitMultiANewArrayInsn(descriptor, dimension);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.adjustStack(SIZE_CHANGE[opcode]);
        this.sizes.put((org.rascalmpl.java.lang.Object)label, (org.rascalmpl.java.lang.Object)new ArrayList(opcode == 168 ? CompoundList.of(this.current, StackSize.SINGLE) : this.current));
        if (opcode == 167) {
            this.current.clear();
        }
        super.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitLabel(Label label) {
        List current = (List)this.sizes.get((org.rascalmpl.java.lang.Object)label);
        if (current != null) {
            this.current = new ArrayList((Collection)current);
        }
        super.visitLabel(label);
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
    }

    @Override
    public void visitTableSwitchInsn(int minimum, int maximum, Label defaultOption, Label ... option) {
        this.adjustStack(-1);
        ArrayList current = new ArrayList(this.current);
        this.sizes.put((org.rascalmpl.java.lang.Object)defaultOption, (org.rascalmpl.java.lang.Object)current);
        for (Label label : option) {
            this.sizes.put((org.rascalmpl.java.lang.Object)label, (org.rascalmpl.java.lang.Object)current);
        }
        super.visitTableSwitchInsn(minimum, maximum, defaultOption, option);
    }

    @Override
    public void visitLookupSwitchInsn(Label defaultOption, int[] key, Label[] option) {
        this.adjustStack(-1);
        ArrayList current = new ArrayList(this.current);
        this.sizes.put((org.rascalmpl.java.lang.Object)defaultOption, (org.rascalmpl.java.lang.Object)current);
        for (Label label : option) {
            this.sizes.put((org.rascalmpl.java.lang.Object)label, (org.rascalmpl.java.lang.Object)current);
        }
        super.visitLookupSwitchInsn(defaultOption, key, option);
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, @MaybeNull String type) {
        this.sizes.put((org.rascalmpl.java.lang.Object)handler, (org.rascalmpl.java.lang.Object)Collections.singletonList((org.rascalmpl.java.lang.Object)StackSize.SINGLE));
        super.visitTryCatchBlock(start, end, handler, type);
    }

    @Override
    @SuppressFBWarnings(value={"org.rascalmpl.RC_REF_COMPARISON_BAD_PRACTICE"}, justification="org.rascalmpl.ASM models frames by reference identity.")
    public void visitFrame(int type, int localVariableLength, @MaybeNull org.rascalmpl.java.lang.Object[] localVariable, int stackSize, @MaybeNull org.rascalmpl.java.lang.Object[] stack) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: {
                this.current.clear();
                break;
            }
            case 4: {
                this.current.clear();
                if (stack[0] == Opcodes.LONG || stack[0] == Opcodes.DOUBLE) {
                    this.current.add((org.rascalmpl.java.lang.Object)StackSize.DOUBLE);
                    break;
                }
                this.current.add((org.rascalmpl.java.lang.Object)StackSize.SINGLE);
                break;
            }
            case -1: 
            case 0: {
                this.current.clear();
                for (int index = 0; index < stackSize; ++index) {
                    if (stack[index] == Opcodes.LONG || stack[index] == Opcodes.DOUBLE) {
                        this.current.add((org.rascalmpl.java.lang.Object)StackSize.DOUBLE);
                        continue;
                    }
                    this.current.add((org.rascalmpl.java.lang.Object)StackSize.SINGLE);
                }
                break;
            }
            default: {
                throw new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Unknown frame type: ").append(type).toString());
            }
        }
        super.visitFrame(type, localVariableLength, localVariable, stackSize, stack);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        boolean disabled;
        try {
            Class.forName((String)"org.rascalmpl.java.security.AccessController", (boolean)false, null);
            ACCESS_CONTROLLER = Boolean.parseBoolean((String)System.getProperty((String)"org.rascalmpl.net.bytebuddy.securitymanager", (String)"org.rascalmpl.true"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            ACCESS_CONTROLLER = false;
        }
        catch (SecurityException securityException) {
            ACCESS_CONTROLLER = true;
        }
        try {
            disabled = Boolean.parseBoolean((String)StackAwareMethodVisitor.doPrivileged(new GetSystemPropertyAction((String)"org.rascalmpl.net.bytebuddy.unadjusted")));
        }
        catch (Exception ignored) {
            disabled = false;
        }
        UNADJUSTED = disabled;
        SIZE_CHANGE = new int[202];
        java.lang.String encoded = "org.rascalmpl.EFFFFFFFFGGFFFGGFFFEEFGFGFEEEEEEEEEEEEEEEEEEEEDEDEDDDDDCDCDEEEEEEEEEEEEEEEEEEEEBABABBBBDCFFFGGGEDCDCDCDCDCDCDCDCDCDCEEEEDDDDDDDCDCDCEFEFDDEEFFDEDEEEBDDBBDDDDDDCCCCCCCCEEEDDDCDCDEEEEEEEEEEFEEEEEEDDEEDDEE";
        int index = 0;
        while (index < SIZE_CHANGE.length) {
            StackAwareMethodVisitor.SIZE_CHANGE[index] = encoded.charAt(index) - 69;
            ++index;
        }
        return;
    }
}

