/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.apache.commons.exec;

import org.rascalmpl.java.io.File;
import org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuffer;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.HashMap;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.StringTokenizer;
import org.rascalmpl.java.util.Vector;
import org.rascalmpl.org.apache.commons.exec.util.StringUtils;

public class CommandLine
extends Object {
    private final Vector<Argument> arguments = new Vector();
    private final String executable;
    private Map<String, ?> substitutionMap;
    private final boolean isFile;

    public static CommandLine parse(String line) {
        return CommandLine.parse(line, null);
    }

    public static CommandLine parse(String line, Map<String, ?> substitutionMap) {
        if (line == null) {
            throw new IllegalArgumentException((String)"org.rascalmpl.Command line can not be null");
        }
        if (line.trim().isEmpty()) {
            throw new IllegalArgumentException((String)"org.rascalmpl.Command line can not be empty");
        }
        String[] tmp = CommandLine.translateCommandline(line);
        CommandLine cl = new CommandLine(tmp[0]);
        cl.setSubstitutionMap(substitutionMap);
        for (int i = 1; i < tmp.length; ++i) {
            cl.addArgument(tmp[i]);
        }
        return cl;
    }

    private static String[] translateCommandline(String toProcess) {
        if (toProcess == null || toProcess.trim().isEmpty()) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, (String)"org.rascalmpl.\"' ", true);
        ArrayList list = new ArrayList();
        StringBuilder current = new StringBuilder();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("org.rascalmpl.'".equals((Object)nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("org.rascalmpl.\"".equals((Object)nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("org.rascalmpl.'".equals((Object)nextTok)) {
                state = 1;
            } else if ("org.rascalmpl.\"".equals((Object)nextTok)) {
                state = 2;
            } else if ("org.rascalmpl. ".equals((Object)nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() != 0) {
                    list.add((Object)current.toString());
                    current = new StringBuilder();
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            list.add((Object)current.toString());
        }
        if (state == 1 || state == 2) {
            throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.Unbalanced quotes in ").append(toProcess).toString());
        }
        String[] args = new String[list.size()];
        return (String[])list.toArray((Object[])args);
    }

    public CommandLine(CommandLine other) {
        this.executable = other.getExecutable();
        this.isFile = other.isFile();
        this.arguments.addAll(other.arguments);
        if (other.getSubstitutionMap() != null) {
            this.substitutionMap = new HashMap(other.getSubstitutionMap());
        }
    }

    public CommandLine(File executable) {
        this.isFile = true;
        this.executable = this.toCleanExecutable(executable.getAbsolutePath());
    }

    public CommandLine(String executable) {
        this.isFile = false;
        this.executable = this.toCleanExecutable(executable);
    }

    public CommandLine addArgument(String argument) {
        return this.addArgument(argument, true);
    }

    public CommandLine addArgument(String argument, boolean handleQuoting) {
        if (argument == null) {
            return this;
        }
        if (handleQuoting) {
            StringUtils.quoteArgument(argument);
        }
        this.arguments.add((Object)new Argument(argument, handleQuoting));
        return this;
    }

    public CommandLine addArguments(String addArguments) {
        return this.addArguments(addArguments, true);
    }

    public CommandLine addArguments(String addArguments, boolean handleQuoting) {
        if (addArguments != null) {
            String[] argumentsArray = CommandLine.translateCommandline(addArguments);
            this.addArguments(argumentsArray, handleQuoting);
        }
        return this;
    }

    public CommandLine addArguments(String[] addArguments) {
        return this.addArguments(addArguments, true);
    }

    public CommandLine addArguments(String[] addArguments, boolean handleQuoting) {
        if (addArguments != null) {
            for (String addArgument : addArguments) {
                this.addArgument(addArgument, handleQuoting);
            }
        }
        return this;
    }

    private String expandArgument(String argument) {
        StringBuffer stringBuffer = StringUtils.stringSubstitution(argument, this.getSubstitutionMap(), true);
        return stringBuffer.toString();
    }

    public String[] getArguments() {
        String[] result = new String[this.arguments.size()];
        for (int i = 0; i < result.length; ++i) {
            Argument currArgument = (Argument)this.arguments.get(i);
            String expandedArgument = this.expandArgument(currArgument.getValue());
            result[i] = currArgument.isHandleQuoting() ? StringUtils.quoteArgument(expandedArgument) : expandedArgument;
        }
        return result;
    }

    public String getExecutable() {
        return StringUtils.fixFileSeparatorChar(this.expandArgument(this.executable));
    }

    public Map<String, ?> getSubstitutionMap() {
        return this.substitutionMap;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public void setSubstitutionMap(Map<String, ?> substitutionMap) {
        this.substitutionMap = substitutionMap;
    }

    private String toCleanExecutable(String dirtyExecutable) {
        Objects.requireNonNull((Object)dirtyExecutable, (String)"org.rascalmpl.dirtyExecutable");
        if (dirtyExecutable.trim().isEmpty()) {
            throw new IllegalArgumentException((String)"org.rascalmpl.Executable can not be empty");
        }
        return StringUtils.fixFileSeparatorChar(dirtyExecutable);
    }

    public String toString() {
        return new StringBuilder().append((String)"org.rascalmpl.[").append(String.join((CharSequence)"org.rascalmpl., ", (CharSequence[])this.toStrings())).append((String)"org.rascalmpl.]").toString();
    }

    public String[] toStrings() {
        String[] result = new String[this.arguments.size() + 1];
        result[0] = this.getExecutable();
        System.arraycopy((Object)this.getArguments(), (int)0, (Object)result, (int)1, (int)(result.length - 1));
        return result;
    }

    static final class Argument
    extends Object {
        private final String value;
        private final boolean handleQuoting;

        private Argument(String value, boolean handleQuoting) {
            this.value = value.trim();
            this.handleQuoting = handleQuoting;
        }

        private String getValue() {
            return this.value;
        }

        private boolean isHandleQuoting() {
            return this.handleQuoting;
        }
    }
}

