/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.apache.commons.exec;

import org.rascalmpl.java.io.Closeable;
import org.rascalmpl.java.io.File;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.java.lang.Exception;
import org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.java.lang.InterruptedException;
import org.rascalmpl.java.lang.Process;
import org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.Thread;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.concurrent.Executors;
import org.rascalmpl.java.util.concurrent.ThreadFactory;
import org.rascalmpl.java.util.function.Supplier;
import org.rascalmpl.org.apache.commons.exec.CommandLine;
import org.rascalmpl.org.apache.commons.exec.ExecuteException;
import org.rascalmpl.org.apache.commons.exec.ExecuteResultHandler;
import org.rascalmpl.org.apache.commons.exec.ExecuteStreamHandler;
import org.rascalmpl.org.apache.commons.exec.ExecuteWatchdog;
import org.rascalmpl.org.apache.commons.exec.Executor;
import org.rascalmpl.org.apache.commons.exec.ProcessDestroyer;
import org.rascalmpl.org.apache.commons.exec.PumpStreamHandler;
import org.rascalmpl.org.apache.commons.exec.ThreadUtil;
import org.rascalmpl.org.apache.commons.exec.launcher.CommandLauncher;
import org.rascalmpl.org.apache.commons.exec.launcher.CommandLauncherFactory;

public class DefaultExecutor
extends org.rascalmpl.java.lang.Object
implements Executor {
    private ExecuteStreamHandler executeStreamHandler;
    private File workingDirectory;
    private ExecuteWatchdog watchdog;
    private int[] exitValues;
    private final CommandLauncher launcher;
    private ProcessDestroyer processDestroyer;
    private Thread executorThread;
    private IOException exceptionCaught;
    private final ThreadFactory threadFactory;

    public static Builder<?> builder() {
        return new Builder();
    }

    @Deprecated
    public DefaultExecutor() {
        this(Executors.defaultThreadFactory(), new PumpStreamHandler(), new File((String)"org.rascalmpl.."));
    }

    DefaultExecutor(ThreadFactory threadFactory, ExecuteStreamHandler executeStreamHandler, File workingDirectory) {
        this.threadFactory = threadFactory != null ? threadFactory : Executors.defaultThreadFactory();
        this.executeStreamHandler = executeStreamHandler != null ? executeStreamHandler : new PumpStreamHandler();
        this.workingDirectory = workingDirectory != null ? workingDirectory : new File((String)"org.rascalmpl..");
        this.launcher = CommandLauncherFactory.createVMLauncher();
        this.exitValues = new int[0];
    }

    private void checkWorkingDirectory() throws IOException {
        this.checkWorkingDirectory(this.workingDirectory);
    }

    private void checkWorkingDirectory(File directory) throws IOException {
        if (directory != null && !directory.exists()) {
            throw new IOException(new StringBuilder().append((org.rascalmpl.java.lang.Object)directory).append((String)"org.rascalmpl. doesn't exist.").toString());
        }
    }

    private void closeCatch(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            this.setExceptionCaught(e);
        }
    }

    private void closeProcessStreams(Process process) {
        this.closeCatch((Closeable)process.getInputStream());
        this.closeCatch((Closeable)process.getOutputStream());
        this.closeCatch((Closeable)process.getErrorStream());
    }

    protected Thread createThread(Runnable runnable, String name) {
        return ThreadUtil.newThread(this.threadFactory, runnable, name, false);
    }

    @Override
    public int execute(CommandLine command) throws ExecuteException, IOException {
        return this.execute(command, (Map<String, String>)((Map)null));
    }

    @Override
    public void execute(CommandLine command, ExecuteResultHandler handler) throws ExecuteException, IOException {
        this.execute(command, null, handler);
    }

    @Override
    public int execute(CommandLine command, Map<String, String> environment) throws ExecuteException, IOException {
        this.checkWorkingDirectory();
        return this.executeInternal(command, environment, this.workingDirectory, this.executeStreamHandler);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void execute(CommandLine command, Map<String, String> environment, ExecuteResultHandler handler) throws ExecuteException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got ()V
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeInternal(CommandLine command, Map<String, String> environment, File workingDirectory, ExecuteStreamHandler streams) throws IOException {
        Process process;
        this.exceptionCaught = null;
        try {
            process = this.launch(command, environment, workingDirectory);
        }
        catch (IOException e) {
            if (this.watchdog != null) {
                this.watchdog.failedToStart((Exception)((Object)e));
            }
            throw e;
        }
        try {
            this.setStreams(streams, process);
        }
        catch (IOException e) {
            process.destroy();
            if (this.watchdog != null) {
                this.watchdog.failedToStart((Exception)((Object)e));
            }
            throw e;
        }
        streams.start();
        try {
            if (this.getProcessDestroyer() != null) {
                this.getProcessDestroyer().add(process);
            }
            if (this.watchdog != null) {
                this.watchdog.start(process);
            }
            int exitValue = -559038737;
            try {
                exitValue = process.waitFor();
            }
            catch (InterruptedException e) {
                process.destroy();
            }
            finally {
                Thread.interrupted();
            }
            if (this.watchdog != null) {
                this.watchdog.stop();
            }
            try {
                streams.stop();
            }
            catch (IOException e) {
                this.setExceptionCaught(e);
            }
            this.closeProcessStreams(process);
            if (this.getExceptionCaught() != null) {
                throw this.getExceptionCaught();
            }
            if (this.watchdog != null) {
                try {
                    this.watchdog.checkException();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException((Throwable)((Object)e));
                }
            }
            if (this.isFailure(exitValue)) {
                throw new ExecuteException(new StringBuilder().append((String)"org.rascalmpl.Process exited with an error: ").append(exitValue).toString(), exitValue);
            }
            int n = exitValue;
            return n;
        }
        finally {
            if (this.getProcessDestroyer() != null) {
                this.getProcessDestroyer().remove(process);
            }
        }
    }

    private IOException getExceptionCaught() {
        return this.exceptionCaught;
    }

    protected Thread getExecutorThread() {
        return this.executorThread;
    }

    @Override
    public ProcessDestroyer getProcessDestroyer() {
        return this.processDestroyer;
    }

    @Override
    public ExecuteStreamHandler getStreamHandler() {
        return this.executeStreamHandler;
    }

    ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    @Override
    public ExecuteWatchdog getWatchdog() {
        return this.watchdog;
    }

    @Override
    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public boolean isFailure(int exitValue) {
        if (this.exitValues == null) {
            return false;
        }
        if (this.exitValues.length == 0) {
            return this.launcher.isFailure(exitValue);
        }
        for (int exitValue2 : this.exitValues) {
            if (exitValue2 != exitValue) continue;
            return false;
        }
        return true;
    }

    protected Process launch(CommandLine command, Map<String, String> env, File workingDirectory) throws IOException {
        if (this.launcher == null) {
            throw new IllegalStateException((String)"org.rascalmpl.CommandLauncher can not be null");
        }
        this.checkWorkingDirectory(workingDirectory);
        return this.launcher.exec(command, env, workingDirectory);
    }

    private void setExceptionCaught(IOException e) {
        if (this.exceptionCaught == null) {
            this.exceptionCaught = e;
        }
    }

    @Override
    public void setExitValue(int value) {
        this.setExitValues(new int[]{value});
    }

    @Override
    public void setExitValues(int[] values) {
        this.exitValues = values == null ? null : (int[])values.clone();
    }

    @Override
    public void setProcessDestroyer(ProcessDestroyer processDestroyer) {
        this.processDestroyer = processDestroyer;
    }

    @Override
    public void setStreamHandler(ExecuteStreamHandler streamHandler) {
        this.executeStreamHandler = streamHandler;
    }

    private void setStreams(ExecuteStreamHandler streams, Process process) throws IOException {
        streams.setProcessInputStream(process.getOutputStream());
        streams.setProcessOutputStream(process.getInputStream());
        streams.setProcessErrorStream(process.getErrorStream());
    }

    @Override
    public void setWatchdog(ExecuteWatchdog watchdog) {
        this.watchdog = watchdog;
    }

    @Override
    @Deprecated
    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    private /* synthetic */ void lambda$execute$0(CommandLine command, Map environment, ExecuteResultHandler handler) {
        int exitValue = -559038737;
        try {
            exitValue = this.executeInternal(command, (Map<String, String>)environment, this.workingDirectory, this.executeStreamHandler);
            handler.onProcessComplete(exitValue);
        }
        catch (ExecuteException e) {
            handler.onProcessFailed(e);
        }
        catch (Exception e) {
            handler.onProcessFailed(new ExecuteException((String)"org.rascalmpl.Execution failed", exitValue, (Throwable)((Object)e)));
        }
    }

    public static class Builder<T extends Builder<T>>
    extends org.rascalmpl.java.lang.Object
    implements Supplier<DefaultExecutor> {
        private ThreadFactory threadFactory;
        private ExecuteStreamHandler executeStreamHandler;
        private File workingDirectory;

        T asThis() {
            return (T)((Object)this);
        }

        public DefaultExecutor get() {
            return new DefaultExecutor(this.threadFactory, this.executeStreamHandler, this.workingDirectory);
        }

        ExecuteStreamHandler getExecuteStreamHandler() {
            return this.executeStreamHandler;
        }

        ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        File getWorkingDirectory() {
            return this.workingDirectory;
        }

        public T setExecuteStreamHandler(ExecuteStreamHandler executeStreamHandler) {
            this.executeStreamHandler = executeStreamHandler;
            return this.asThis();
        }

        public T setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this.asThis();
        }

        public T setWorkingDirectory(File workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this.asThis();
        }
    }
}

