/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.apache.commons.exec;

import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.io.InputStream;
import org.rascalmpl.java.io.OutputStream;
import org.rascalmpl.java.io.PipedOutputStream;
import org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.java.lang.Exception;
import org.rascalmpl.java.lang.InterruptedException;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.Thread;
import org.rascalmpl.java.time.Duration;
import org.rascalmpl.java.time.Instant;
import org.rascalmpl.java.time.temporal.TemporalAmount;
import org.rascalmpl.java.util.concurrent.Executors;
import org.rascalmpl.java.util.concurrent.ThreadFactory;
import org.rascalmpl.org.apache.commons.exec.ExecuteException;
import org.rascalmpl.org.apache.commons.exec.ExecuteStreamHandler;
import org.rascalmpl.org.apache.commons.exec.InputStreamPumper;
import org.rascalmpl.org.apache.commons.exec.StreamPumper;
import org.rascalmpl.org.apache.commons.exec.ThreadUtil;
import org.rascalmpl.org.apache.commons.exec.util.DebugUtils;

public class PumpStreamHandler
extends org.rascalmpl.java.lang.Object
implements ExecuteStreamHandler {
    private static final Duration STOP_TIMEOUT_ADDITION = Duration.ofSeconds((long)2L);
    private Thread outputThread;
    private Thread errorThread;
    private Thread inputThread;
    private final OutputStream outputStream;
    private final OutputStream errorOutputStream;
    private final InputStream inputStream;
    private InputStreamPumper inputStreamPumper;
    private Duration stopTimeout = Duration.ZERO;
    private IOException caught;
    private final ThreadFactory threadFactory;

    public PumpStreamHandler() {
        this((OutputStream)System.out, (OutputStream)System.err);
    }

    public PumpStreamHandler(OutputStream allOutputStream) {
        this(allOutputStream, allOutputStream);
    }

    public PumpStreamHandler(OutputStream outputStream, OutputStream errorOutputStream) {
        this(outputStream, errorOutputStream, null);
    }

    public PumpStreamHandler(OutputStream outputStream, OutputStream errorOutputStream, InputStream inputStream) {
        this(Executors.defaultThreadFactory(), outputStream, errorOutputStream, inputStream);
    }

    private PumpStreamHandler(ThreadFactory threadFactory, OutputStream outputStream, OutputStream errorOutputStream, InputStream inputStream) {
        this.threadFactory = threadFactory;
        this.outputStream = outputStream;
        this.errorOutputStream = errorOutputStream;
        this.inputStream = inputStream;
    }

    protected void createProcessErrorPump(InputStream is, OutputStream os) {
        this.errorThread = this.createPump(is, os);
    }

    protected void createProcessOutputPump(InputStream is, OutputStream os) {
        this.outputThread = this.createPump(is, os);
    }

    protected Thread createPump(InputStream is, OutputStream os) {
        return this.createPump(is, os, os instanceof PipedOutputStream);
    }

    protected Thread createPump(InputStream is, OutputStream os, boolean closeWhenExhausted) {
        return ThreadUtil.newThread(this.threadFactory, new StreamPumper(is, os, closeWhenExhausted), (String)"org.rascalmpl.CommonsExecStreamPumper-", true);
    }

    private Thread createSystemInPump(InputStream is, OutputStream os) {
        this.inputStreamPumper = new InputStreamPumper(is, os);
        return ThreadUtil.newThread(this.threadFactory, this.inputStreamPumper, (String)"org.rascalmpl.CommonsExecStreamPumper-", true);
    }

    protected OutputStream getErr() {
        return this.errorOutputStream;
    }

    protected OutputStream getOut() {
        return this.outputStream;
    }

    Duration getStopTimeout() {
        return this.stopTimeout;
    }

    @Override
    public void setProcessErrorStream(InputStream is) {
        if (this.errorOutputStream != null) {
            this.createProcessErrorPump(is, this.errorOutputStream);
        }
    }

    @Override
    public void setProcessInputStream(OutputStream os) {
        if (this.inputStream != null) {
            this.inputThread = this.inputStream == System.in ? this.createSystemInPump(this.inputStream, os) : this.createPump(this.inputStream, os, true);
        } else {
            try {
                os.close();
            }
            catch (IOException e) {
                java.lang.String msg = "org.rascalmpl.Got exception while closing output stream";
                DebugUtils.handleException((String)"org.rascalmpl.Got exception while closing output stream", (Exception)((Object)e));
            }
        }
    }

    @Override
    public void setProcessOutputStream(InputStream is) {
        if (this.outputStream != null) {
            this.createProcessOutputPump(is, this.outputStream);
        }
    }

    public void setStopTimeout(Duration timeout) {
        this.stopTimeout = timeout != null ? timeout : Duration.ZERO;
    }

    @Deprecated
    public void setStopTimeout(long timeout) {
        this.stopTimeout = Duration.ofMillis((long)timeout);
    }

    @Override
    public void start() {
        this.start(this.outputThread);
        this.start(this.errorThread);
        this.start(this.inputThread);
    }

    private void start(Thread thread) {
        if (thread != null) {
            thread.start();
        }
    }

    @Override
    public void stop() throws IOException {
        java.lang.String msg;
        if (this.inputStreamPumper != null) {
            this.inputStreamPumper.stopProcessing();
        }
        this.stop(this.outputThread, this.stopTimeout);
        this.stop(this.errorThread, this.stopTimeout);
        this.stop(this.inputThread, this.stopTimeout);
        if (this.errorOutputStream != null && this.errorOutputStream != this.outputStream) {
            try {
                this.errorOutputStream.flush();
            }
            catch (IOException e) {
                msg = new StringBuilder().append((String)"org.rascalmpl.Got exception while flushing the error stream : ").append(e.getMessage()).toString();
                DebugUtils.handleException((String)msg, (Exception)((Object)e));
            }
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (IOException e) {
                msg = "org.rascalmpl.Got exception while flushing the output stream";
                DebugUtils.handleException((String)"org.rascalmpl.Got exception while flushing the output stream", (Exception)((Object)e));
            }
        }
        if (this.caught != null) {
            throw this.caught;
        }
    }

    private void stop(Thread thread, Duration timeout) {
        if (thread != null) {
            try {
                if (timeout.equals((org.rascalmpl.java.lang.Object)Duration.ZERO)) {
                    thread.join();
                } else {
                    Duration timeToWait = timeout.plus(STOP_TIMEOUT_ADDITION);
                    Instant startTime = Instant.now();
                    thread.join(timeToWait.toMillis());
                    if (Instant.now().isAfter(startTime.plus((TemporalAmount)timeToWait))) {
                        this.caught = new ExecuteException(new StringBuilder().append((String)"org.rascalmpl.The stop timeout of ").append((org.rascalmpl.java.lang.Object)timeout).append((String)"org.rascalmpl. ms was exceeded").toString(), -559038737);
                    }
                }
            }
            catch (InterruptedException e) {
                thread.interrupt();
            }
        }
    }

    protected void stopThread(Thread thread, long timeoutMillis) {
        this.stop(thread, Duration.ofMillis((long)timeoutMillis));
    }
}

