/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.apache.commons.exec.launcher;

import org.rascalmpl.java.io.File;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.io.PrintWriter;
import org.rascalmpl.java.io.Writer;
import org.rascalmpl.java.lang.Process;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.nio.charset.Charset;
import org.rascalmpl.java.nio.file.Files;
import org.rascalmpl.java.nio.file.OpenOption;
import org.rascalmpl.java.nio.file.Path;
import org.rascalmpl.java.nio.file.attribute.FileAttribute;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.org.apache.commons.exec.CommandLine;
import org.rascalmpl.org.apache.commons.exec.launcher.Java13CommandLauncher;
import org.rascalmpl.org.apache.commons.exec.util.StringUtils;

public class VmsCommandLauncher
extends Java13CommandLauncher {
    private File createCommandFile(CommandLine cmd, Map<String, String> env) throws IOException {
        Path path = Files.createTempFile((String)"org.rascalmpl.EXEC", (String)"org.rascalmpl..TMP", (FileAttribute[])new FileAttribute[0]);
        File script = path.toFile();
        script.deleteOnExit();
        PrintWriter writer = new PrintWriter((Writer)Files.newBufferedWriter((Path)path, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]));
        try {
            String[] args;
            if (env != null) {
                Set entries = env.entrySet();
                for (Map.Entry entry : entries) {
                    writer.print((String)"org.rascalmpl.$ ");
                    writer.print((String)entry.getKey());
                    writer.print((String)"org.rascalmpl. == ");
                    writer.println('\"');
                    String value = (String)entry.getValue();
                    if (value.indexOf(34) > 0) {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < value.length(); ++i) {
                            char c = value.charAt(i);
                            if (c == '\"') {
                                sb.append('\"');
                            }
                            sb.append(c);
                        }
                        value = sb.toString();
                    }
                    writer.print(value);
                    writer.println('\"');
                }
            }
            String command = cmd.getExecutable();
            if (cmd.isFile()) {
                writer.print((String)"org.rascalmpl.$ @");
                String[] parts = StringUtils.split(command, (String)"org/rascalmpl//");
                writer.print(parts[0]);
                writer.print((String)"org.rascalmpl.:[");
                writer.print(parts[1]);
                int lastPart = parts.length - 1;
                for (int i = 2; i < lastPart; ++i) {
                    writer.print((String)"org.rascalmpl..");
                    writer.print(parts[i]);
                }
                writer.print((String)"org.rascalmpl.]");
                writer.print(parts[lastPart]);
            } else {
                writer.print((String)"org.rascalmpl.$ ");
                writer.print(command);
            }
            for (String arg : args = cmd.getArguments()) {
                writer.println((String)"org.rascalmpl. -");
                writer.print(arg);
            }
            writer.println();
        }
        catch (Throwable throwable) {
            try {
                writer.close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        writer.close();
        return script;
    }

    @Override
    public Process exec(CommandLine cmd, Map<String, String> env) throws IOException {
        return super.exec(new CommandLine(this.createCommandFile(cmd, env).getPath()), env);
    }

    @Override
    public Process exec(CommandLine cmd, Map<String, String> env, File workingDir) throws IOException {
        return super.exec(new CommandLine(this.createCommandFile(cmd, env).getPath()), env, workingDir);
    }

    @Override
    public boolean isFailure(int exitValue) {
        return exitValue % 2 == 0;
    }
}

