/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium;

import org.rascalmpl.java.io.Serializable;
import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.java.text.SimpleDateFormat;
import org.rascalmpl.java.util.Date;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.TimeZone;
import org.rascalmpl.java.util.TreeMap;

public class Cookie
extends Object
implements Serializable {
    private static final long serialVersionUID = 4115876353625612383L;
    private final String name;
    private final String value;
    private final String path;
    private final String domain;
    private final Date expiry;
    private final boolean isSecure;
    private final boolean isHttpOnly;
    private final String sameSite;

    public Cookie(String name, String value, String path, Date expiry) {
        this(name, value, null, path, expiry);
    }

    public Cookie(String name, String value, String domain, String path, Date expiry) {
        this(name, value, domain, path, expiry, false);
    }

    public Cookie(String name, String value, String domain, String path, Date expiry, boolean isSecure) {
        this(name, value, domain, path, expiry, isSecure, false);
    }

    public Cookie(String name, String value, String domain, String path, Date expiry, boolean isSecure, boolean isHttpOnly) {
        this(name, value, domain, path, expiry, isSecure, isHttpOnly, null);
    }

    public Cookie(String name, String value, String domain, String path, Date expiry, boolean isSecure, boolean isHttpOnly, String sameSite) {
        this.name = name;
        this.value = value;
        this.path = path == null || path.isEmpty() ? "org/rascalmpl//" : path;
        this.domain = Cookie.stripPort(domain);
        this.isSecure = isSecure;
        this.isHttpOnly = isHttpOnly;
        this.expiry = expiry != null ? new Date(expiry.getTime() / 1000L * 1000L) : null;
        this.sameSite = sameSite;
    }

    public Cookie(String name, String value) {
        this(name, value, (String)"org/rascalmpl//", null);
    }

    public Cookie(String name, String value, String path) {
        this(name, value, path, null);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public boolean isHttpOnly() {
        return this.isHttpOnly;
    }

    public Date getExpiry() {
        return this.expiry == null ? null : new Date(this.expiry.getTime());
    }

    public String getSameSite() {
        return this.sameSite;
    }

    private static String stripPort(String domain) {
        return domain == null ? null : domain.split((String)"org.rascalmpl.:")[0];
    }

    public void validate() {
        if (this.name == null || this.name.isEmpty() || this.value == null || this.path == null) {
            throw new IllegalArgumentException((String)"org.rascalmpl.Required attributes are not set or any non-null attribute set to null");
        }
        if (this.name.indexOf(59) != -1) {
            throw new IllegalArgumentException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.Cookie names cannot contain a ';': \u0001"}, (String)this.name));
        }
        if (this.domain != null && this.domain.contains((CharSequence)"org.rascalmpl.:")) {
            throw new IllegalArgumentException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.Domain should not contain a port: \u0001"}, (String)this.domain));
        }
    }

    public Map<String, Object> toJson() {
        TreeMap toReturn = new TreeMap();
        if (this.getDomain() != null) {
            toReturn.put((Object)"org.rascalmpl.domain", (Object)this.getDomain());
        }
        if (this.getExpiry() != null) {
            toReturn.put((Object)"org.rascalmpl.expiry", (Object)this.getExpiry());
        }
        if (this.getName() != null) {
            toReturn.put((Object)"org.rascalmpl.name", (Object)this.getName());
        }
        if (this.getPath() != null) {
            toReturn.put((Object)"org.rascalmpl.path", (Object)this.getPath());
        }
        if (this.getValue() != null) {
            toReturn.put((Object)"org.rascalmpl.value", (Object)this.getValue());
        }
        toReturn.put((Object)"org.rascalmpl.secure", (Object)Boolean.valueOf((boolean)this.isSecure()));
        toReturn.put((Object)"org.rascalmpl.httpOnly", (Object)Boolean.valueOf((boolean)this.isHttpOnly()));
        if (this.getSameSite() != null) {
            toReturn.put((Object)"org.rascalmpl.sameSite", (Object)this.getSameSite());
        }
        return toReturn;
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat((String)"org.rascalmpl.EEE, dd MMM yyyy HH:mm:ss z");
        sdf.setTimeZone(TimeZone.getTimeZone((String)"org.rascalmpl.GMT"));
        return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.\u0001=\u0001\u0001\u0001\u0001\u0001\u0001"}, (String)this.name, (String)this.value, (String)(this.expiry == null ? "org.rascalmpl." : StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.; expires=\u0001"}, (String)sdf.format(this.expiry))), (String)("org.rascalmpl.".equals((Object)this.path) ? "org.rascalmpl." : StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.; path=\u0001"}, (String)this.path)), (String)(this.domain == null ? "org.rascalmpl." : StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.; domain=\u0001"}, (String)this.domain)), (String)(this.isSecure ? "org.rascalmpl.;secure;" : "org.rascalmpl."), (String)(this.sameSite == null ? "org.rascalmpl." : StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.; sameSite=\u0001"}, (String)this.sameSite)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cookie)) {
            return false;
        }
        Cookie cookie = (Cookie)o;
        if (!this.name.equals((Object)cookie.name)) {
            return false;
        }
        return Objects.equals((Object)this.value, (Object)cookie.value);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static class Builder
    extends Object {
        private final String name;
        private final String value;
        private String path;
        private String domain;
        private Date expiry;
        private boolean secure;
        private boolean httpOnly;
        private String sameSite;

        public Builder(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public Builder domain(String host) {
            this.domain = Cookie.stripPort(host);
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder expiresOn(Date expiry) {
            this.expiry = expiry == null ? null : new Date(expiry.getTime());
            return this;
        }

        public Builder isSecure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder isHttpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        public Builder sameSite(String sameSite) {
            this.sameSite = sameSite;
            return this;
        }

        public Cookie build() {
            return new Cookie(this.name, this.value, this.domain, this.path, this.expiry, this.secure, this.httpOnly, this.sameSite);
        }
    }
}

