/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium;

import org.rascalmpl.java.io.File;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.nio.file.Files;
import org.rascalmpl.java.nio.file.OpenOption;
import org.rascalmpl.java.nio.file.Path;
import org.rascalmpl.java.nio.file.attribute.FileAttribute;
import org.rascalmpl.java.util.Base64;
import org.rascalmpl.org.openqa.selenium.WebDriverException;

public interface OutputType<T extends Object> {
    public static final OutputType<String> BASE64 = new OutputType<String>(){

        @Override
        public String convertFromBase64Png(String base64Png) {
            return base64Png;
        }

        @Override
        public String convertFromPngBytes(byte[] png) {
            return Base64.getEncoder().encodeToString(png);
        }

        public String toString() {
            return "org.rascalmpl.OutputType.BASE64";
        }
    };
    public static final OutputType<byte[]> BYTES = new OutputType<byte[]>(){

        @Override
        public byte[] convertFromBase64Png(String base64Png) {
            return Base64.getDecoder().decode(base64Png);
        }

        @Override
        public byte[] convertFromPngBytes(byte[] png) {
            return png;
        }

        public String toString() {
            return "org.rascalmpl.OutputType.BYTES";
        }
    };
    public static final OutputType<File> FILE = new OutputType<File>(){

        @Override
        public File convertFromBase64Png(String base64Png) {
            return this.save((byte[])BYTES.convertFromBase64Png(base64Png));
        }

        @Override
        public File convertFromPngBytes(byte[] data) {
            return this.save(data);
        }

        private File save(byte[] data) {
            try {
                Path tmpFilePath = Files.createTempFile((String)"org.rascalmpl.screenshot", (String)"org.rascalmpl..png", (FileAttribute[])new FileAttribute[0]);
                File tmpFile = tmpFilePath.toFile();
                tmpFile.deleteOnExit();
                Files.write((Path)tmpFilePath, (byte[])data, (OpenOption[])new OpenOption[0]);
                return tmpFile;
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)((java.lang.Object)e));
            }
        }

        public String toString() {
            return "org.rascalmpl.OutputType.FILE";
        }
    };

    public T convertFromBase64Png(String var1);

    public T convertFromPngBytes(byte[] var1);
}

