/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium;

import org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.NumberFormatException;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.regex.Matcher;
import org.rascalmpl.java.util.regex.Pattern;
import org.rascalmpl.org.openqa.selenium.WebDriverException;

public abstract class Platform
extends Enum<Platform> {
    public static final /* enum */ Platform WINDOWS = new Platform(new String[]{"org.rascalmpl."}){

        @Override
        public Platform family() {
            return null;
        }

        public String toString() {
            return "org.rascalmpl.windows";
        }
    };
    public static final /* enum */ Platform XP = new Platform(new String[]{"org.rascalmpl.Windows Server 2003", "org.rascalmpl.xp", "org.rascalmpl.windows", "org.rascalmpl.winnt", "org.rascalmpl.windows_nt", "org.rascalmpl.windows nt"}){

        @Override
        public Platform family() {
            return WINDOWS;
        }

        public String toString() {
            return "org.rascalmpl.Windows XP";
        }
    };
    public static final /* enum */ Platform VISTA = new Platform(new String[]{"org.rascalmpl.windows vista", "org.rascalmpl.Windows Server 2008"}){

        @Override
        public Platform family() {
            return WINDOWS;
        }

        public String toString() {
            return "org.rascalmpl.Windows Vista";
        }
    };
    public static final /* enum */ Platform WIN7 = new Platform(new String[]{"org.rascalmpl.windows 7", "org.rascalmpl.win7"}){

        @Override
        public Platform family() {
            return WINDOWS;
        }

        public String toString() {
            return "org.rascalmpl.Windows 7";
        }
    };
    public static final /* enum */ Platform WIN8 = new Platform(new String[]{"org.rascalmpl.Windows Server 2012", "org.rascalmpl.windows 8", "org.rascalmpl.win8"}){

        @Override
        public Platform family() {
            return WINDOWS;
        }

        public String toString() {
            return "org.rascalmpl.Windows 8";
        }
    };
    public static final /* enum */ Platform WIN8_1 = new Platform(new String[]{"org.rascalmpl.windows 8.1", "org.rascalmpl.win8.1"}){

        @Override
        public Platform family() {
            return WINDOWS;
        }

        public String toString() {
            return "org.rascalmpl.Windows 8.1";
        }
    };
    public static final /* enum */ Platform WIN10 = new Platform(new String[]{"org.rascalmpl.windows 10", "org.rascalmpl.win10"}){

        @Override
        public Platform family() {
            return WINDOWS;
        }

        public String toString() {
            return "org.rascalmpl.Windows 10";
        }
    };
    public static final /* enum */ Platform WIN11 = new Platform(new String[]{"org.rascalmpl.windows 11", "org.rascalmpl.win11"}){

        @Override
        public Platform family() {
            return WINDOWS;
        }

        public String toString() {
            return "org.rascalmpl.Windows 11";
        }
    };
    public static final /* enum */ Platform MAC = new Platform(new String[]{"org.rascalmpl.mac", "org.rascalmpl.darwin", "org.rascalmpl.macOS", "org.rascalmpl.mac os x", "org.rascalmpl.os x"}){

        @Override
        public Platform family() {
            return null;
        }

        public String toString() {
            return "org.rascalmpl.mac";
        }
    };
    public static final /* enum */ Platform SNOW_LEOPARD = new Platform(new String[]{"org.rascalmpl.snow leopard", "org.rascalmpl.os x 10.6", "org.rascalmpl.macos 10.6"}){

        @Override
        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "org.rascalmpl.OS X 10.6";
        }
    };
    public static final /* enum */ Platform MOUNTAIN_LION = new Platform(new String[]{"org.rascalmpl.mountain lion", "org.rascalmpl.os x 10.8", "org.rascalmpl.macos 10.8"}){

        @Override
        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "org.rascalmpl.OS X 10.8";
        }
    };
    public static final /* enum */ Platform MAVERICKS = new Platform(new String[]{"org.rascalmpl.mavericks", "org.rascalmpl.os x 10.9", "org.rascalmpl.macos 10.9"}){

        @Override
        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "org.rascalmpl.OS X 10.9";
        }
    };
    public static final /* enum */ Platform YOSEMITE = new Platform(new String[]{"org.rascalmpl.yosemite", "org.rascalmpl.os x 10.10", "org.rascalmpl.macos 10.10"}){

        @Override
        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "org.rascalmpl.OS X 10.10";
        }
    };
    public static final /* enum */ Platform EL_CAPITAN = new Platform(new String[]{"org.rascalmpl.el capitan", "org.rascalmpl.os x 10.11", "org.rascalmpl.macos 10.11"}){

        @Override
        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "org.rascalmpl.OS X 10.11";
        }
    };
    public static final /* enum */ Platform SIERRA = new Platform(new String[]{"org.rascalmpl.sierra", "org.rascalmpl.os x 10.12", "org.rascalmpl.macos 10.12"}){

        @Override
        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "org.rascalmpl.macOS 10.12";
        }
    };
    public static final /* enum */ Platform HIGH_SIERRA = new Platform(new String[]{"org.rascalmpl.high sierra", "org.rascalmpl.os x 10.13", "org.rascalmpl.macos 10.13"}){

        @Override
        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "org.rascalmpl.macOS 10.13";
        }
    };
    public static final /* enum */ Platform MOJAVE = new Platform(new String[]{"org.rascalmpl.mojave", "org.rascalmpl.os x 10.14", "org.rascalmpl.macos 10.14"}){

        @Override
        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "org.rascalmpl.macOS 10.14";
        }
    };
    public static final /* enum */ Platform CATALINA = new Platform(new String[]{"org.rascalmpl.catalina", "org.rascalmpl.os x 10.15", "org.rascalmpl.macos 10.15"}){

        @Override
        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "org.rascalmpl.macOS 10.15";
        }
    };
    public static final /* enum */ Platform BIG_SUR = new Platform(new String[]{"org.rascalmpl.big sur", "org.rascalmpl.os x 11.0", "org.rascalmpl.macos 11.0"}){

        @Override
        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "org.rascalmpl.macOS 11.0";
        }
    };
    public static final /* enum */ Platform MONTEREY = new Platform(new String[]{"org.rascalmpl.monterey", "org.rascalmpl.os x 12.0", "org.rascalmpl.macos 12.0"}){

        @Override
        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "org.rascalmpl.macOS 12.0";
        }
    };
    public static final /* enum */ Platform VENTURA = new Platform(new String[]{"org.rascalmpl.ventura", "org.rascalmpl.os x 13.0", "org.rascalmpl.macos 13.0"}){

        @Override
        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "org.rascalmpl.macOS 13.0";
        }
    };
    public static final /* enum */ Platform SONOMA = new Platform(new String[]{"org.rascalmpl.sonoma", "org.rascalmpl.os x 14.0", "org.rascalmpl.macos 14.0"}){

        @Override
        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "org.rascalmpl.macOS 14.0";
        }
    };
    public static final /* enum */ Platform UNIX = new Platform(new String[]{"org.rascalmpl.solaris", "org.rascalmpl.bsd"}){

        @Override
        public Platform family() {
            return null;
        }
    };
    public static final /* enum */ Platform LINUX = new Platform(new String[]{"org.rascalmpl.linux"}){

        @Override
        public Platform family() {
            return UNIX;
        }

        public String toString() {
            return "org.rascalmpl.linux";
        }
    };
    public static final /* enum */ Platform ANDROID = new Platform(new String[]{"org.rascalmpl.android", "org.rascalmpl.dalvik"}){

        @Override
        public Platform family() {
            return null;
        }
    };
    public static final /* enum */ Platform IOS = new Platform(new String[]{"org.rascalmpl.iOS"}){

        @Override
        public Platform family() {
            return null;
        }
    };
    public static final /* enum */ Platform ANY = new Platform(new String[]{"org.rascalmpl."}){

        @Override
        public Platform family() {
            return ANY;
        }

        @Override
        public boolean is(Platform compareWith) {
            return this == compareWith;
        }

        public String toString() {
            return "org.rascalmpl.any";
        }
    };
    private static Platform current;
    private final String[] partOfOsName;
    private int minorVersion = 0;
    private int majorVersion = 0;
    private static final /* synthetic */ Platform[] $VALUES;

    public static Platform[] values() {
        return (Platform[])$VALUES.clone();
    }

    public static Platform valueOf(String name) {
        return (Platform)Enum.valueOf(Platform.class, (String)name);
    }

    private Platform(String ... partOfOsName) {
        super((String)string, n);
        this.partOfOsName = partOfOsName;
    }

    public static Platform getCurrent() {
        if (current == null) {
            current = Platform.extractFromSysProperty(System.getProperty((String)"org.rascalmpl.os.name"));
            String version = System.getProperty((String)"org.rascalmpl.os.version", (String)"org.rascalmpl.0.0.0");
            int major = 0;
            int min2 = 0;
            Pattern pattern = Pattern.compile((String)"org.rascalmpl.^(\\d+)\\.(\\d+).*");
            Matcher matcher = pattern.matcher((CharSequence)version);
            if (matcher.matches()) {
                try {
                    major = Integer.parseInt((String)matcher.group(1));
                    min2 = Integer.parseInt((String)matcher.group(2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            Platform.current.majorVersion = major;
            Platform.current.minorVersion = min2;
        }
        return current;
    }

    public static Platform extractFromSysProperty(String osName) {
        return Platform.extractFromSysProperty(osName, System.getProperty((String)"org.rascalmpl.os.version"));
    }

    public static Platform extractFromSysProperty(String osName, String osVersion) {
        osName = osName.toLowerCase();
        if ("org.rascalmpl.dalvik".equalsIgnoreCase(System.getProperty((String)"org.rascalmpl.java.vm.name"))) {
            return ANDROID;
        }
        if (osVersion.equals((Object)"org.rascalmpl.6.2") && osName.startsWith((String)"org.rascalmpl.windows nt")) {
            return WIN8;
        }
        if (osVersion.equals((Object)"org.rascalmpl.6.3") && osName.startsWith((String)"org.rascalmpl.windows nt")) {
            return WIN8_1;
        }
        Platform mostLikely = UNIX;
        String previousMatch = null;
        for (Platform os : Platform.values()) {
            for (String matcher : os.partOfOsName) {
                if ("org.rascalmpl.".equals((Object)matcher)) continue;
                if (os.isExactMatch(osName, matcher = matcher.toLowerCase())) {
                    return os;
                }
                if (!os.isCurrentPlatform(osName, matcher) || !Platform.isBetterMatch(previousMatch, matcher)) continue;
                previousMatch = matcher;
                mostLikely = os;
            }
        }
        return mostLikely;
    }

    public static Platform fromString(String name) {
        for (Platform platform : Platform.values()) {
            if (!platform.toString().equalsIgnoreCase(name)) continue;
            return platform;
        }
        for (Platform os : Platform.values()) {
            for (String matcher : os.partOfOsName) {
                if (!name.equalsIgnoreCase(matcher)) continue;
                return os;
            }
        }
        throw new WebDriverException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.Unrecognized platform: \u0001"}, (String)name));
    }

    private static boolean isBetterMatch(String previous, String matcher) {
        return previous == null || matcher.length() >= previous.length();
    }

    public String[] getPartOfOsName() {
        return (String[])Arrays.copyOf((Object[])this.partOfOsName, (int)this.partOfOsName.length);
    }

    public boolean is(Platform compareWith) {
        return this == compareWith || compareWith == ANY || this.family() != null && this.family().is(compareWith);
    }

    public abstract Platform family();

    private boolean isCurrentPlatform(String osName, String matchAgainst) {
        return osName.contains((CharSequence)matchAgainst);
    }

    private boolean isExactMatch(String osName, String matchAgainst) {
        return matchAgainst.equals((Object)osName);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    private static /* synthetic */ Platform[] $values() {
        return new Platform[]{WINDOWS, XP, VISTA, WIN7, WIN8, WIN8_1, WIN10, WIN11, MAC, SNOW_LEOPARD, MOUNTAIN_LION, MAVERICKS, YOSEMITE, EL_CAPITAN, SIERRA, HIGH_SIERRA, MOJAVE, CATALINA, BIG_SUR, MONTEREY, VENTURA, SONOMA, UNIX, LINUX, ANDROID, IOS, ANY};
    }

    static {
        $VALUES = Platform.$values();
    }
}

