/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.bidi;

import org.rascalmpl.java.io.Closeable;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.reflect.Type;
import org.rascalmpl.java.time.Duration;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.java.util.function.Consumer;
import org.rascalmpl.org.openqa.selenium.bidi.BiDiSessionStatus;
import org.rascalmpl.org.openqa.selenium.bidi.Command;
import org.rascalmpl.org.openqa.selenium.bidi.Connection;
import org.rascalmpl.org.openqa.selenium.bidi.Event;
import org.rascalmpl.org.openqa.selenium.internal.Require;

public class BiDi
extends Object
implements Closeable {
    private final Duration timeout = Duration.ofSeconds((long)30L);
    private final Connection connection;

    public BiDi(Connection connection) {
        this.connection = Require.nonNull((String)"org.rascalmpl.WebSocket connection", connection);
    }

    public void close() {
        this.clearListeners();
        this.disconnectSession();
        this.connection.close();
    }

    public void disconnectSession() {
    }

    public <X extends Object> X send(Command<X> command) {
        Require.nonNull((String)"org.rascalmpl.Command to send", command);
        return this.connection.sendAndWait(command, this.timeout);
    }

    public <X extends Object> void addListener(Event<X> event, Consumer<X> handler) {
        Require.nonNull((String)"org.rascalmpl.Event to listen for", event);
        Require.nonNull((String)"org.rascalmpl.Handler to call", handler);
        this.send(new Command((String)"org.rascalmpl.session.subscribe", (Map<String, Object>)Map.of((Object)"org.rascalmpl.events", (Object)Collections.singletonList((Object)event.getMethod()))));
        this.connection.addListener(event, handler);
    }

    public <X extends Object> void addListener(String browsingContextId, Event<X> event, Consumer<X> handler) {
        Require.nonNull((String)"org.rascalmpl.Event to listen for", event);
        Require.nonNull((String)"org.rascalmpl.Browsing context id", browsingContextId);
        Require.nonNull((String)"org.rascalmpl.Handler to call", handler);
        this.send(new Command((String)"org.rascalmpl.session.subscribe", (Map<String, Object>)Map.of((Object)"org.rascalmpl.contexts", (Object)Collections.singletonList((Object)browsingContextId), (Object)"org.rascalmpl.events", (Object)Collections.singletonList((Object)event.getMethod()))));
        this.connection.addListener(event, handler);
    }

    public <X extends Object> void addListener(Set<String> browsingContextIds, Event<X> event, Consumer<X> handler) {
        Require.nonNull((String)"org.rascalmpl.List of browsing context ids", browsingContextIds);
        Require.nonNull((String)"org.rascalmpl.Event to listen for", event);
        Require.nonNull((String)"org.rascalmpl.Handler to call", handler);
        this.send(new Command((String)"org.rascalmpl.session.subscribe", (Map<String, Object>)Map.of((Object)"org.rascalmpl.contexts", browsingContextIds, (Object)"org.rascalmpl.events", (Object)Collections.singletonList((Object)event.getMethod()))));
        this.connection.addListener(event, handler);
    }

    public <X extends Object> void clearListener(Event<X> event) {
        Require.nonNull((String)"org.rascalmpl.Event to listen for", event);
        if (this.connection.isEventSubscribed(event)) {
            this.send(new Command((String)"org.rascalmpl.session.unsubscribe", (Map<String, Object>)Map.of((Object)"org.rascalmpl.events", (Object)Collections.singletonList((Object)event.getMethod()))));
            this.connection.clearListener(event);
        }
    }

    public void clearListeners() {
        this.connection.clearListeners();
    }

    public BiDiSessionStatus getBidiSessionStatus() {
        return (BiDiSessionStatus)((java.lang.Object)this.send(new Command((String)"org.rascalmpl.session.status", (Map<String, Object>)Collections.emptyMap(), (Type)BiDiSessionStatus.class)));
    }
}

