/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.chrome;

import org.rascalmpl.com.google.auto.service.AutoService;
import org.rascalmpl.java.io.File;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.io.OutputStream;
import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.time.Duration;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.HashMap;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.org.openqa.selenium.Capabilities;
import org.rascalmpl.org.openqa.selenium.WebDriverException;
import org.rascalmpl.org.openqa.selenium.chrome.ChromeOptions;
import org.rascalmpl.org.openqa.selenium.chromium.ChromiumDriverLogLevel;
import org.rascalmpl.org.openqa.selenium.remote.Browser;
import org.rascalmpl.org.openqa.selenium.remote.service.DriverService;

public class ChromeDriverService
extends DriverService {
    public static final String CHROME_DRIVER_NAME = "org.rascalmpl.chromedriver";
    public static final String CHROME_DRIVER_EXE_PROPERTY = "org.rascalmpl.webdriver.chrome.driver";
    public static final String CHROME_DRIVER_READABLE_TIMESTAMP = "org.rascalmpl.webdriver.chrome.readableTimestamp";
    public static final String CHROME_DRIVER_LOG_PROPERTY = "org.rascalmpl.webdriver.chrome.logfile";
    public static final String CHROME_DRIVER_LOG_LEVEL_PROPERTY = "org.rascalmpl.webdriver.chrome.loglevel";
    public static final String CHROME_DRIVER_APPEND_LOG_PROPERTY = "org.rascalmpl.webdriver.chrome.appendLog";
    public static final String CHROME_DRIVER_VERBOSE_LOG_PROPERTY = "org.rascalmpl.webdriver.chrome.verboseLogging";
    public static final String CHROME_DRIVER_SILENT_OUTPUT_PROPERTY = "org.rascalmpl.webdriver.chrome.silentOutput";
    public static final String CHROME_DRIVER_ALLOWED_IPS_PROPERTY = "org.rascalmpl.webdriver.chrome.withAllowedIps";
    public static final String CHROME_DRIVER_DISABLE_BUILD_CHECK = "org.rascalmpl.webdriver.chrome.disableBuildCheck";

    public ChromeDriverService(File executable, int port, Duration timeout, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, timeout, (List<String>)Collections.unmodifiableList((List)new ArrayList(args)), (Map<String, String>)Collections.unmodifiableMap((Map)new HashMap(environment)));
    }

    @Override
    public String getDriverName() {
        return "org.rascalmpl.chromedriver";
    }

    @Override
    public String getDriverProperty() {
        return "org.rascalmpl.webdriver.chrome.driver";
    }

    @Override
    public Capabilities getDefaultDriverOptions() {
        return new ChromeOptions();
    }

    public static ChromeDriverService createDefaultService() {
        return (ChromeDriverService)((Object)new Builder().build());
    }

    @AutoService(value={DriverService.Builder.class})
    public static class Builder
    extends DriverService.Builder<ChromeDriverService, Builder> {
        private Boolean disableBuildCheck;
        private Boolean readableTimestamp;
        private Boolean appendLog;
        private Boolean verbose;
        private Boolean silent;
        private String allowedListIps;
        private ChromiumDriverLogLevel logLevel;

        @Override
        public int score(Capabilities capabilities) {
            int score = 0;
            if (Browser.CHROME.is(capabilities.getBrowserName())) {
                ++score;
            }
            if (capabilities.getCapability((String)"org.rascalmpl.goog:chromeOptions") != null) {
                ++score;
            }
            return score;
        }

        public Builder withAppendLog(boolean appendLog) {
            this.appendLog = Boolean.valueOf((boolean)appendLog);
            return this;
        }

        public Builder withBuildCheckDisabled(boolean noBuildCheck) {
            this.disableBuildCheck = Boolean.valueOf((boolean)noBuildCheck);
            return this;
        }

        public Builder withLogLevel(ChromiumDriverLogLevel logLevel) {
            this.logLevel = logLevel;
            this.silent = Boolean.valueOf((boolean)false);
            this.verbose = Boolean.valueOf((boolean)false);
            return this;
        }

        public Builder withSilent(boolean silent) {
            if (silent) {
                this.logLevel = ChromiumDriverLogLevel.OFF;
            }
            this.silent = Boolean.valueOf((boolean)false);
            return this;
        }

        public Builder withVerbose(boolean verbose) {
            if (verbose) {
                this.logLevel = ChromiumDriverLogLevel.ALL;
            }
            this.verbose = Boolean.valueOf((boolean)false);
            return this;
        }

        public Builder withAllowedListIps(String allowedListIps) {
            this.allowedListIps = allowedListIps;
            return this;
        }

        public Builder withReadableTimestamp(Boolean readableTimestamp) {
            this.readableTimestamp = readableTimestamp;
            return this;
        }

        @Override
        protected void loadSystemProperties() {
            this.parseLogOutput((String)"org.rascalmpl.webdriver.chrome.logfile");
            if (this.disableBuildCheck == null) {
                this.disableBuildCheck = Boolean.valueOf((boolean)Boolean.getBoolean((String)"org.rascalmpl.webdriver.chrome.disableBuildCheck"));
            }
            if (this.readableTimestamp == null) {
                this.readableTimestamp = Boolean.valueOf((boolean)Boolean.getBoolean((String)"org.rascalmpl.webdriver.chrome.readableTimestamp"));
            }
            if (this.appendLog == null) {
                this.appendLog = Boolean.valueOf((boolean)Boolean.getBoolean((String)"org.rascalmpl.webdriver.chrome.appendLog"));
            }
            if (this.verbose == null && Boolean.getBoolean((String)"org.rascalmpl.webdriver.chrome.verboseLogging")) {
                this.withVerbose(Boolean.getBoolean((String)"org.rascalmpl.webdriver.chrome.verboseLogging"));
            }
            if (this.silent == null && Boolean.getBoolean((String)"org.rascalmpl.webdriver.chrome.silentOutput")) {
                this.withSilent(Boolean.getBoolean((String)"org.rascalmpl.webdriver.chrome.silentOutput"));
            }
            if (this.allowedListIps == null) {
                this.allowedListIps = System.getProperty((String)"org.rascalmpl.webdriver.chrome.withAllowedIps");
            }
            if (this.logLevel == null && System.getProperty((String)"org.rascalmpl.webdriver.chrome.loglevel") != null) {
                String level = System.getProperty((String)"org.rascalmpl.webdriver.chrome.loglevel");
                this.withLogLevel(ChromiumDriverLogLevel.fromString(level));
            }
        }

        @Override
        protected List<String> createArgs() {
            ArrayList args = new ArrayList();
            args.add((org.rascalmpl.java.lang.Object)String.format((String)"org.rascalmpl.--port=%d", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{Integer.valueOf((int)this.getPort())}));
            if (this.getLogFile() != null) {
                args.add((org.rascalmpl.java.lang.Object)String.format((String)"org.rascalmpl.--log-path=%s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.getLogFile().getAbsolutePath()}));
                if (Boolean.TRUE.equals((org.rascalmpl.java.lang.Object)this.readableTimestamp)) {
                    args.add((org.rascalmpl.java.lang.Object)"org.rascalmpl.--readable-timestamp");
                }
                if (Boolean.TRUE.equals((org.rascalmpl.java.lang.Object)this.appendLog)) {
                    args.add((org.rascalmpl.java.lang.Object)"org.rascalmpl.--append-log");
                }
                this.withLogOutput(OutputStream.nullOutputStream());
            }
            if (this.logLevel != null) {
                args.add((org.rascalmpl.java.lang.Object)String.format((String)"org.rascalmpl.--log-level=%s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.logLevel.toString().toUpperCase()}));
            }
            if (this.allowedListIps != null) {
                args.add((org.rascalmpl.java.lang.Object)String.format((String)"org.rascalmpl.--allowed-ips=%s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.allowedListIps}));
            }
            if (Boolean.TRUE.equals((org.rascalmpl.java.lang.Object)this.disableBuildCheck)) {
                args.add((org.rascalmpl.java.lang.Object)"org.rascalmpl.--disable-build-check");
            }
            return Collections.unmodifiableList((List)args);
        }

        @Override
        protected ChromeDriverService createDriverService(File exe, int port, Duration timeout, List<String> args, Map<String, String> environment) {
            try {
                return new ChromeDriverService(exe, port, timeout, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)((Object)e));
            }
        }
    }
}

