/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.concurrent;

import org.rascalmpl.java.lang.InterruptedException;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.Thread;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.util.concurrent.ExecutorService;
import org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.java.util.logging.Logger;

public class ExecutorServices
extends Object {
    private static final Logger LOG = Logger.getLogger((String)ExecutorServices.class.getName());

    public static void shutdownGracefully(String name, ExecutorService service) {
        service.shutdown();
        try {
            if (!service.awaitTermination(5L, TimeUnit.SECONDS)) {
                LOG.warning(String.format((String)"org.rascalmpl.Failed to shutdown %s", (Object[])new Object[]{name}));
                service.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.log(Level.WARNING, String.format((String)"org.rascalmpl.Failed to shutdown %s", (Object[])new Object[]{name}), (Throwable)((java.lang.Object)e));
            service.shutdownNow();
        }
    }
}

