/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.devtools;

import org.rascalmpl.java.io.UncheckedIOException;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.java.net.URI;
import org.rascalmpl.java.net.URISyntaxException;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.Optional;
import org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.org.openqa.selenium.Capabilities;
import org.rascalmpl.org.openqa.selenium.internal.Require;
import org.rascalmpl.org.openqa.selenium.json.Json;
import org.rascalmpl.org.openqa.selenium.remote.http.ClientConfig;
import org.rascalmpl.org.openqa.selenium.remote.http.Contents;
import org.rascalmpl.org.openqa.selenium.remote.http.HttpClient;
import org.rascalmpl.org.openqa.selenium.remote.http.HttpMethod;
import org.rascalmpl.org.openqa.selenium.remote.http.HttpRequest;
import org.rascalmpl.org.openqa.selenium.remote.http.HttpResponse;

public class CdpEndpointFinder
extends Object {
    private static final Logger LOG = Logger.getLogger((String)CdpEndpointFinder.class.getName());
    private static final Json JSON = new Json();

    public static HttpClient getHttpClient(HttpClient.Factory clientFactory, URI reportedUri) {
        Require.nonNull((String)"org.rascalmpl.HTTP client factory", clientFactory);
        Require.nonNull((String)"org.rascalmpl.DevTools URI", reportedUri);
        ClientConfig config = ClientConfig.defaultConfig().baseUri(reportedUri);
        return clientFactory.createClient(config);
    }

    public static Optional<URI> getCdpEndPoint(HttpClient client) {
        HttpResponse res;
        Require.nonNull((String)"org.rascalmpl.HTTP client", client);
        try {
            res = client.execute(new HttpRequest(HttpMethod.GET, (String)"org/rascalmpl//json/version"));
        }
        catch (UncheckedIOException e) {
            LOG.warning((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.Unable to connect to determine websocket url: \u0001"}, (String)e.getMessage()));
            return Optional.empty();
        }
        if (res.getStatus() != 200) {
            return Optional.empty();
        }
        Map versionData = (Map)JSON.toType(Contents.string(res), Json.MAP_TYPE);
        Object raw = versionData.get((Object)"org.rascalmpl.webSocketDebuggerUrl");
        if (!(raw instanceof String)) {
            return Optional.empty();
        }
        String debuggerUrl = (String)raw;
        try {
            return Optional.of((Object)new URI(debuggerUrl));
        }
        catch (URISyntaxException e) {
            LOG.warning((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.Invalid URI for endpoint \u0001"}, (String)String.valueOf((Object)raw)));
            return Optional.empty();
        }
    }

    /*
     * Exception decompiling
     */
    public static Optional<URI> getReportedUri(Capabilities caps) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter$TooOptimisticMatchException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter.getString(SwitchStringRewriter.java:404)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter.access$600(SwitchStringRewriter.java:53)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter$SwitchStringMatchResultCollector.collectMatches(SwitchStringRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.ResetAfterTest.match(ResetAfterTest.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.KleeneN.match(KleeneN.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.MatchSequence.match(MatchSequence.java:26)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.ResetAfterTest.match(ResetAfterTest.java:23)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter.rewriteComplex(SwitchStringRewriter.java:201)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter.rewrite(SwitchStringRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:881)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Optional<URI> getReportedUri(String capabilityKey, Capabilities caps) {
        Object raw = caps.getCapability(capabilityKey);
        if (raw instanceof Map) {
            raw = ((Map)raw).get((Object)"org.rascalmpl.debuggerAddress");
        }
        if (!(raw instanceof String)) {
            LOG.fine((String)"org.rascalmpl.No debugger address");
            return Optional.empty();
        }
        int index = ((String)raw).lastIndexOf(58);
        if (index == -1 || index == ((String)raw).length() - 1) {
            LOG.fine((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.No index in \u0001"}, (String)String.valueOf((Object)raw)));
            return Optional.empty();
        }
        try {
            URI uri = new URI(String.format((String)"org/rascalmpl/http://%s", (Object[])new Object[]{raw}));
            LOG.fine((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.URI found: \u0001"}, (String)String.valueOf((Object)uri)));
            return Optional.of((Object)uri);
        }
        catch (URISyntaxException e) {
            LOG.warning((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.Unable to create URI from: \u0001"}, (String)String.valueOf((Object)raw)));
            return Optional.empty();
        }
    }
}

