/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.devtools;

import org.rascalmpl.java.io.Closeable;
import org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.java.lang.Exception;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.lang.Void;
import org.rascalmpl.java.time.Duration;
import org.rascalmpl.java.util.Optional;
import org.rascalmpl.java.util.concurrent.ExecutionException;
import org.rascalmpl.java.util.function.BiConsumer;
import org.rascalmpl.java.util.function.Consumer;
import org.rascalmpl.java.util.function.Function;
import org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.org.openqa.selenium.devtools.Command;
import org.rascalmpl.org.openqa.selenium.devtools.Connection;
import org.rascalmpl.org.openqa.selenium.devtools.DevToolsException;
import org.rascalmpl.org.openqa.selenium.devtools.Event;
import org.rascalmpl.org.openqa.selenium.devtools.idealized.Domains;
import org.rascalmpl.org.openqa.selenium.devtools.idealized.target.model.SessionID;
import org.rascalmpl.org.openqa.selenium.devtools.idealized.target.model.TargetID;
import org.rascalmpl.org.openqa.selenium.devtools.idealized.target.model.TargetInfo;
import org.rascalmpl.org.openqa.selenium.internal.Require;

public class DevTools
extends org.rascalmpl.java.lang.Object
implements Closeable {
    private static final Logger LOG = Logger.getLogger((String)DevTools.class.getName());
    private final Domains protocol;
    private final Duration timeout = Duration.ofSeconds((long)10L);
    private final Connection connection;
    private SessionID cdpSession = null;

    public DevTools(Function<DevTools, Domains> protocol, Connection connection) {
        this.connection = Require.nonNull((String)"org.rascalmpl.WebSocket connection", connection);
        this.protocol = (Domains)Require.nonNull((String)"org.rascalmpl.CDP protocol", protocol).apply((org.rascalmpl.java.lang.Object)this);
    }

    public Domains getDomains() {
        return this.protocol;
    }

    public void close() {
        this.disconnectSession();
        this.connection.close();
    }

    public void disconnectSession() {
        if (this.cdpSession != null) {
            try {
                this.getDomains().network().disable();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, (String)"org.rascalmpl.Exception while disabling network", (Throwable)((Object)e));
            }
            SessionID id = this.cdpSession;
            this.cdpSession = null;
            try {
                this.connection.sendAndWait(this.cdpSession, this.getDomains().target().detachFromTarget((Optional<SessionID>)Optional.of((org.rascalmpl.java.lang.Object)id), (Optional<TargetID>)Optional.empty()), this.timeout);
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, (String)"org.rascalmpl.Exception while detaching from target", (Throwable)((Object)e));
            }
        }
    }

    public <X extends org.rascalmpl.java.lang.Object> X send(Command<X> command) {
        Require.nonNull((String)"org.rascalmpl.Command to send", command);
        return this.connection.sendAndWait(this.cdpSession, command, this.timeout);
    }

    /*
     * Exception decompiling
     */
    public <X extends org.rascalmpl.java.lang.Object> void addListener(Event<X> event, Consumer<X> handler) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;Lorg/rascalmpl/java/lang/Object;)V
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <X extends org.rascalmpl.java.lang.Object> void addListener(Event<X> event, BiConsumer<Long, X> handler) {
        Require.nonNull((String)"org.rascalmpl.Event to listen for", event);
        Require.nonNull((String)"org.rascalmpl.Handler to call", handler);
        this.connection.addListener(event, handler);
    }

    public void clearListeners() {
        this.getDomains().disableAll();
        this.connection.clearListeners();
    }

    public void createSessionIfThereIsNotOne() {
        this.createSessionIfThereIsNotOne(null);
    }

    public void createSessionIfThereIsNotOne(String windowHandle) {
        if (this.cdpSession == null) {
            this.createSession(windowHandle);
        }
    }

    public void createSession() {
        this.createSession(null);
    }

    /*
     * Exception decompiling
     */
    public void createSession(String windowHandle) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Lorg/rascalmpl/java/lang/Object;
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private TargetID findTarget(String windowHandle) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Z
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Throwable unwrapCause(ExecutionException e) {
        return e.getCause() != null ? e.getCause() : e;
    }

    public SessionID getCdpSession() {
        return this.cdpSession;
    }

    private static /* synthetic */ DevToolsException lambda$findTarget$4() {
        return new DevToolsException((String)"org.rascalmpl.Unable to find target id of a page");
    }

    private static /* synthetic */ boolean lambda$findTarget$3(String windowHandle, TargetID id) {
        return windowHandle == null || windowHandle.contains((CharSequence)id.toString());
    }

    private static /* synthetic */ boolean lambda$findTarget$2(TargetInfo info) {
        return "org.rascalmpl.page".equals((org.rascalmpl.java.lang.Object)info.getType());
    }

    private static /* synthetic */ Void lambda$createSession$1(Throwable t2) {
        LOG.log(Level.SEVERE, t2.getMessage(), t2);
        return null;
    }

    private static /* synthetic */ void lambda$addListener$0(Consumer handler, Long sequence, org.rascalmpl.java.lang.Object x) {
        handler.accept(x);
    }
}

