/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.edge;

import org.rascalmpl.com.google.auto.service.AutoService;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.Optional;
import org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.org.openqa.selenium.Capabilities;
import org.rascalmpl.org.openqa.selenium.ImmutableCapabilities;
import org.rascalmpl.org.openqa.selenium.SessionNotCreatedException;
import org.rascalmpl.org.openqa.selenium.WebDriver;
import org.rascalmpl.org.openqa.selenium.WebDriverInfo;
import org.rascalmpl.org.openqa.selenium.chromium.ChromiumDriverInfo;
import org.rascalmpl.org.openqa.selenium.edge.EdgeDriver;
import org.rascalmpl.org.openqa.selenium.edge.EdgeDriverService;
import org.rascalmpl.org.openqa.selenium.edge.EdgeOptions;
import org.rascalmpl.org.openqa.selenium.remote.Browser;
import org.rascalmpl.org.openqa.selenium.remote.service.DriverFinder;

@AutoService(value={WebDriverInfo.class})
public class EdgeDriverInfo
extends ChromiumDriverInfo {
    private static final Logger LOG = Logger.getLogger((String)EdgeDriverInfo.class.getName());

    @Override
    public String getDisplayName() {
        return "org.rascalmpl.Edge";
    }

    @Override
    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities((String)"org.rascalmpl.browserName", (Object)Browser.EDGE.browserName());
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        return Browser.EDGE.is(capabilities.getBrowserName()) || "org.rascalmpl.webview2".equalsIgnoreCase(capabilities.getBrowserName()) || capabilities.getCapability((String)"org.rascalmpl.ms:edgeOptions") != null;
    }

    @Override
    public boolean isSupportingCdp() {
        return true;
    }

    @Override
    public boolean isSupportingBiDi() {
        return true;
    }

    @Override
    public boolean isAvailable() {
        return new DriverFinder(EdgeDriverService.createDefaultService(), this.getCanonicalCapabilities()).isAvailable();
    }

    @Override
    public boolean isPresent() {
        return new DriverFinder(EdgeDriverService.createDefaultService(), this.getCanonicalCapabilities()).isPresent();
    }

    @Override
    public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
        if (!this.isAvailable() || !this.isSupporting(capabilities)) {
            return Optional.empty();
        }
        return Optional.of((Object)new EdgeDriver(new EdgeOptions().merge(capabilities)));
    }
}

