/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.edge;

import org.rascalmpl.com.google.auto.service.AutoService;
import org.rascalmpl.java.io.File;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.io.OutputStream;
import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.time.Duration;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.org.openqa.selenium.Capabilities;
import org.rascalmpl.org.openqa.selenium.WebDriverException;
import org.rascalmpl.org.openqa.selenium.chromium.ChromiumDriverLogLevel;
import org.rascalmpl.org.openqa.selenium.edge.EdgeOptions;
import org.rascalmpl.org.openqa.selenium.remote.Browser;
import org.rascalmpl.org.openqa.selenium.remote.service.DriverService;

public class EdgeDriverService
extends DriverService {
    public static final String EDGE_DRIVER_NAME = "org.rascalmpl.msedgedriver";
    public static final String EDGE_DRIVER_EXE_PROPERTY = "org.rascalmpl.webdriver.edge.driver";
    public static final String EDGE_DRIVER_READABLE_TIMESTAMP = "org.rascalmpl.webdriver.edge.readableTimestamp";
    public static final String EDGE_DRIVER_LOG_PROPERTY = "org.rascalmpl.webdriver.edge.logfile";
    public static final String EDGE_DRIVER_LOG_LEVEL_PROPERTY = "org.rascalmpl.webdriver.edge.loglevel";
    public static final String EDGE_DRIVER_APPEND_LOG_PROPERTY = "org.rascalmpl.webdriver.edge.appendLog";
    public static final String EDGE_DRIVER_VERBOSE_LOG_PROPERTY = "org.rascalmpl.webdriver.edge.verboseLogging";
    public static final String EDGE_DRIVER_SILENT_OUTPUT_PROPERTY = "org.rascalmpl.webdriver.edge.silentOutput";
    public static final String EDGE_DRIVER_ALLOWED_IPS_PROPERTY = "org.rascalmpl.webdriver.edge.withAllowedIps";
    public static final String EDGE_DRIVER_DISABLE_BUILD_CHECK = "org.rascalmpl.webdriver.edge.disableBuildCheck";

    public EdgeDriverService(File executable, int port, Duration timeout, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, timeout, (List<String>)List.copyOf(args), (Map<String, String>)Map.copyOf(environment));
    }

    @Override
    public String getDriverName() {
        return "org.rascalmpl.msedgedriver";
    }

    @Override
    public String getDriverProperty() {
        return "org.rascalmpl.webdriver.edge.driver";
    }

    @Override
    public Capabilities getDefaultDriverOptions() {
        return new EdgeOptions();
    }

    public static EdgeDriverService createDefaultService() {
        return (EdgeDriverService)((Object)new Builder().build());
    }

    @AutoService(value={DriverService.Builder.class})
    public static class Builder
    extends DriverService.Builder<EdgeDriverService, Builder> {
        private Boolean disableBuildCheck;
        private Boolean readableTimestamp;
        private Boolean appendLog;
        private Boolean verbose;
        private Boolean silent;
        private String allowedListIps;
        private ChromiumDriverLogLevel logLevel;

        @Override
        public int score(Capabilities capabilities) {
            int score = 0;
            if (Browser.EDGE.is(capabilities)) {
                ++score;
            }
            if ("org.rascalmpl.webview2".equalsIgnoreCase(capabilities.getBrowserName())) {
                ++score;
            }
            if (capabilities.getCapability((String)"org.rascalmpl.ms:edgeOptions") != null) {
                ++score;
            }
            return score;
        }

        public Builder withAppendLog(boolean appendLog) {
            this.appendLog = Boolean.valueOf((boolean)appendLog);
            return this;
        }

        public Builder withBuildCheckDisabled(boolean noBuildCheck) {
            this.disableBuildCheck = Boolean.valueOf((boolean)noBuildCheck);
            return this;
        }

        public Builder withLoglevel(ChromiumDriverLogLevel logLevel) {
            this.logLevel = logLevel;
            this.silent = Boolean.valueOf((boolean)false);
            this.verbose = Boolean.valueOf((boolean)false);
            return this;
        }

        public Builder withSilent(boolean silent) {
            if (silent) {
                this.logLevel = ChromiumDriverLogLevel.OFF;
            }
            this.silent = Boolean.valueOf((boolean)false);
            return this;
        }

        public Builder withVerbose(boolean verbose) {
            if (verbose) {
                this.logLevel = ChromiumDriverLogLevel.ALL;
            }
            this.verbose = Boolean.valueOf((boolean)false);
            return this;
        }

        public Builder withAllowedListIps(String allowedListIps) {
            this.allowedListIps = allowedListIps;
            return this;
        }

        public Builder withReadableTimestamp(Boolean readableTimestamp) {
            this.readableTimestamp = readableTimestamp;
            return this;
        }

        @Override
        protected void loadSystemProperties() {
            this.parseLogOutput((String)"org.rascalmpl.webdriver.edge.logfile");
            if (this.disableBuildCheck == null) {
                this.disableBuildCheck = Boolean.valueOf((boolean)Boolean.getBoolean((String)"org.rascalmpl.webdriver.edge.disableBuildCheck"));
            }
            if (this.readableTimestamp == null) {
                this.readableTimestamp = Boolean.valueOf((boolean)Boolean.getBoolean((String)"org.rascalmpl.webdriver.edge.readableTimestamp"));
            }
            if (this.appendLog == null) {
                this.appendLog = Boolean.valueOf((boolean)Boolean.getBoolean((String)"org.rascalmpl.webdriver.edge.appendLog"));
            }
            if (this.verbose == null && Boolean.getBoolean((String)"org.rascalmpl.webdriver.edge.verboseLogging")) {
                this.withVerbose(Boolean.getBoolean((String)"org.rascalmpl.webdriver.edge.verboseLogging"));
            }
            if (this.silent == null && Boolean.getBoolean((String)"org.rascalmpl.webdriver.edge.silentOutput")) {
                this.withSilent(Boolean.getBoolean((String)"org.rascalmpl.webdriver.edge.silentOutput"));
            }
            if (this.allowedListIps == null) {
                this.allowedListIps = System.getProperty((String)"org.rascalmpl.webdriver.edge.withAllowedIps");
            }
            if (this.logLevel == null && System.getProperty((String)"org.rascalmpl.webdriver.edge.loglevel") != null) {
                String level = System.getProperty((String)"org.rascalmpl.webdriver.edge.loglevel");
                this.withLoglevel(ChromiumDriverLogLevel.fromString(level));
            }
        }

        @Override
        protected List<String> createArgs() {
            ArrayList args = new ArrayList();
            args.add((org.rascalmpl.java.lang.Object)String.format((String)"org.rascalmpl.--port=%d", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{Integer.valueOf((int)this.getPort())}));
            if (this.getLogFile() != null) {
                args.add((org.rascalmpl.java.lang.Object)String.format((String)"org.rascalmpl.--log-path=%s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.getLogFile().getAbsolutePath()}));
                if (Boolean.TRUE.equals((org.rascalmpl.java.lang.Object)this.readableTimestamp)) {
                    args.add((org.rascalmpl.java.lang.Object)"org.rascalmpl.--readable-timestamp");
                }
                if (Boolean.TRUE.equals((org.rascalmpl.java.lang.Object)this.appendLog)) {
                    args.add((org.rascalmpl.java.lang.Object)"org.rascalmpl.--append-log");
                }
                this.withLogOutput(OutputStream.nullOutputStream());
            }
            if (this.logLevel != null) {
                args.add((org.rascalmpl.java.lang.Object)String.format((String)"org.rascalmpl.--log-level=%s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.logLevel.toString().toUpperCase()}));
            }
            if (Boolean.TRUE.equals((org.rascalmpl.java.lang.Object)this.silent)) {
                args.add((org.rascalmpl.java.lang.Object)"org.rascalmpl.--silent");
            }
            if (Boolean.TRUE.equals((org.rascalmpl.java.lang.Object)this.verbose)) {
                args.add((org.rascalmpl.java.lang.Object)"org.rascalmpl.--verbose");
            }
            if (this.allowedListIps != null) {
                args.add((org.rascalmpl.java.lang.Object)String.format((String)"org.rascalmpl.--allowed-ips=%s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.allowedListIps}));
            }
            if (Boolean.TRUE.equals((org.rascalmpl.java.lang.Object)this.disableBuildCheck)) {
                args.add((org.rascalmpl.java.lang.Object)"org.rascalmpl.--disable-build-check");
            }
            return List.copyOf((Collection)args);
        }

        @Override
        protected EdgeDriverService createDriverService(File exe, int port, Duration timeout, List<String> args, Map<String, String> environment) {
            try {
                return new EdgeDriverService(exe, port, timeout, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)((Object)e));
            }
        }
    }
}

