/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.firefox;

import org.rascalmpl.com.google.auto.service.AutoService;
import org.rascalmpl.java.io.File;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.time.Duration;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.HashMap;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.org.openqa.selenium.Capabilities;
import org.rascalmpl.org.openqa.selenium.WebDriverException;
import org.rascalmpl.org.openqa.selenium.firefox.FirefoxDriverLogLevel;
import org.rascalmpl.org.openqa.selenium.firefox.FirefoxDriverService;
import org.rascalmpl.org.openqa.selenium.firefox.FirefoxOptions;
import org.rascalmpl.org.openqa.selenium.net.PortProber;
import org.rascalmpl.org.openqa.selenium.remote.Browser;
import org.rascalmpl.org.openqa.selenium.remote.service.DriverService;

public class GeckoDriverService
extends FirefoxDriverService {
    public static final String GECKO_DRIVER_NAME = "org.rascalmpl.geckodriver";
    public static final String GECKO_DRIVER_EXE_PROPERTY = "org.rascalmpl.webdriver.gecko.driver";
    public static final String GECKO_DRIVER_LOG_PROPERTY = "org.rascalmpl.webdriver.firefox.logfile";
    public static final String GECKO_DRIVER_LOG_LEVEL_PROPERTY = "org.rascalmpl.webdriver.firefox.logLevel";
    public static final String GECKO_DRIVER_LOG_NO_TRUNCATE = "org.rascalmpl.webdriver.firefox.logTruncate";
    public static final String GECKO_DRIVER_PROFILE_ROOT = "org.rascalmpl.webdriver.firefox.profileRoot";

    public GeckoDriverService(File executable, int port, Duration timeout, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, timeout, (List<String>)Collections.unmodifiableList((List)new ArrayList(args)), (Map<String, String>)Collections.unmodifiableMap((Map)new HashMap(environment)));
    }

    @Override
    public String getDriverName() {
        return "org.rascalmpl.geckodriver";
    }

    @Override
    public String getDriverProperty() {
        return "org.rascalmpl.webdriver.gecko.driver";
    }

    @Override
    public Capabilities getDefaultDriverOptions() {
        return new FirefoxOptions();
    }

    public static GeckoDriverService createDefaultService() {
        return (GeckoDriverService)((Object)new Builder().build());
    }

    @Override
    protected void waitUntilAvailable() {
        PortProber.waitForPortUp(this.getUrl().getPort(), (int)this.getTimeout().toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    protected boolean hasShutdownEndpoint() {
        return false;
    }

    @AutoService(value={DriverService.Builder.class})
    public static class Builder
    extends FirefoxDriverService.Builder<GeckoDriverService, Builder> {
        private String allowHosts;
        private FirefoxDriverLogLevel logLevel;
        private Boolean logTruncate;
        private File profileRoot;

        @Override
        public int score(Capabilities capabilities) {
            int score = 0;
            if (Browser.FIREFOX.is(capabilities)) {
                ++score;
            }
            if (capabilities.getCapability((String)"org.rascalmpl.moz:firefoxOptions") != null) {
                ++score;
            }
            return score;
        }

        public Builder withAllowHosts(String allowHosts) {
            this.allowHosts = allowHosts;
            return this;
        }

        public Builder withLogLevel(FirefoxDriverLogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder withTruncatedLogs(Boolean truncate) {
            this.logTruncate = truncate;
            return this;
        }

        public Builder withProfileRoot(File root) {
            this.profileRoot = root;
            return this;
        }

        @Override
        protected void loadSystemProperties() {
            String profileRootFromProperty;
            String logFilePath;
            this.parseLogOutput((String)"org.rascalmpl.webdriver.firefox.logfile");
            if (this.logLevel == null && (logFilePath = System.getProperty((String)"org.rascalmpl.webdriver.firefox.logLevel")) != null) {
                this.logLevel = FirefoxDriverLogLevel.fromString(logFilePath);
            }
            if (this.logTruncate == null) {
                this.logTruncate = Boolean.valueOf((!Boolean.getBoolean((String)"org.rascalmpl.webdriver.firefox.logTruncate") ? 1 : 0) != 0);
            }
            if (this.profileRoot == null && (profileRootFromProperty = System.getProperty((String)"org.rascalmpl.webdriver.firefox.profileRoot")) != null) {
                this.profileRoot = new File(profileRootFromProperty);
            }
        }

        @Override
        protected List<String> createArgs() {
            ArrayList args = new ArrayList();
            args.add((org.rascalmpl.java.lang.Object)String.format((String)"org.rascalmpl.--port=%d", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{Integer.valueOf((int)this.getPort())}));
            int wsPort = PortProber.findFreePort();
            args.add((org.rascalmpl.java.lang.Object)String.format((String)"org.rascalmpl.--websocket-port=%d", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{Integer.valueOf((int)wsPort)}));
            args.add((org.rascalmpl.java.lang.Object)"org.rascalmpl.--allow-origins");
            args.add((org.rascalmpl.java.lang.Object)String.format((String)"org/rascalmpl/http://127.0.0.1:%d", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{Integer.valueOf((int)wsPort)}));
            args.add((org.rascalmpl.java.lang.Object)String.format((String)"org/rascalmpl/http://localhost:%d", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{Integer.valueOf((int)wsPort)}));
            args.add((org.rascalmpl.java.lang.Object)String.format((String)"org/rascalmpl/http://[::1]:%d", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{Integer.valueOf((int)wsPort)}));
            if (this.logLevel != null) {
                args.add((org.rascalmpl.java.lang.Object)"org.rascalmpl.--log");
                args.add((org.rascalmpl.java.lang.Object)this.logLevel.toString());
            }
            if (this.logTruncate != null && this.logTruncate.equals((org.rascalmpl.java.lang.Object)Boolean.FALSE)) {
                args.add((org.rascalmpl.java.lang.Object)"org.rascalmpl.--log-no-truncate");
            }
            if (this.profileRoot != null) {
                args.add((org.rascalmpl.java.lang.Object)"org.rascalmpl.--profile-root");
                args.add((org.rascalmpl.java.lang.Object)this.profileRoot.getAbsolutePath());
            }
            if (this.allowHosts != null) {
                args.add((org.rascalmpl.java.lang.Object)"org.rascalmpl.--allow-hosts");
                args.addAll((Collection)Arrays.asList((org.rascalmpl.java.lang.Object[])this.allowHosts.split((String)"org.rascalmpl. ")));
            }
            return Collections.unmodifiableList((List)args);
        }

        @Override
        protected GeckoDriverService createDriverService(File exe, int port, Duration timeout, List<String> args, Map<String, String> environment) {
            try {
                return new GeckoDriverService(exe, port, timeout, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)((Object)e));
            }
        }
    }
}

