/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.interactions;

import org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.Float;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.time.Duration;
import org.rascalmpl.java.util.HashMap;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.Optional;
import org.rascalmpl.java.util.UUID;
import org.rascalmpl.org.openqa.selenium.Point;
import org.rascalmpl.org.openqa.selenium.WebElement;
import org.rascalmpl.org.openqa.selenium.WrapsElement;
import org.rascalmpl.org.openqa.selenium.interactions.Encodable;
import org.rascalmpl.org.openqa.selenium.interactions.InputSource;
import org.rascalmpl.org.openqa.selenium.interactions.Interaction;
import org.rascalmpl.org.openqa.selenium.interactions.SourceType;
import org.rascalmpl.org.openqa.selenium.internal.Require;

public class PointerInput
extends org.rascalmpl.java.lang.Object
implements InputSource,
Encodable {
    private final Kind kind;
    private final String name;

    public PointerInput(Kind kind, String name) {
        this.kind = Require.nonNull((String)"org.rascalmpl.Kind of pointer device", kind);
        this.name = (String)Optional.ofNullable((org.rascalmpl.java.lang.Object)name).orElse((org.rascalmpl.java.lang.Object)UUID.randomUUID().toString());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SourceType getInputType() {
        return SourceType.POINTER;
    }

    @Override
    public Map<String, org.rascalmpl.java.lang.Object> encode() {
        HashMap toReturn = new HashMap();
        toReturn.put((org.rascalmpl.java.lang.Object)"org.rascalmpl.type", (org.rascalmpl.java.lang.Object)this.getInputType().getType());
        toReturn.put((org.rascalmpl.java.lang.Object)"org.rascalmpl.id", (org.rascalmpl.java.lang.Object)this.name);
        HashMap parameters = new HashMap();
        parameters.put((org.rascalmpl.java.lang.Object)"org.rascalmpl.pointerType", (org.rascalmpl.java.lang.Object)this.kind.getWireName());
        toReturn.put((org.rascalmpl.java.lang.Object)"org.rascalmpl.parameters", (org.rascalmpl.java.lang.Object)parameters);
        return toReturn;
    }

    public Interaction createPointerMove(Duration duration, Origin origin, int x, int y) {
        return new Move(this, duration, origin, x, y);
    }

    public Interaction createPointerMove(Duration duration, Origin origin, Point offset) {
        return this.createPointerMove(duration, origin, offset.x, offset.y);
    }

    public Interaction createPointerMove(Duration duration, Origin origin, int x, int y, PointerEventProperties eventProperties) {
        return new Move(this, duration, origin, x, y, eventProperties);
    }

    public Interaction createPointerMove(Duration duration, Origin origin, Point offset, PointerEventProperties eventProperties) {
        return this.createPointerMove(duration, origin, offset.x, offset.y, eventProperties);
    }

    public Interaction createPointerDown(int button) {
        return new PointerPress((InputSource)this, PointerPress.Direction.DOWN, button);
    }

    public Interaction createPointerDown(int button, PointerEventProperties eventProperties) {
        return new PointerPress(this, PointerPress.Direction.DOWN, button, eventProperties);
    }

    public Interaction createPointerUp(int button) {
        return new PointerPress((InputSource)this, PointerPress.Direction.UP, button);
    }

    public Interaction createPointerUp(int button, PointerEventProperties eventProperties) {
        return new PointerPress(this, PointerPress.Direction.UP, button, eventProperties);
    }

    public static PointerEventProperties eventProperties() {
        return new PointerEventProperties();
    }

    public static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind MOUSE = new Kind((String)"org.rascalmpl.MOUSE", 0, (String)"org.rascalmpl.mouse");
        public static final /* enum */ Kind PEN = new Kind((String)"org.rascalmpl.PEN", 1, (String)"org.rascalmpl.pen");
        public static final /* enum */ Kind TOUCH = new Kind((String)"org.rascalmpl.TOUCH", 2, (String)"org.rascalmpl.touch");
        private final String wireName;
        private static final /* synthetic */ Kind[] $VALUES;

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String name) {
            return (Kind)Enum.valueOf(Kind.class, (String)name);
        }

        private Kind(String pointerSubType) {
            super((String)string, n);
            this.wireName = pointerSubType;
        }

        public String getWireName() {
            return this.wireName;
        }

        private static /* synthetic */ Kind[] $values() {
            return new Kind[]{MOUSE, PEN, TOUCH};
        }

        static {
            $VALUES = Kind.$values();
        }
    }

    private static class Move
    extends Interaction
    implements Encodable {
        private final Origin origin;
        private final int x;
        private final int y;
        private final Duration duration;
        private final PointerEventProperties eventProperties;

        protected Move(InputSource source, Duration duration, Origin origin, int x, int y, PointerEventProperties eventProperties) {
            super(source);
            this.origin = Require.nonNull((String)"org.rascalmpl.Origin of move", origin);
            this.x = x;
            this.y = y;
            this.duration = Require.nonNegative(duration);
            this.eventProperties = Require.nonNull((String)"org.rascalmpl.pointer event properties", eventProperties);
        }

        protected Move(PointerInput source, Duration duration, Origin origin, int x, int y) {
            this(source, duration, origin, x, y, new PointerEventProperties());
        }

        @Override
        protected boolean isValidFor(SourceType sourceType) {
            return SourceType.POINTER == sourceType;
        }

        @Override
        public Map<String, org.rascalmpl.java.lang.Object> encode() {
            Map<String, org.rascalmpl.java.lang.Object> toReturn = this.eventProperties.encode();
            toReturn.put((org.rascalmpl.java.lang.Object)"org.rascalmpl.type", (org.rascalmpl.java.lang.Object)"org.rascalmpl.pointerMove");
            toReturn.put((org.rascalmpl.java.lang.Object)"org.rascalmpl.duration", (org.rascalmpl.java.lang.Object)Long.valueOf((long)this.duration.toMillis()));
            toReturn.put((org.rascalmpl.java.lang.Object)"org.rascalmpl.origin", this.origin.asArg());
            toReturn.put((org.rascalmpl.java.lang.Object)"org.rascalmpl.x", (org.rascalmpl.java.lang.Object)Integer.valueOf((int)this.x));
            toReturn.put((org.rascalmpl.java.lang.Object)"org.rascalmpl.y", (org.rascalmpl.java.lang.Object)Integer.valueOf((int)this.y));
            return toReturn;
        }
    }

    public static final class Origin
    extends org.rascalmpl.java.lang.Object {
        private final org.rascalmpl.java.lang.Object originObject;

        public org.rascalmpl.java.lang.Object asArg() {
            org.rascalmpl.java.lang.Object arg = this.originObject;
            while (arg instanceof WrapsElement) {
                arg = ((WrapsElement)arg).getWrappedElement();
            }
            return arg;
        }

        private Origin(org.rascalmpl.java.lang.Object originObject) {
            this.originObject = originObject;
        }

        public static Origin pointer() {
            return new Origin((org.rascalmpl.java.lang.Object)"org.rascalmpl.pointer");
        }

        public static Origin viewport() {
            return new Origin((org.rascalmpl.java.lang.Object)"org.rascalmpl.viewport");
        }

        public static Origin fromElement(WebElement element) {
            return new Origin(Require.nonNull((String)"org.rascalmpl.Element", element));
        }
    }

    public static class PointerEventProperties
    extends org.rascalmpl.java.lang.Object
    implements Encodable {
        private Float width = null;
        private Float height = null;
        private Float pressure = null;
        private Float tangentialPressure = null;
        private Integer tiltX = null;
        private Integer tiltY = null;
        private Integer twist = null;
        private Float altitudeAngle = null;
        private Float azimuthAngle = null;

        public PointerEventProperties setWidth(float width) {
            Require.nonNull((String)"org.rascalmpl.width", Float.valueOf((float)width));
            if (width < 0.0f) {
                throw new IllegalArgumentException((String)"org.rascalmpl.Width must be a positive Number");
            }
            this.width = Float.valueOf((float)width);
            return this;
        }

        public PointerEventProperties setHeight(float height) {
            Require.nonNull((String)"org.rascalmpl.height", Float.valueOf((float)height));
            if (height < 0.0f) {
                throw new IllegalArgumentException((String)"org.rascalmpl.Height must be a positive Number");
            }
            this.height = Float.valueOf((float)height);
            return this;
        }

        public PointerEventProperties setPressure(float pressure) {
            Require.nonNull((String)"org.rascalmpl.pressure", Float.valueOf((float)pressure));
            if (pressure < 0.0f || pressure > 1.0f) {
                throw new IllegalArgumentException((String)"org.rascalmpl.pressure must be a number between 0 and 1");
            }
            this.pressure = Float.valueOf((float)pressure);
            return this;
        }

        public PointerEventProperties setTangentialPressure(float tangentialPressure) {
            Require.nonNull((String)"org.rascalmpl.tangentialPressure", Float.valueOf((float)tangentialPressure));
            if (tangentialPressure < -1.0f || tangentialPressure > 1.0f) {
                throw new IllegalArgumentException((String)"org.rascalmpl.tangentialPressure must be a Number between -1 and 1");
            }
            this.tangentialPressure = Float.valueOf((float)tangentialPressure);
            return this;
        }

        public PointerEventProperties setTiltX(int tiltX) {
            Require.nonNull((String)"org.rascalmpl.tiltX", Integer.valueOf((int)tiltX));
            if (tiltX < -90 || tiltX > 90) {
                throw new IllegalArgumentException((String)"org.rascalmpl.tiltX must be an integer between -90 and 90");
            }
            this.tiltX = Integer.valueOf((int)tiltX);
            return this;
        }

        public PointerEventProperties setTiltY(int tiltY) {
            Require.nonNull((String)"org.rascalmpl.tiltY", Integer.valueOf((int)tiltY));
            if (tiltY < -90 || tiltY > 90) {
                throw new IllegalArgumentException((String)"org.rascalmpl.tiltY must be an integer between -90 and 90");
            }
            this.tiltY = Integer.valueOf((int)tiltY);
            return this;
        }

        public PointerEventProperties setTwist(int twist) {
            Require.nonNull((String)"org.rascalmpl.twist", Integer.valueOf((int)twist));
            if (twist < 0 || twist > 359) {
                throw new IllegalArgumentException((String)"org.rascalmpl.twist must be an integer between 0 and 359");
            }
            this.twist = Integer.valueOf((int)twist);
            return this;
        }

        public PointerEventProperties setAltitudeAngle(float altitudeAngle) {
            Require.nonNull((String)"org.rascalmpl.altitudeAngle", Float.valueOf((float)altitudeAngle));
            if (altitudeAngle < 0.0f || (double)altitudeAngle > 1.5707963267948966) {
                throw new IllegalArgumentException((String)"org/rascalmpl/altitudeAngle must be a number between 0 and \u03c0/2");
            }
            this.altitudeAngle = Float.valueOf((float)altitudeAngle);
            return this;
        }

        public PointerEventProperties setAzimuthAngle(float azimuthAngle) {
            Require.nonNull((String)"org.rascalmpl.azimuthAngle", Float.valueOf((float)azimuthAngle));
            if (azimuthAngle < 0.0f || (double)azimuthAngle > Math.PI * 2) {
                throw new IllegalArgumentException((String)"org.rascalmpl.azimuthAngle must be a number between 0 and 2\u03c0");
            }
            this.azimuthAngle = Float.valueOf((float)azimuthAngle);
            return this;
        }

        /*
         * Exception decompiling
         */
        @Override
        public Map<String, org.rascalmpl.java.lang.Object> encode() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)V
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static /* synthetic */ void lambda$encode$8(Map toReturn, Float v) {
            toReturn.put((org.rascalmpl.java.lang.Object)"org.rascalmpl.azimuthAngle", (org.rascalmpl.java.lang.Object)v);
        }

        private static /* synthetic */ void lambda$encode$7(Map toReturn, Float v) {
            toReturn.put((org.rascalmpl.java.lang.Object)"org.rascalmpl.altitudeAngle", (org.rascalmpl.java.lang.Object)v);
        }

        private static /* synthetic */ void lambda$encode$6(Map toReturn, Integer v) {
            toReturn.put((org.rascalmpl.java.lang.Object)"org.rascalmpl.twist", (org.rascalmpl.java.lang.Object)v);
        }

        private static /* synthetic */ void lambda$encode$5(Map toReturn, Integer v) {
            toReturn.put((org.rascalmpl.java.lang.Object)"org.rascalmpl.tiltY", (org.rascalmpl.java.lang.Object)v);
        }

        private static /* synthetic */ void lambda$encode$4(Map toReturn, Integer v) {
            toReturn.put((org.rascalmpl.java.lang.Object)"org.rascalmpl.tiltX", (org.rascalmpl.java.lang.Object)v);
        }

        private static /* synthetic */ void lambda$encode$3(Map toReturn, Float v) {
            toReturn.put((org.rascalmpl.java.lang.Object)"org.rascalmpl.tangentialPressure", (org.rascalmpl.java.lang.Object)v);
        }

        private static /* synthetic */ void lambda$encode$2(Map toReturn, Float v) {
            toReturn.put((org.rascalmpl.java.lang.Object)"org.rascalmpl.pressure", (org.rascalmpl.java.lang.Object)v);
        }

        private static /* synthetic */ void lambda$encode$1(Map toReturn, Float v) {
            toReturn.put((org.rascalmpl.java.lang.Object)"org.rascalmpl.height", (org.rascalmpl.java.lang.Object)v);
        }

        private static /* synthetic */ void lambda$encode$0(Map toReturn, Float v) {
            toReturn.put((org.rascalmpl.java.lang.Object)"org.rascalmpl.width", (org.rascalmpl.java.lang.Object)v);
        }
    }

    private static class PointerPress
    extends Interaction
    implements Encodable {
        private final Direction direction;
        private final int button;
        private final PointerEventProperties eventProperties;

        public PointerPress(InputSource source, Direction direction, int button) {
            super(source);
            if (button < 0) {
                throw new IllegalStateException(String.format((String)"org.rascalmpl.Button must be greater than or equal to 0: %d", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{Integer.valueOf((int)button)}));
            }
            this.direction = Require.nonNull((String)"org.rascalmpl.Direction of move", direction);
            this.button = button;
            this.eventProperties = new PointerEventProperties();
        }

        @Deprecated
        public PointerPress(InputSource source, Direction direction, PointerEventProperties eventProperties) {
            this(source, direction, 0, eventProperties);
        }

        public PointerPress(InputSource source, Direction direction, int button, PointerEventProperties eventProperties) {
            super(source);
            this.button = button;
            this.eventProperties = Require.nonNull((String)"org.rascalmpl.pointer event properties", eventProperties);
            this.direction = Require.nonNull((String)"org.rascalmpl.Direction of press", direction);
        }

        @Override
        public Map<String, org.rascalmpl.java.lang.Object> encode() {
            Map<String, org.rascalmpl.java.lang.Object> toReturn = this.eventProperties.encode();
            toReturn.put((org.rascalmpl.java.lang.Object)"org.rascalmpl.type", (org.rascalmpl.java.lang.Object)this.direction.getType());
            toReturn.put((org.rascalmpl.java.lang.Object)"org.rascalmpl.button", (org.rascalmpl.java.lang.Object)Integer.valueOf((int)this.button));
            return toReturn;
        }

        static final class Direction
        extends Enum<Direction> {
            public static final /* enum */ Direction DOWN = new Direction((String)"org.rascalmpl.DOWN", 0, (String)"org.rascalmpl.pointerDown");
            public static final /* enum */ Direction UP = new Direction((String)"org.rascalmpl.UP", 1, (String)"org.rascalmpl.pointerUp");
            private final String type;
            private static final /* synthetic */ Direction[] $VALUES;

            public static Direction[] values() {
                return (Direction[])$VALUES.clone();
            }

            public static Direction valueOf(String name) {
                return (Direction)Enum.valueOf(Direction.class, (String)name);
            }

            private Direction(String type) {
                super((String)string, n);
                this.type = type;
            }

            public String getType() {
                return this.type;
            }

            private static /* synthetic */ Direction[] $values() {
                return new Direction[]{DOWN, UP};
            }

            static {
                $VALUES = Direction.$values();
            }
        }
    }

    public static final class MouseButton
    extends Enum<MouseButton> {
        public static final /* enum */ MouseButton LEFT = new MouseButton((String)"org.rascalmpl.LEFT", 0, 0);
        public static final /* enum */ MouseButton MIDDLE = new MouseButton((String)"org.rascalmpl.MIDDLE", 1, 1);
        public static final /* enum */ MouseButton RIGHT = new MouseButton((String)"org.rascalmpl.RIGHT", 2, 2);
        public static final /* enum */ MouseButton BACK = new MouseButton((String)"org.rascalmpl.BACK", 3, 3);
        public static final /* enum */ MouseButton FORWARD = new MouseButton((String)"org.rascalmpl.FORWARD", 4, 4);
        private final int button;
        private static final /* synthetic */ MouseButton[] $VALUES;

        public static MouseButton[] values() {
            return (MouseButton[])$VALUES.clone();
        }

        public static MouseButton valueOf(String name) {
            return (MouseButton)Enum.valueOf(MouseButton.class, (String)name);
        }

        private MouseButton(int button) {
            super((String)string, n);
            this.button = button;
        }

        public int asArg() {
            return this.button;
        }

        private static /* synthetic */ MouseButton[] $values() {
            return new MouseButton[]{LEFT, MIDDLE, RIGHT, BACK, FORWARD};
        }

        static {
            $VALUES = MouseButton.$values();
        }
    }
}

