/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.internal;

import org.rascalmpl.java.io.File;
import org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.java.lang.Double;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.java.nio.file.Files;
import org.rascalmpl.java.nio.file.LinkOption;
import org.rascalmpl.java.nio.file.Path;
import org.rascalmpl.java.time.Duration;
import org.rascalmpl.java.util.Objects;

public final class Require
extends org.rascalmpl.java.lang.Object {
    private static final String MUST_BE_SET = "org.rascalmpl.%s must be set";
    private static final String MUST_EXIST = "org.rascalmpl.%s must exist: %s";
    private static final String MUST_BE_DIR = "org.rascalmpl.%s must be a directory: %s";
    private static final String MUST_BE_FILE = "org.rascalmpl.%s must be a regular file: %s";
    private static final String MUST_BE_EQUAL = "org.rascalmpl.%s must be equal to `%s`";
    private static final String MUST_BE_EXECUTABLE = "org.rascalmpl.%s must be executable: %s";
    private static final String MUST_BE_NON_NEGATIVE = "org.rascalmpl.%s must be 0 or greater";
    private static final String MUST_BE_POSITIVE = "org.rascalmpl.%s must be greater than 0";

    private Require() {
    }

    public static void precondition(boolean condition, String message, org.rascalmpl.java.lang.Object ... args) {
        if (!condition) {
            throw new IllegalArgumentException(String.format((String)message, (org.rascalmpl.java.lang.Object[])args));
        }
    }

    public static <T extends org.rascalmpl.java.lang.Object> T nonNull(String argName, T arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be set", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{argName}));
        }
        return arg;
    }

    public static <T extends org.rascalmpl.java.lang.Object> T nonNull(String argName, T arg, String message, org.rascalmpl.java.lang.Object ... args) {
        if (arg == null) {
            throw new IllegalArgumentException(String.join((CharSequence)"org.rascalmpl. ", (CharSequence[])new CharSequence[]{argName, String.format((String)message, (org.rascalmpl.java.lang.Object[])args)}));
        }
        return arg;
    }

    public static <T extends org.rascalmpl.java.lang.Object> ArgumentChecker<T> argument(String argName, T arg) {
        return new ArgumentChecker<T>(argName, arg);
    }

    public static Duration nonNegative(String argName, Duration arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be set", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{argName}));
        }
        if (arg.isNegative()) {
            throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be 0 or greater", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{argName}));
        }
        return arg;
    }

    public static Duration nonNegative(Duration arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be set", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.Duration"}));
        }
        if (arg.isNegative()) {
            throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be 0 or greater", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.Duration"}));
        }
        return arg;
    }

    public static Duration positive(String argName, Duration arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be set", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{argName}));
        }
        if (arg.isNegative() || arg.isZero()) {
            throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be greater than 0", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{argName}));
        }
        return arg;
    }

    public static Duration positive(Duration arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be set", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.Duration"}));
        }
        if (arg.isNegative() || arg.isZero()) {
            throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be greater than 0", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.Duration"}));
        }
        return arg;
    }

    public static int nonNegative(String argName, Integer number) {
        if (number == null) {
            throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be set", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{argName}));
        }
        if (number.intValue() < 0) {
            throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be 0 or greater", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{argName}));
        }
        return number.intValue();
    }

    public static int positive(String argName, Integer number, String message) {
        if (number == null) {
            throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be set", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{argName}));
        }
        if (number.intValue() <= 0) {
            if (message == null) {
                throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be greater than 0", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{argName}));
            }
            throw new IllegalArgumentException(message);
        }
        return number.intValue();
    }

    public static double positive(String argName, Double number, String message) {
        if (number == null) {
            throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be set", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{argName}));
        }
        if (number.doubleValue() <= 0.0) {
            if (message == null) {
                throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be greater than 0", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{argName}));
            }
            throw new IllegalArgumentException(message);
        }
        return number.doubleValue();
    }

    public static double positive(String argName, Double number) {
        return Require.positive(argName, number, null);
    }

    public static int positive(String argName, Integer number) {
        return Require.positive(argName, number, null);
    }

    public static IntChecker argument(String argName, Integer number) {
        return new IntChecker(argName, number);
    }

    @Deprecated(forRemoval=true)
    public static FileChecker argument(String argName, File file) {
        return new FileChecker(argName, file);
    }

    public static PathChecker argument(String argName, Path path) {
        return new PathChecker(argName, path);
    }

    public static void stateCondition(boolean state, String message, org.rascalmpl.java.lang.Object ... args) {
        if (!state) {
            throw new IllegalStateException(String.format((String)message, (org.rascalmpl.java.lang.Object[])args));
        }
    }

    public static <T extends org.rascalmpl.java.lang.Object> StateChecker<T> state(String name, T state) {
        return new StateChecker<T>(name, state);
    }

    @Deprecated(forRemoval=true)
    public static FileStateChecker state(String name, File file) {
        return new FileStateChecker(name, file);
    }

    public static PathStateChecker state(String name, Path path) {
        return new PathStateChecker(name, path);
    }

    public static class ArgumentChecker<T extends org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object {
        private final String argName;
        private final T arg;

        ArgumentChecker(String argName, T arg) {
            this.argName = argName;
            this.arg = arg;
        }

        public T nonNull() {
            if (this.arg == null) {
                throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be set", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.argName}));
            }
            return this.arg;
        }

        public T nonNull(String message, org.rascalmpl.java.lang.Object ... args) {
            if (this.arg == null) {
                throw new IllegalArgumentException(String.format((String)message, (org.rascalmpl.java.lang.Object[])args));
            }
            return this.arg;
        }

        public T equalTo(org.rascalmpl.java.lang.Object other) {
            if (this.arg == null) {
                throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be set", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.argName}));
            }
            if (!Objects.equals(this.arg, (org.rascalmpl.java.lang.Object)other)) {
                throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be equal to `%s`", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.argName, other}));
            }
            return this.arg;
        }

        public T instanceOf(Class<?> cls) {
            if (this.arg == null) {
                throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be set", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.argName}));
            }
            if (!cls.isInstance(this.arg)) {
                throw new IllegalArgumentException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.\u0001 must be an instance of \u0001"}, (String)this.argName, (String)String.valueOf(cls)));
            }
            return this.arg;
        }
    }

    public static class IntChecker
    extends org.rascalmpl.java.lang.Object {
        private final String argName;
        private final Integer number;

        IntChecker(String argName, Integer number) {
            this.argName = argName;
            this.number = number;
        }

        public int greaterThan(int max, String message) {
            if (this.number == null) {
                throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be set", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.argName}));
            }
            if (this.number.intValue() <= max) {
                throw new IllegalArgumentException(message);
            }
            return this.number.intValue();
        }
    }

    @Deprecated(forRemoval=true)
    public static class FileChecker
    extends org.rascalmpl.java.lang.Object {
        private final String argName;
        private final File file;

        FileChecker(String argName, File file) {
            this.argName = argName;
            this.file = file;
        }

        public File isFile() {
            if (this.file == null) {
                throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be set", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.argName}));
            }
            if (!this.file.exists()) {
                throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must exist: %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.argName, this.file.getAbsolutePath()}));
            }
            if (!this.file.isFile()) {
                throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be a regular file: %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.argName, this.file.getAbsolutePath()}));
            }
            return this.file;
        }

        public File isDirectory() {
            if (this.file == null) {
                throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be set", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.argName}));
            }
            if (!this.file.exists()) {
                throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must exist: %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.argName, this.file.getAbsolutePath()}));
            }
            if (!this.file.isDirectory()) {
                throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be a directory: %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.argName, this.file.getAbsolutePath()}));
            }
            return this.file;
        }
    }

    public static class PathChecker
    extends org.rascalmpl.java.lang.Object {
        private final String argName;
        private final Path path;

        PathChecker(String argName, Path path) {
            this.argName = argName;
            this.path = path;
        }

        public Path isFile() {
            if (this.path == null) {
                throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be set", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.argName}));
            }
            if (!Files.exists((Path)this.path, (LinkOption[])new LinkOption[0])) {
                throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must exist: %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.argName, this.path.toAbsolutePath()}));
            }
            if (!Files.isRegularFile((Path)this.path, (LinkOption[])new LinkOption[0])) {
                throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be a regular file: %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.argName, this.path.toAbsolutePath()}));
            }
            return this.path;
        }

        public Path isDirectory() {
            if (this.path == null) {
                throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be set", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.argName}));
            }
            if (!Files.exists((Path)this.path, (LinkOption[])new LinkOption[0])) {
                throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must exist: %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.argName, this.path.toAbsolutePath()}));
            }
            if (!Files.isDirectory((Path)this.path, (LinkOption[])new LinkOption[0])) {
                throw new IllegalArgumentException(String.format((String)"org.rascalmpl.%s must be a directory: %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.argName, this.path.toAbsolutePath()}));
            }
            return this.path;
        }
    }

    public static class StateChecker<T extends org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object {
        private final String name;
        private final T state;

        StateChecker(String name, T state) {
            this.name = name;
            this.state = state;
        }

        public T nonNull() {
            if (this.state == null) {
                throw new IllegalStateException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.\u0001 must not be null"}, (String)this.name));
            }
            return this.state;
        }

        public T nonNull(String message, org.rascalmpl.java.lang.Object ... args) {
            if (this.state == null) {
                throw new IllegalStateException(String.join((CharSequence)"org.rascalmpl. ", (CharSequence[])new CharSequence[]{this.name, String.format((String)message, (org.rascalmpl.java.lang.Object[])args)}));
            }
            return this.state;
        }

        public T instanceOf(Class<?> cls) {
            if (this.state == null) {
                throw new IllegalStateException(String.format((String)"org.rascalmpl.%s must be set", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.name}));
            }
            if (!cls.isInstance(this.state)) {
                throw new IllegalStateException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.\u0001 must be an instance of \u0001"}, (String)this.name, (String)String.valueOf(cls)));
            }
            return this.state;
        }
    }

    @Deprecated(forRemoval=true)
    public static class FileStateChecker
    extends org.rascalmpl.java.lang.Object {
        private final String name;
        private final File file;

        FileStateChecker(String name, File file) {
            this.name = name;
            this.file = file;
        }

        public File isFile() {
            if (this.file == null) {
                throw new IllegalStateException(String.format((String)"org.rascalmpl.%s must be set", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.name}));
            }
            if (!this.file.exists()) {
                throw new IllegalStateException(String.format((String)"org.rascalmpl.%s must exist: %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.name, this.file.getAbsolutePath()}));
            }
            if (!this.file.isFile()) {
                throw new IllegalStateException(String.format((String)"org.rascalmpl.%s must be a regular file: %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.name, this.file.getAbsolutePath()}));
            }
            return this.file;
        }

        public File isDirectory() {
            if (this.file == null) {
                throw new IllegalStateException(String.format((String)"org.rascalmpl.%s must be set", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.name}));
            }
            if (!this.file.exists()) {
                throw new IllegalStateException(String.format((String)"org.rascalmpl.%s must exist: %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.name, this.file.getAbsolutePath()}));
            }
            if (!this.file.isDirectory()) {
                throw new IllegalStateException(String.format((String)"org.rascalmpl.%s must be a directory: %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.name, this.file.getAbsolutePath()}));
            }
            return this.file;
        }

        public File isExecutable() {
            if (this.file == null) {
                throw new IllegalStateException(String.format((String)"org.rascalmpl.%s must be set", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.name}));
            }
            if (!this.file.exists()) {
                throw new IllegalStateException(String.format((String)"org.rascalmpl.%s must exist: %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.name, this.file.getAbsolutePath()}));
            }
            if (!this.file.canExecute()) {
                throw new IllegalStateException(String.format((String)"org.rascalmpl.%s must be executable: %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.name, this.file.getAbsolutePath()}));
            }
            return this.file;
        }
    }

    public static class PathStateChecker
    extends org.rascalmpl.java.lang.Object {
        private final String name;
        private final Path path;

        PathStateChecker(String name, Path path) {
            this.name = name;
            this.path = path;
        }

        public Path isFile() {
            if (this.path == null) {
                throw new IllegalStateException(String.format((String)"org.rascalmpl.%s must be set", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.name}));
            }
            if (!Files.exists((Path)this.path, (LinkOption[])new LinkOption[0])) {
                throw new IllegalStateException(String.format((String)"org.rascalmpl.%s must exist: %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.name, this.path}));
            }
            if (!Files.isRegularFile((Path)this.path, (LinkOption[])new LinkOption[0])) {
                throw new IllegalStateException(String.format((String)"org.rascalmpl.%s must be a regular file: %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.name, this.path}));
            }
            return this.path;
        }

        public Path isDirectory() {
            if (this.path == null) {
                throw new IllegalStateException(String.format((String)"org.rascalmpl.%s must be set", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.name}));
            }
            if (!Files.exists((Path)this.path, (LinkOption[])new LinkOption[0])) {
                throw new IllegalStateException(String.format((String)"org.rascalmpl.%s must exist: %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.name, this.path}));
            }
            if (!Files.isDirectory((Path)this.path, (LinkOption[])new LinkOption[0])) {
                throw new IllegalStateException(String.format((String)"org.rascalmpl.%s must be a directory: %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.name, this.path}));
            }
            return this.path;
        }

        public Path isExecutable() {
            if (this.path == null) {
                throw new IllegalStateException(String.format((String)"org.rascalmpl.%s must be set", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.name}));
            }
            if (!Files.exists((Path)this.path, (LinkOption[])new LinkOption[0])) {
                throw new IllegalStateException(String.format((String)"org.rascalmpl.%s must exist: %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.name, this.path}));
            }
            if (!Files.isExecutable((Path)this.path)) {
                throw new IllegalStateException(String.format((String)"org.rascalmpl.%s must be executable: %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.name, this.path}));
            }
            return this.path;
        }
    }
}

