/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.io;

import org.rascalmpl.java.io.OutputStream;
import org.rascalmpl.java.lang.Math;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.nio.charset.Charset;

public class CircularOutputStream
extends OutputStream {
    private static final int DEFAULT_SIZE = 4096;
    private int end;
    private boolean filled = false;
    private final byte[] buffer;

    public CircularOutputStream(int maxSize) {
        this.buffer = new byte[maxSize];
    }

    public CircularOutputStream() {
        this(4096);
    }

    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public synchronized void write(byte[] b, int off, int len) {
        int bufferSize = this.buffer.length;
        while (len > 0) {
            int chunk = Math.min((int)bufferSize, (int)len);
            if (bufferSize >= this.end + chunk) {
                System.arraycopy((Object)b, (int)off, (Object)this.buffer, (int)this.end, (int)chunk);
                this.end += chunk;
            } else {
                int space = bufferSize - this.end;
                System.arraycopy((Object)b, (int)off, (Object)this.buffer, (int)this.end, (int)space);
                this.filled = true;
                this.end = chunk - space;
                System.arraycopy((Object)b, (int)(off + space), (Object)this.buffer, (int)0, (int)this.end);
            }
            off += chunk;
            len -= chunk;
        }
    }

    public synchronized void write(int b) {
        if (this.end == this.buffer.length) {
            this.filled = true;
            this.end = 0;
        }
        this.buffer[this.end++] = (byte)b;
    }

    public void flush() {
    }

    public void close() {
    }

    public String toString() {
        return this.toString(Charset.defaultCharset());
    }

    public synchronized String toString(Charset encoding) {
        int size = this.filled ? this.buffer.length : this.end;
        byte[] toReturn = new byte[size];
        if (!this.filled) {
            System.arraycopy((Object)this.buffer, (int)0, (Object)toReturn, (int)0, (int)this.end);
            return new String(toReturn, encoding);
        }
        int n = this.buffer.length - this.end;
        System.arraycopy((Object)this.buffer, (int)this.end, (Object)toReturn, (int)0, (int)n);
        System.arraycopy((Object)this.buffer, (int)0, (Object)toReturn, (int)n, (int)this.end);
        return new String(toReturn, encoding);
    }
}

