/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.io;

import org.rascalmpl.java.io.File;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.io.UncheckedIOException;
import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.Runtime;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.Thread;
import org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.java.util.concurrent.locks.Lock;
import org.rascalmpl.java.util.concurrent.locks.ReadWriteLock;
import org.rascalmpl.java.util.concurrent.locks.ReentrantReadWriteLock;
import org.rascalmpl.org.openqa.selenium.io.FileHandler;

public class TemporaryFilesystem
extends Object {
    private final Set<File> temporaryFiles;
    private final File baseDir;
    private final Thread shutdownHook;
    private static final File sysTemp = new File(System.getProperty((String)"org.rascalmpl.java.io.tmpdir"));
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static TemporaryFilesystem instance = new TemporaryFilesystem(sysTemp);

    public static TemporaryFilesystem getDefaultTmpFS() {
        Lock readLock = lock.readLock();
        readLock.lock();
        try {
            TemporaryFilesystem temporaryFilesystem = instance;
            return temporaryFilesystem;
        }
        finally {
            readLock.unlock();
        }
    }

    public static void setTemporaryDirectory(File directory) {
        Lock writeLock = lock.writeLock();
        writeLock.lock();
        try {
            instance = new TemporaryFilesystem(directory);
        }
        finally {
            writeLock.unlock();
        }
    }

    public static TemporaryFilesystem getTmpFsBasedOn(File directory) {
        return new TemporaryFilesystem(directory);
    }

    /*
     * Exception decompiling
     */
    private TemporaryFilesystem(File baseDir) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got ()V
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public File createTempDir(String prefix, String suffix) {
        try {
            File file = File.createTempFile((String)prefix, (String)suffix, (File)this.baseDir);
            if (!file.delete()) {
                throw new IOException((String)"org.rascalmpl.Unable to create temp file");
            }
            File dir = new File(file.getAbsolutePath());
            if (!dir.mkdirs()) {
                throw new UncheckedIOException(new IOException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.Cannot create profile directory at \u0001"}, (String)dir.getAbsolutePath())));
            }
            FileHandler.createDir(dir);
            this.temporaryFiles.add((Object)dir);
            return dir;
        }
        catch (IOException e) {
            throw new UncheckedIOException(new IOException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.Unable to create temporary file at \u0001"}, (String)this.baseDir.getAbsolutePath())));
        }
    }

    public void deleteTempDir(File file) {
        if (!this.shouldReap()) {
            return;
        }
        if (this.temporaryFiles.remove((Object)file)) {
            FileHandler.delete(file);
        }
    }

    public void deleteTemporaryFiles() {
        if (!this.shouldReap()) {
            return;
        }
        for (File file : this.temporaryFiles) {
            try {
                FileHandler.delete(file);
            }
            catch (UncheckedIOException uncheckedIOException) {}
        }
    }

    boolean shouldReap() {
        String reap = System.getProperty((String)"org.rascalmpl.webdriver.reap_profile", (String)"org.rascalmpl.true");
        return Boolean.parseBoolean((String)reap);
    }

    public boolean deleteBaseDir() {
        boolean wasDeleted = this.baseDir.delete();
        if (!this.baseDir.exists()) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        return wasDeleted;
    }

    public File getBaseDir() {
        return this.baseDir;
    }
}

