/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.json;

import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.io.Reader;
import org.rascalmpl.java.io.UncheckedIOException;
import org.rascalmpl.java.lang.Math;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.invoke.CallSite;
import org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.org.openqa.selenium.internal.Require;

class Input
extends Object {
    public static final char EOF = '\uffff';
    private static final int BUFFER_SIZE = 4096;
    private static final int MEMORY_SIZE = 128;
    private final Reader source;
    private final char[] buffer;
    private int filled;
    private int position;

    public Input(Reader source) {
        this.source = Require.nonNull((String)"org.rascalmpl.Source", source);
        this.buffer = new char[4224];
        this.filled = 0;
        this.position = -1;
    }

    public char peek() {
        return this.fill() ? this.buffer[this.position + 1] : (char)'\uffff';
    }

    public char read() {
        return this.fill() ? this.buffer[++this.position] : (char)'\uffff';
    }

    public String toString() {
        int length;
        int offset;
        if (this.position < 128) {
            offset = 0;
            length = this.position + 1;
        } else {
            offset = this.position + 1 - 128;
            length = 128;
        }
        CallSite last = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.Last \u0001 characters read: \u0001"}, (int)length, (String)new String(this.buffer, offset, length));
        int next = Math.min((int)128, (int)(this.filled - (offset + length)));
        if (next > 0) {
            if (next > 128) {
                next = 128;
            }
            return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.\u0001, next \u0001 characters to read: \u0001"}, (String)last, (int)next, (String)new String(this.buffer, offset + length, next));
        }
        return last;
    }

    private boolean fill() {
        while (this.filled == this.position + 1) {
            try {
                int n;
                int shift = this.filled - 128;
                if (shift > 0) {
                    this.position -= shift;
                    this.filled -= shift;
                    System.arraycopy((Object)this.buffer, (int)shift, (Object)this.buffer, (int)0, (int)this.filled);
                }
                if ((n = this.source.read(this.buffer, this.filled, this.buffer.length - this.filled)) == -1) {
                    return false;
                }
                this.filled += n;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e.getMessage(), e);
            }
        }
        return true;
    }
}

