/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.json;

import org.rascalmpl.java.io.Closeable;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.io.Reader;
import org.rascalmpl.java.io.UncheckedIOException;
import org.rascalmpl.java.lang.Character;
import org.rascalmpl.java.lang.Double;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.Number;
import org.rascalmpl.java.lang.NumberFormatException;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.java.lang.reflect.Type;
import org.rascalmpl.java.math.BigDecimal;
import org.rascalmpl.java.time.Instant;
import org.rascalmpl.java.util.ArrayDeque;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Deque;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.function.Function;
import org.rascalmpl.org.openqa.selenium.internal.Require;
import org.rascalmpl.org.openqa.selenium.json.Input;
import org.rascalmpl.org.openqa.selenium.json.JsonException;
import org.rascalmpl.org.openqa.selenium.json.JsonType;
import org.rascalmpl.org.openqa.selenium.json.JsonTypeCoercer;
import org.rascalmpl.org.openqa.selenium.json.PropertySetting;
import org.rascalmpl.org.openqa.selenium.json.TypeCoercer;

public class JsonInput
extends org.rascalmpl.java.lang.Object
implements Closeable {
    private final Reader source;
    private final boolean readPerformed = false;
    private JsonTypeCoercer coercer;
    private PropertySetting setter;
    private final Input input;
    private final Deque<Container> stack = new ArrayDeque();

    JsonInput(Reader source, JsonTypeCoercer coercer, PropertySetting setter) {
        this.source = Require.nonNull((String)"org.rascalmpl.Source", source);
        this.coercer = Require.nonNull((String)"org.rascalmpl.Coercer", coercer);
        this.input = new Input(source);
        this.setter = Require.nonNull((String)"org.rascalmpl.Setter", setter);
    }

    public PropertySetting propertySetting(PropertySetting setter) {
        PropertySetting previous = this.setter;
        this.setter = Require.nonNull((String)"org.rascalmpl.Setter", setter);
        return previous;
    }

    public JsonInput addCoercers(TypeCoercer<?> ... coercers) {
        return this.addCoercers((Iterable<TypeCoercer<?>>)Arrays.asList((org.rascalmpl.java.lang.Object[])coercers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonInput addCoercers(Iterable<TypeCoercer<?>> coercers) {
        JsonInput jsonInput = this;
        synchronized (jsonInput) {
            this.coercer = new JsonTypeCoercer(this.coercer, coercers);
        }
        return this;
    }

    public void close() {
        try {
            this.source.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public JsonType peek() {
        this.skipWhitespace(this.input);
        switch (this.input.peek()) {
            case 'f': 
            case 't': {
                return JsonType.BOOLEAN;
            }
            case 'n': {
                return JsonType.NULL;
            }
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return JsonType.NUMBER;
            }
            case '\"': {
                return this.isReadingName() ? JsonType.NAME : JsonType.STRING;
            }
            case '{': {
                return JsonType.START_MAP;
            }
            case '}': {
                return JsonType.END_MAP;
            }
            case '[': {
                return JsonType.START_COLLECTION;
            }
            case ']': {
                return JsonType.END_COLLECTION;
            }
            case '\uffff': {
                return JsonType.END;
            }
        }
        char c = this.input.read();
        throw new JsonException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.Unable to determine type from: \u0001. \u0001"}, (char)c, (String)String.valueOf((org.rascalmpl.java.lang.Object)this.input)));
    }

    /*
     * Exception decompiling
     */
    public boolean nextBoolean() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Lorg/rascalmpl/java/lang/Object;
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String nextName() {
        this.expect(JsonType.NAME);
        String name = this.readString();
        this.skipWhitespace(this.input);
        char read = this.input.read();
        if (read != ':') {
            throw new JsonException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.Unable to read name. Expected colon separator, but saw '\u0001'"}, (char)read));
        }
        return name;
    }

    /*
     * Exception decompiling
     */
    public org.rascalmpl.java.lang.Object nextNull() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Lorg/rascalmpl/java/lang/Object;
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Number nextNumber() {
        char read;
        this.expect(JsonType.NUMBER);
        StringBuilder builder = new StringBuilder();
        boolean fractionalPart = false;
        while (Character.isDigit((char)(read = this.input.peek())) || read == '+' || read == '-' || read == 'e' || read == 'E' || read == '.') {
            builder.append(this.input.read());
            fractionalPart |= read == '.';
        }
        try {
            BigDecimal number = new BigDecimal(builder.toString());
            if (fractionalPart) {
                return Double.valueOf((double)number.doubleValue());
            }
            return Long.valueOf((long)number.longValue());
        }
        catch (NumberFormatException e) {
            throw new JsonException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.Unable to parse to a number: \u0001. \u0001"}, (String)String.valueOf((org.rascalmpl.java.lang.Object)builder), (String)String.valueOf((org.rascalmpl.java.lang.Object)this.input)));
        }
    }

    public String nextString() {
        this.expect(JsonType.STRING);
        return this.readString();
    }

    public Instant nextInstant() {
        Long time = (Long)this.read((Type)Long.class);
        return null != time ? Instant.ofEpochSecond((long)time.longValue()) : null;
    }

    public boolean hasNext() {
        if (this.stack.isEmpty()) {
            throw new JsonException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.Unable to determine if an item has next when not in a container type. \u0001"}, (String)String.valueOf((org.rascalmpl.java.lang.Object)this.input)));
        }
        this.skipWhitespace(this.input);
        if (this.input.peek() == ',') {
            this.input.read();
            return true;
        }
        JsonType type = this.peek();
        return type != JsonType.END_COLLECTION && type != JsonType.END_MAP;
    }

    public void beginArray() {
        this.expect(JsonType.START_COLLECTION);
        this.stack.addFirst((org.rascalmpl.java.lang.Object)Container.COLLECTION);
        this.input.read();
    }

    public void endArray() {
        this.expect(JsonType.END_COLLECTION);
        Container expectation = (Container)this.stack.removeFirst();
        if (expectation != Container.COLLECTION) {
            throw new JsonException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.Attempt to close a JSON List, but a JSON Object was expected. \u0001"}, (String)String.valueOf((org.rascalmpl.java.lang.Object)this.input)));
        }
        this.input.read();
    }

    public void beginObject() {
        this.expect(JsonType.START_MAP);
        this.stack.addFirst((org.rascalmpl.java.lang.Object)Container.MAP_NAME);
        this.input.read();
    }

    public void endObject() {
        this.expect(JsonType.END_MAP);
        Container expectation = (Container)this.stack.removeFirst();
        if (expectation != Container.MAP_NAME) {
            throw new JsonException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.Attempt to close a JSON Map, but not ready to. \u0001"}, (String)String.valueOf((org.rascalmpl.java.lang.Object)this.input)));
        }
        this.input.read();
    }

    public void skipValue() {
        switch (this.peek()) {
            case BOOLEAN: {
                this.nextBoolean();
                break;
            }
            case NAME: {
                this.nextName();
                break;
            }
            case NULL: {
                this.nextNull();
                break;
            }
            case NUMBER: {
                this.nextNumber();
                break;
            }
            case START_COLLECTION: {
                this.beginArray();
                while (this.hasNext()) {
                    this.skipValue();
                }
                this.endArray();
                break;
            }
            case START_MAP: {
                this.beginObject();
                while (this.hasNext()) {
                    this.nextName();
                    this.skipValue();
                }
                this.endObject();
                break;
            }
            case STRING: {
                this.nextString();
                break;
            }
            default: {
                throw new JsonException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.Cannot skip \u0001. \u0001"}, (String)String.valueOf((org.rascalmpl.java.lang.Object)this.peek()), (String)String.valueOf((org.rascalmpl.java.lang.Object)this.input)));
            }
        }
    }

    public <T extends org.rascalmpl.java.lang.Object> T read(Type type) {
        this.skipWhitespace(this.input);
        if (this.input.peek() == '\uffff') {
            return null;
        }
        return this.coercer.coerce(this, type, this.setter);
    }

    public <T extends org.rascalmpl.java.lang.Object> List<T> readArray(Type type) {
        ArrayList toReturn = new ArrayList();
        this.beginArray();
        while (this.hasNext()) {
            toReturn.add(this.coercer.coerce(this, type, this.setter));
        }
        this.endArray();
        return toReturn;
    }

    private boolean isReadingName() {
        return this.stack.peekFirst() == Container.MAP_NAME;
    }

    private void expect(JsonType type) {
        if (this.peek() != type) {
            throw new JsonException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.Expected to read a \u0001 but instead have: \u0001. \u0001"}, (String)String.valueOf((org.rascalmpl.java.lang.Object)type), (String)String.valueOf((org.rascalmpl.java.lang.Object)this.peek()), (String)String.valueOf((org.rascalmpl.java.lang.Object)this.input)));
        }
        Container top = (Container)this.stack.peekFirst();
        if (type == JsonType.NAME) {
            if (top == Container.MAP_NAME) {
                this.stack.removeFirst();
                this.stack.addFirst((org.rascalmpl.java.lang.Object)Container.MAP_VALUE);
                return;
            }
            if (top != null) {
                throw new JsonException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.Unexpected attempt to read name. \u0001"}, (String)String.valueOf((org.rascalmpl.java.lang.Object)this.input)));
            }
            return;
        }
        if (top == Container.MAP_VALUE) {
            this.stack.removeFirst();
            this.stack.addFirst((org.rascalmpl.java.lang.Object)Container.MAP_NAME);
        }
    }

    private <X extends org.rascalmpl.java.lang.Object> X read(String toCompare, Function<String, X> mapper) {
        this.skipWhitespace(this.input);
        for (int i = 0; i < toCompare.length(); ++i) {
            char read = this.input.read();
            if (read == toCompare.charAt(i)) continue;
            throw new JsonException(String.format((String)"org.rascalmpl.Unable to read %s. Saw %s at position %d. %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{toCompare, Character.valueOf((char)read), Integer.valueOf((int)i), this.input}));
        }
        return (X)mapper.apply((org.rascalmpl.java.lang.Object)toCompare);
    }

    private String readString() {
        this.input.read();
        StringBuilder builder = new StringBuilder();
        block5: while (true) {
            char c = this.input.read();
            switch (c) {
                case '\uffff': {
                    throw new JsonException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.Unterminated string: \u0001. \u0001"}, (String)String.valueOf((org.rascalmpl.java.lang.Object)builder), (String)String.valueOf((org.rascalmpl.java.lang.Object)this.input)));
                }
                case '\"': {
                    return builder.toString();
                }
                case '\\': {
                    this.readEscape(builder);
                    continue block5;
                }
            }
            builder.append(c);
        }
    }

    private void readEscape(StringBuilder builder) {
        char read = this.input.read();
        switch (read) {
            case 'b': {
                builder.append((String)"org.rascalmpl.\b");
                break;
            }
            case 'f': {
                builder.append((String)"org.rascalmpl.\f");
                break;
            }
            case 'n': {
                builder.append((String)"org.rascalmpl.\n");
                break;
            }
            case 'r': {
                builder.append((String)"org.rascalmpl.\r");
                break;
            }
            case 't': {
                builder.append((String)"org.rascalmpl.\t");
                break;
            }
            case 'u': {
                int result = 0;
                int multiplier = 4096;
                for (int i = 0; i < 4; ++i) {
                    char c = this.input.read();
                    int digit = Character.digit((char)c, (int)16);
                    if (digit == -1) {
                        throw new JsonException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.\u0001 is not a hexadecimal digit. \u0001"}, (char)c, (String)String.valueOf((org.rascalmpl.java.lang.Object)this.input)));
                    }
                    result += digit * multiplier;
                    multiplier /= 16;
                }
                builder.append((char)result);
                break;
            }
            case '\"': 
            case '/': 
            case '\\': {
                builder.append(read);
                break;
            }
            default: {
                throw new JsonException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.Unexpected escape code: \u0001. \u0001"}, (char)read, (String)String.valueOf((org.rascalmpl.java.lang.Object)this.input)));
            }
        }
    }

    private void skipWhitespace(Input input) {
        while (input.peek() != '\uffff' && Character.isWhitespace((char)input.peek())) {
            input.read();
        }
    }

    private static /* synthetic */ org.rascalmpl.java.lang.Object lambda$nextNull$0(String str) {
        return null;
    }

    private static final class Container
    extends Enum<Container> {
        public static final /* enum */ Container COLLECTION = new Container((String)"org.rascalmpl.COLLECTION", 0);
        public static final /* enum */ Container MAP_NAME = new Container((String)"org.rascalmpl.MAP_NAME", 1);
        public static final /* enum */ Container MAP_VALUE = new Container((String)"org.rascalmpl.MAP_VALUE", 2);
        private static final /* synthetic */ Container[] $VALUES;

        public static Container[] values() {
            return (Container[])$VALUES.clone();
        }

        public static Container valueOf(String name) {
            return (Container)Enum.valueOf(Container.class, (String)name);
        }

        private Container() {
            super((String)string, n);
        }

        private static /* synthetic */ Container[] $values() {
            return new Container[]{COLLECTION, MAP_NAME, MAP_VALUE};
        }

        static {
            $VALUES = Container.$values();
        }
    }
}

