/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.logging;

import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.java.util.TreeSet;
import org.rascalmpl.org.openqa.selenium.logging.LocalLogs;
import org.rascalmpl.org.openqa.selenium.logging.LogEntries;
import org.rascalmpl.org.openqa.selenium.logging.LogEntry;

class CompositeLocalLogs
extends LocalLogs {
    private final LocalLogs predefinedTypeLogger;
    private final LocalLogs allTypesLogger;

    protected CompositeLocalLogs(LocalLogs predefinedTypeLogger, LocalLogs allTypesLogger) {
        this.predefinedTypeLogger = predefinedTypeLogger;
        this.allTypesLogger = allTypesLogger;
    }

    @Override
    public LogEntries get(String logType) {
        if (this.predefinedTypeLogger.getAvailableLogTypes().contains((Object)logType)) {
            return this.predefinedTypeLogger.get(logType);
        }
        return this.allTypesLogger.get(logType);
    }

    @Override
    public Set<String> getAvailableLogTypes() {
        TreeSet toReturn = new TreeSet();
        toReturn.addAll((Collection)this.predefinedTypeLogger.getAvailableLogTypes());
        toReturn.addAll((Collection)this.allTypesLogger.getAvailableLogTypes());
        return toReturn;
    }

    @Override
    public void addEntry(String logType, LogEntry entry) {
        if (this.predefinedTypeLogger.getAvailableLogTypes().contains((Object)logType)) {
            this.predefinedTypeLogger.addEntry(logType, entry);
        } else {
            this.allTypesLogger.addEntry(logType, entry);
        }
    }
}

