/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.logging;

import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.HashMap;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.logging.Level;

public class LogLevelMapping
extends Object {
    private static final String DEBUG = "org.rascalmpl.DEBUG";
    private static final Map<Integer, Level> levelMap;

    public static Level normalize(Level level) {
        if (levelMap.containsKey((Object)Integer.valueOf((int)level.intValue()))) {
            return (Level)levelMap.get((Object)Integer.valueOf((int)level.intValue()));
        }
        if (level.intValue() >= Level.SEVERE.intValue()) {
            return Level.SEVERE;
        }
        if (level.intValue() >= Level.WARNING.intValue()) {
            return Level.WARNING;
        }
        if (level.intValue() >= Level.INFO.intValue()) {
            return Level.INFO;
        }
        return Level.FINE;
    }

    public static String getName(Level level) {
        Level normalized = LogLevelMapping.normalize(level);
        return normalized == Level.FINE ? "org.rascalmpl.DEBUG" : normalized.getName();
    }

    public static Level toLevel(String logLevelName) {
        if (logLevelName == null || logLevelName.isEmpty()) {
            return Level.INFO;
        }
        if (logLevelName.equals((Object)"org.rascalmpl.DEBUG")) {
            return Level.FINE;
        }
        return (Level)levelMap.get((Object)Integer.valueOf((int)Level.parse((String)logLevelName).intValue()));
    }

    static {
        Level[] supportedLevels = new Level[]{Level.ALL, Level.FINE, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF};
        HashMap builder = new HashMap();
        for (Level level : supportedLevels) {
            builder.put((Object)Integer.valueOf((int)level.intValue()), (Object)level);
        }
        levelMap = Collections.unmodifiableMap((Map)builder);
    }
}

