/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.logging;

import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.SecurityException;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.java.util.ArrayDeque;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.logging.Handler;
import org.rascalmpl.java.util.logging.LogRecord;
import org.rascalmpl.org.openqa.selenium.logging.LogEntry;

public class LoggingHandler
extends Handler {
    private static final int MAX_RECORDS = 1000;
    private ArrayDeque<LogEntry> records = new ArrayDeque();
    private static final LoggingHandler INSTANCE = new LoggingHandler();

    private LoggingHandler() {
    }

    public static LoggingHandler getInstance() {
        return INSTANCE;
    }

    public synchronized Collection<LogEntry> getRecords() {
        return Collections.unmodifiableCollection(this.records);
    }

    public synchronized void publish(LogRecord logRecord) {
        if (this.isLoggable(logRecord)) {
            if (this.records.size() > 1000) {
                this.records.remove();
            }
            this.records.add((Object)new LogEntry(logRecord.getLevel(), logRecord.getMillis(), (String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.\u0001 \u0001.\u0001 \u0001"}, (String)logRecord.getLoggerName(), (String)logRecord.getSourceClassName(), (String)logRecord.getSourceMethodName(), (String)logRecord.getMessage())));
        }
    }

    public synchronized void flush() {
        this.records = new ArrayDeque();
    }

    public synchronized void close() throws SecurityException {
        this.records.clear();
    }
}

