/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.logging;

import org.rascalmpl.java.io.Serializable;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.HashMap;
import org.rascalmpl.java.util.HashSet;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.java.util.TreeMap;
import org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.org.openqa.selenium.Beta;
import org.rascalmpl.org.openqa.selenium.logging.LogLevelMapping;

public class LoggingPreferences
extends Object
implements Serializable {
    private static final long serialVersionUID = 6708028456766320675L;
    private final Map<String, Level> prefs = new HashMap();

    public void enable(String logType, Level level) {
        this.prefs.put((Object)logType, (Object)level);
    }

    public Set<String> getEnabledLogTypes() {
        return new HashSet((Collection)this.prefs.keySet());
    }

    public Level getLevel(String logType) {
        return this.prefs.get((Object)logType) == null ? Level.OFF : (Level)this.prefs.get((Object)logType);
    }

    public LoggingPreferences addPreferences(LoggingPreferences prefs) {
        if (prefs == null) {
            return this;
        }
        for (String logType : prefs.getEnabledLogTypes()) {
            this.enable(logType, prefs.getLevel(logType));
        }
        return this;
    }

    public int hashCode() {
        return this.prefs.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LoggingPreferences)) {
            return false;
        }
        LoggingPreferences that = (LoggingPreferences)o;
        return this.prefs.equals(that.prefs);
    }

    @Beta
    public Map<String, Object> toJson() {
        TreeMap converted = new TreeMap();
        for (String logType : this.getEnabledLogTypes()) {
            converted.put((Object)logType, (Object)LogLevelMapping.getName(this.getLevel(logType)));
        }
        return converted;
    }
}

